#ifndef HINT_MANAGER_H
#define HINT_MANAGER_H

#include "configuration_aware_object.h"
#include "gadu.h"
#include "hint.h"
#include "main_configuration_window.h"
#include "userbox.h"

#include "../notify/notify.h"

class ChatWidget;

class QSpinBox;

class HintsConfigurationWidget;

class HintManager : public Notifier, public ConfigurationUiHandler, public ToolTipClass, ConfigurationAwareObject
{
	Q_OBJECT

private:
	QFrame *frame;
	QVBoxLayout *layout;
	QTimer *hint_timer;
	QList<Hint *> hints;
	QFrame *tipFrame;

	QSpinBox *minimumWidth;
	QSpinBox *maximumWidth;
	QWidget *overUserSyntax;
	HintsConfigurationWidget *configurationWidget;

	QMap<QPair<UserListElements, QString>, Hint *> linkedHints;

	/**
		ustala rg, od ktrego bdzie liczona pozycja grupy dymkw
	**/
	void setLayoutDirection();

	void processButtonPress(const QString &buttonName, Hint *hint);

	void showNewMessage(const QString &configurationDirective, const QString &title, const QString &contentTitle, UserListElements senders, const QString &msg);

	// TODO: usun w 0.6
	void realCopyConfiguration(const QString &fromHint, const QString &toHint);
	void import_0_5_0_Configuration();
	void import_0_5_0_Configuration_fromTo(const QString &from, const QString &to,
		const QString &syntax = QString::null, const QString &detailSyntax = QString::null);
	void createDefaultConfiguration();

private slots:
	/**
		mina sekunda: aktualizuje czasy wszystkich dymkw
		usuwa te, ktrym min czas
	**/
	void oneSecond();

	/**
		przesuwa ca grup hintw zgodnie z preferowanym rozmiarem grupy
		i wykryt/okrelon w konfiguracji pozycj traya
	**/
	void setHint();

	/**
		na dymku o numerze id kliknito lewym przyciskiem myszy
		w zalenoci od konfiguracji otwierana jest nowa rozmowa, dymek jest kasowany lub kasowane s wszystkie
	**/
	void leftButtonSlot(Hint *hint);

	/**
		na dymku o numerze id kliknito prawym przyciskiem myszy
		w zalenoci od konfiguracji otwierana jest nowa rozmowa, dymek jest kasowany lub kasowane s wszystkie
	**/
	void rightButtonSlot(Hint *hint);

	/**
		na dymku o numerze id kliknito rodkowym przyciskiem myszy
		w zalenoci od konfiguracji otwierana jest nowa rozmowa, dymek jest kasowany lub kasowane s wszystkie
	**/
	void midButtonSlot(Hint *hint);

	void deleteHint(Hint *hint);
	void deleteHintAndUpdate(Hint *hint);

	void notificationClosed(Notification *notification);

	/**
		Pokazuje dymek zwizany z notyfikacj.
	**/
	Hint *addHint(Notification *notification);

	/**
		jeeli dymek dotyczy konkrentej osoby lub grupy osb, to otwierane jest okno chatu
		dymek jest kasowany
	**/
	void openChat(Hint *hint);

	void chatWidgetActivated(ChatWidget *chat);

	/**
		usuwa wszystkie dymki
	**/
	void deleteAllHints();

	void minimumWidthChanged(int value);
	void maximumWidthChanged(int value);

	void toolTipClassesHighlighted(const QString &value);

	void hintUpdated();

protected:
	virtual void configurationUpdated();

signals:
	/**
		HintManager szuka pozycji traya, aby wywietli w jego okolicy dymki
	**/
	void searchingForTrayPosition(QPoint& pos);

public:
	HintManager(QWidget *parent=0, const char *name=0);
	~HintManager();

	virtual CallbackCapacity callbackCapacity() { return CallbackSupported; }
	virtual void notify(Notification *notification);

	virtual void showToolTip(const QPoint &, const UserListElement &);
	virtual void hideToolTip();

	virtual void copyConfiguration(const QString &fromEvent, const QString &toEvent);

	virtual void mainConfigurationWindowCreated(MainConfigurationWindow *mainConfigurationWindow);
	virtual NotifierConfigurationWidget *createConfigurationWidget(QWidget *parent = 0, char *name = 0);

};

extern HintManager *hint_manager;

#endif
