
########################################################
# K3D_HAPY_CONFIG

AC_DEFUN([HAPY_CHECK_SPN_STRING_COMPARE], [
AC_CACHE_CHECK(for non-standard std::string::compare profile,
	ac_cv_have_spn_string_compare, [
        AC_TRY_COMPILE([
                #include <string>
        ],[
                const string s1 = "abcd";
                const string s2 = "bc";
		return (s1.compare(s2, 1, s2.size()) == 0) ? 0 : 255;
        ],[
                ac_cv_have_spn_string_compare="yes";
        ],[
                ac_cv_have_spn_string_compare="no";
        ])
])
if test "x$ac_cv_have_spn_string_compare" = xyes; then
        AC_DEFINE(HAPY_HAVE_SPN_STRING_COMPARE, 1, [Define to 1 if you have non-standard std::string::compare profile])
fi
])

AC_DEFUN([HAPY_CHECK_NUMERIC_LIMITS], [
AC_CACHE_CHECK(for std::numeric_limits,
	ac_cv_have_numeric_limits, [
        AC_TRY_COMPILE([
                #include <limits>
		// try #including non-standard ones too?
        ],[
		return std::numeric_limits<unsigned long>::max() == 0;
        ],[
                ac_cv_have_numeric_limits="yes";
        ],[
                ac_cv_have_numeric_limits="no";
        ])
])
if test "x$ac_cv_have_numeric_limits" = xyes; then
        AC_DEFINE(HAPY_HAVE_NUMERIC_LIMITS, 1, [Define to 1 if you have std::numeric_limits template])
fi
])

AC_DEFUN([HAPY_CHECK_STD_ITERATOR_TYPE], [
AC_CACHE_CHECK(for std::iterator, ac_cv_have_std_iterator_type, [
	AC_TRY_COMPILE([
		#include <iterator>
		template <typename V, typename D>
		struct std_bidirectional_iterator:
			public std::iterator<std::bidirectional_iterator_tag, V, D> {
		};
	],[
		typedef std_bidirectional_iterator<int*,int> MyIterator;
		return 0;
	],[
		ac_cv_have_std_iterator_type="yes";
	],[
		ac_cv_have_std_iterator_type="no";
	])
])
if test "x$ac_cv_have_std_iterator_type" = xyes; then
        AC_DEFINE(HAPY_HAVE_STD_ITERATOR_TYPE, 1, [Define to 1 if you have std::iterator template])
fi
])

