import unittest
import mx.DateTime
import jppy
import baseclass

class todoTest(baseclass.baseTest):
    def setUp(self):
        baseclass.baseTest.setUp(self)
        self.book = jppy.taskList()
        self.t = jppy.Todo()

    def testSetTodoValues(self):
        keys = self.t.keys()
        for key in keys:
            if key == "due":
                self.t[key] = mx.DateTime.now()
            elif key in ("complete", "priority"):
                self.t[key] = 1
            elif key in ("descrption", "note"):
                self.t[key] = "String"
        for key in keys[0:5]:
            self.t[key]

    def testTodoValueBounds(self):
        def setComplete(t, v):
            t['complete'] = v
        def setPriority(t, v):
            t['priority'] = v        
        self.assertRaises(ValueError, setComplete, self.t, 2)
        self.assertRaises(ValueError, setComplete, self.t, -1)
        setComplete(self.t, True)
        setComplete(self.t, False)        
        self.assertRaises(ValueError, setPriority, self.t, 6)
        self.assertRaises(ValueError, setPriority, self.t, -1)

    def testTodoLengthBounds(self):
        def setDescription(t, v):
            t['description'] = v        
        self.assertRaises(ValueError, setDescription, self.t, "X" * 257)
        setDescription(self.t, "X" * 256)        

def suite():
    suite = unittest.TestSuite((unittest.makeSuite(todoTest),))
    
    return suite
