import unittest
import mx.DateTime
import jppy
import baseclass
import types

class contactTest(baseclass.baseTest):
    def setUp(self):
        baseclass.baseTest.setUp(self)
        self.book = jppy.addressBook()
        self.t = jppy.Contact()

    def testLabels(self):
        assert type(self.book.getCategories()) == types.ListType
        assert type(self.book.getAddressLabels()) == types.ListType
        assert type(self.book.getIMLabels()) == types.ListType
        assert type(self.book.getPhoneLabels()) == types.ListType

    def testVCard(self):
        c = jppy.Contact()
        c["address1"] = "Flat 4\nSomewhere Street\nMore Street"
        c["note"]     = "This is a\nmultiline\nnote"
        assert "4=0D=0AS" in c.vcard()

def suite():
    suite = unittest.TestSuite((unittest.makeSuite(contactTest),))
    
    return suite
