/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import ucar.unidata.io.RandomAccessFile;

public class HTTPRandomAccessFile
extends RandomAccessFile {
    public static int defaultHTTPBufferSize = 20000;
    private static HttpClient _client;
    private String url;
    private long total_length = 0L;
    private boolean debug = false;
    private boolean debugDetails = false;

    public static void setHttpClient(HttpClient client) {
        _client = client;
    }

    public static HttpClient getHttpClient() {
        return _client;
    }

    private synchronized void initHttpClient() {
        if (_client != null) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        _client = new HttpClient((HttpConnectionManager)connectionManager);
    }

    public HTTPRandomAccessFile(String url) throws IOException {
        this(url, defaultHTTPBufferSize);
        this.location = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPRandomAccessFile(String url, int bufferSize) throws IOException {
        super(bufferSize);
        this.file = null;
        this.url = url;
        this.location = url;
        this.initHttpClient();
        boolean needtest = true;
        HeadMethod method = null;
        try {
            method = new HeadMethod(url);
            method.setFollowRedirects(true);
            this.doConnect((HttpMethod)method);
            Header head = method.getResponseHeader("Accept-Ranges");
            if (head == null) {
                needtest = true;
            } else if (head.getValue().equalsIgnoreCase("bytes")) {
                needtest = false;
            } else if (head.getValue().equalsIgnoreCase("none")) {
                throw new IOException("Server does not support byte Ranges");
            }
            head = method.getResponseHeader("Content-Length");
            if (head == null) {
                throw new IOException("Server does not support Content-Length");
            }
            try {
                this.total_length = Long.parseLong(head.getValue());
            }
            catch (NumberFormatException e) {
                throw new IOException("Server has malformed Content-Length header");
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        if (needtest && !this.rangeOk(url)) {
            throw new IOException("Server does not support byte Ranges");
        }
        if (debugLeaks) {
            openFiles.add(this.location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rangeOk(String url) {
        GetMethod method = null;
        try {
            method = new GetMethod(url);
            method.setFollowRedirects(true);
            method.setRequestHeader("Range", "bytes=0-1");
            this.doConnect((HttpMethod)method);
            int code = method.getStatusCode();
            if (code != 206) {
                throw new IOException("Server does not support Range requests, code= " + code);
            }
            method.getResponseBody();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void doConnect(HttpMethod method) throws IOException {
        int statusCode = _client.executeMethod(method);
        if (statusCode == 404) {
            throw new FileNotFoundException(this.url + " " + method.getStatusLine());
        }
        if (statusCode >= 300) {
            throw new IOException(this.url + " " + method.getStatusLine());
        }
        if (this.debugDetails) {
            this.printHeaders("Request: " + method.getName() + " " + method.getPath(), method.getRequestHeaders());
            this.printHeaders("Response: " + method.getStatusCode(), method.getResponseHeaders());
        }
    }

    private void printHeaders(String title, Header[] heads) {
        System.out.println(title);
        for (Header head : heads) {
            System.out.print("  " + head.toString());
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int read_(long pos, byte[] buff, int offset, int len) throws IOException {
        long end = pos + (long)len - 1L;
        if (end >= this.total_length) {
            end = this.total_length - 1L;
        }
        if (this.debug) {
            System.out.println(" HTTPRandomAccessFile bytes=" + pos + "-" + end + ": ");
        }
        GetMethod method = null;
        try {
            method = new GetMethod(this.url);
            method.setFollowRedirects(true);
            method.setRequestHeader("Range", "bytes=" + pos + "-" + end);
            this.doConnect((HttpMethod)method);
            int code = method.getStatusCode();
            if (code != 206) {
                throw new IOException("Server does not support Range requests, code= " + code);
            }
            String s = method.getResponseHeader("Content-Length").getValue();
            if (s == null) {
                throw new IOException("Server does not send Content-Length header");
            }
            int readLen = Integer.parseInt(s);
            readLen = Math.min(len, readLen);
            InputStream is = method.getResponseBodyAsStream();
            int n = readLen = this.copy(is, buff, offset, readLen);
            return n;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private int copy(InputStream in, byte[] buff, int offset, int want) throws IOException {
        int bytesRead;
        int done = 0;
        while (want > 0 && (bytesRead = in.read(buff, offset + done, want)) != -1) {
            done += bytesRead;
            want -= bytesRead;
        }
        return done;
    }

    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        int n = (int)nbytes;
        byte[] buff = new byte[n];
        int done = this.read_(offset, buff, 0, n);
        dest.write(ByteBuffer.wrap(buff));
        return done;
    }

    public long length() throws IOException {
        long fileLength = this.total_length;
        if (fileLength < this.dataEnd) {
            return this.dataEnd;
        }
        return fileLength;
    }
}

