/** @file stats_cmdline.hpp
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef STATS_CMDLINE_H
#define STATS_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef STATS_CMDLINE_PACKAGE
/** @brief the program name (used for printing errors) */
#define STATS_CMDLINE_PACKAGE "jellyfish stats"
#endif

#ifndef STATS_CMDLINE_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define STATS_CMDLINE_PACKAGE_NAME "jellyfish stats"
#endif

#ifndef STATS_CMDLINE_VERSION
/** @brief the program version */
#define STATS_CMDLINE_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct stats_args
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int recompute_flag;	/**< @brief Recompute (default=off).  */
  const char *recompute_help; /**< @brief Recompute help description.  */
  long lower_count_arg;	/**< @brief Don't consider k-mer with count < lower-count.  */
  char * lower_count_orig;	/**< @brief Don't consider k-mer with count < lower-count original value given at command line.  */
  const char *lower_count_help; /**< @brief Don't consider k-mer with count < lower-count help description.  */
  long upper_count_arg;	/**< @brief Don't consider k-mer with count > upper-count.  */
  char * upper_count_orig;	/**< @brief Don't consider k-mer with count > upper-count original value given at command line.  */
  const char *upper_count_help; /**< @brief Don't consider k-mer with count > upper-count help description.  */
  int verbose_flag;	/**< @brief Verbose (default=off).  */
  const char *verbose_help; /**< @brief Verbose help description.  */
  char * output_arg;	/**< @brief Output file (default='/dev/fd/1').  */
  char * output_orig;	/**< @brief Output file original value given at command line.  */
  const char *output_help; /**< @brief Output file help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int recompute_given ;	/**< @brief Whether recompute was given.  */
  unsigned int lower_count_given ;	/**< @brief Whether lower-count was given.  */
  unsigned int upper_count_given ;	/**< @brief Whether upper-count was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct stats_cmdline_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure stats_args (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure stats_args (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *stats_args_purpose;
/** @brief the usage string of the program */
extern const char *stats_args_usage;
/** @brief all the lines making the help output */
extern const char *stats_args_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *stats_args_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int stats_cmdline (int argc, char **argv,
  struct stats_args *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use stats_cmdline_ext() instead
 */
int stats_cmdline2 (int argc, char **argv,
  struct stats_args *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int stats_cmdline_ext (int argc, char **argv,
  struct stats_args *args_info,
  struct stats_cmdline_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int stats_cmdline_dump(FILE *outfile,
  struct stats_args *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int stats_cmdline_file_save(const char *filename,
  struct stats_args *args_info);

/**
 * Print the help
 */
void stats_cmdline_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void stats_cmdline_print_full_help(void);
/**
 * Print the version
 */
void stats_cmdline_print_version(void);

/**
 * Initializes all the fields a stats_cmdline_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void stats_cmdline_params_init(struct stats_cmdline_params *params);

/**
 * Allocates dynamically a stats_cmdline_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized stats_cmdline_params structure
 */
struct stats_cmdline_params *stats_cmdline_params_create(void);

/**
 * Initializes the passed stats_args structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void stats_cmdline_init (struct stats_args *args_info);
/**
 * Deallocates the string fields of the stats_args structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void stats_cmdline_free (struct stats_args *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int stats_cmdline_required (struct stats_args *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* STATS_CMDLINE_H */
