(in-package :crypto-tests)


;;; "standard" test vectors (from NIST, I believe)

(ecb-mode-test "0000000000000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "FFFFFFFFFFFFFFFF" "FFFFFFFFFFFFFFFF" "7359B2163E4EDC58")
(ecb-mode-test "3000000000000000" "1000000000000001" "958E6E627A05557B")
(ecb-mode-test "1111111111111111" "1111111111111111" "F40379AB9E0EC533")
(ecb-mode-test "0123456789ABCDEF" "1111111111111111" "17668DFC7292532D")
(ecb-mode-test "1111111111111111" "0123456789ABCDEF" "8A5AE1F81AB8F2DD")
(ecb-mode-test "0000000000000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "FEDCBA9876543210" "0123456789ABCDEF" "ED39D950FA74BCC4")
(ecb-mode-test "7CA110454A1A6E57" "01A1D6D039776742" "690F5B0D9A26939B")
(ecb-mode-test "0131D9619DC1376E" "5CD54CA83DEF57DA" "7A389D10354BD271")
(ecb-mode-test "07A1133E4A0B2686" "0248D43806F67172" "868EBB51CAB4599A")
(ecb-mode-test "3849674C2602319E" "51454B582DDF440A" "7178876E01F19B2A")
(ecb-mode-test "04B915BA43FEB5B6" "42FD443059577FA2" "AF37FB421F8C4095")
(ecb-mode-test "0113B970FD34F2CE" "059B5E0851CF143A" "86A560F10EC6D85B")
(ecb-mode-test "0170F175468FB5E6" "0756D8E0774761D2" "0CD3DA020021DC09")
(ecb-mode-test "43297FAD38E373FE" "762514B829BF486A" "EA676B2CB7DB2B7A")
(ecb-mode-test "07A7137045DA2A16" "3BDD119049372802" "DFD64A815CAF1A0F")
(ecb-mode-test "04689104C2FD3B2F" "26955F6835AF609A" "5C513C9C4886C088")
(ecb-mode-test "37D06BB516CB7546" "164D5E404F275232" "0A2AEEAE3FF4AB77")
(ecb-mode-test "1F08260D1AC2465E" "6B056E18759F5CCA" "EF1BF03E5DFA575A")
(ecb-mode-test "584023641ABA6176" "004BD6EF09176062" "88BF0DB6D70DEE56")
(ecb-mode-test "025816164629B007" "480D39006EE762F2" "A1F9915541020B56")
(ecb-mode-test "49793EBC79B3258F" "437540C8698F3CFA" "6FBF1CAFCFFD0556")
(ecb-mode-test "4FB05E1515AB73A7" "072D43A077075292" "2F22E49BAB7CA1AC")
(ecb-mode-test "49E95D6D4CA229BF" "02FE55778117F12A" "5A6B612CC26CCE4A")
(ecb-mode-test "018310DC409B26D6" "1D9D5C5018F728C2" "5F4C038ED12B2E41")
(ecb-mode-test "1C587F1C13924FEF" "305532286D6F295A" "63FAC0D034D9F793")
(ecb-mode-test "0101010101010101" "0123456789ABCDEF" "617B3A0CE8F07100")
(ecb-mode-test "1F1F1F1F0E0E0E0E" "0123456789ABCDEF" "DB958605F8C8C606")
(ecb-mode-test "E0FEE0FEF1FEF1FE" "0123456789ABCDEF" "EDBFD1C66C29CCC7")
(ecb-mode-test "0000000000000000" "FFFFFFFFFFFFFFFF" "355550B2150E2451")
(ecb-mode-test "FFFFFFFFFFFFFFFF" "0000000000000000" "CAAAAF4DEAF1DBAE")
(ecb-mode-test "0123456789ABCDEF" "0000000000000000" "D5D44FF720683D0D")
(ecb-mode-test "FEDCBA9876543210" "FFFFFFFFFFFFFFFF" "2A2BB008DF97C2F2")


;;; tests from NESSIE (http://www.cryptonessie.org/)

(ecb-mode-test "8000000000000000" "0000000000000000" "95A8D72813DAA94D")
(ecb-mode-test "4000000000000000" "0000000000000000" "0EEC1487DD8C26D5")
(ecb-mode-test "2000000000000000" "0000000000000000" "7AD16FFB79C45926")
(ecb-mode-test "1000000000000000" "0000000000000000" "D3746294CA6A6CF3")
(ecb-mode-test "0800000000000000" "0000000000000000" "809F5F873C1FD761")
(ecb-mode-test "0400000000000000" "0000000000000000" "C02FAFFEC989D1FC")
(ecb-mode-test "0200000000000000" "0000000000000000" "4615AA1D33E72F10")
(ecb-mode-test "0100000000000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0080000000000000" "0000000000000000" "2055123350C00858")
(ecb-mode-test "0040000000000000" "0000000000000000" "DF3B99D6577397C8")
(ecb-mode-test "0020000000000000" "0000000000000000" "31FE17369B5288C9")
(ecb-mode-test "0010000000000000" "0000000000000000" "DFDD3CC64DAE1642")
(ecb-mode-test "0008000000000000" "0000000000000000" "178C83CE2B399D94")
(ecb-mode-test "0004000000000000" "0000000000000000" "50F636324A9B7F80")
(ecb-mode-test "0002000000000000" "0000000000000000" "A8468EE3BC18F06D")
(ecb-mode-test "0001000000000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0000800000000000" "0000000000000000" "A2DC9E92FD3CDE92")
(ecb-mode-test "0000400000000000" "0000000000000000" "CAC09F797D031287")
(ecb-mode-test "0000200000000000" "0000000000000000" "90BA680B22AEB525")
(ecb-mode-test "0000100000000000" "0000000000000000" "CE7A24F350E280B6")
(ecb-mode-test "0000080000000000" "0000000000000000" "882BFF0AA01A0B87")
(ecb-mode-test "0000040000000000" "0000000000000000" "25610288924511C2")
(ecb-mode-test "0000020000000000" "0000000000000000" "C71516C29C75D170")
(ecb-mode-test "0000010000000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0000008000000000" "0000000000000000" "5199C29A52C9F059")
(ecb-mode-test "0000004000000000" "0000000000000000" "C22F0A294A71F29F")
(ecb-mode-test "0000002000000000" "0000000000000000" "EE371483714C02EA")
(ecb-mode-test "0000001000000000" "0000000000000000" "A81FBD448F9E522F")
(ecb-mode-test "0000000800000000" "0000000000000000" "4F644C92E192DFED")
(ecb-mode-test "0000000400000000" "0000000000000000" "1AFA9A66A6DF92AE")
(ecb-mode-test "0000000200000000" "0000000000000000" "B3C1CC715CB879D8")
(ecb-mode-test "0000000100000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0000000080000000" "0000000000000000" "19D032E64AB0BD8B")
(ecb-mode-test "0000000040000000" "0000000000000000" "3CFAA7A7DC8720DC")
(ecb-mode-test "0000000020000000" "0000000000000000" "B7265F7F447AC6F3")
(ecb-mode-test "0000000010000000" "0000000000000000" "9DB73B3C0D163F54")
(ecb-mode-test "0000000008000000" "0000000000000000" "8181B65BABF4A975")
(ecb-mode-test "0000000004000000" "0000000000000000" "93C9B64042EAA240")
(ecb-mode-test "0000000002000000" "0000000000000000" "5570530829705592")
(ecb-mode-test "0000000001000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0000000000800000" "0000000000000000" "8638809E878787A0")
(ecb-mode-test "0000000000400000" "0000000000000000" "41B9A79AF79AC208")
(ecb-mode-test "0000000000200000" "0000000000000000" "7A9BE42F2009A892")
(ecb-mode-test "0000000000100000" "0000000000000000" "29038D56BA6D2745")
(ecb-mode-test "0000000000080000" "0000000000000000" "5495C6ABF1E5DF51")
(ecb-mode-test "0000000000040000" "0000000000000000" "AE13DBD561488933")
(ecb-mode-test "0000000000020000" "0000000000000000" "024D1FFA8904E389")
(ecb-mode-test "0000000000010000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0000000000008000" "0000000000000000" "D1399712F99BF02E")
(ecb-mode-test "0000000000004000" "0000000000000000" "14C1D7C1CFFEC79E")
(ecb-mode-test "0000000000002000" "0000000000000000" "1DE5279DAE3BED6F")
(ecb-mode-test "0000000000001000" "0000000000000000" "E941A33F85501303")
(ecb-mode-test "0000000000000800" "0000000000000000" "DA99DBBC9A03F379")
(ecb-mode-test "0000000000000400" "0000000000000000" "B7FC92F91D8E92E9")
(ecb-mode-test "0000000000000200" "0000000000000000" "AE8E5CAA3CA04E85")
(ecb-mode-test "0000000000000100" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0000000000000080" "0000000000000000" "9CC62DF43B6EED74")
(ecb-mode-test "0000000000000040" "0000000000000000" "D863DBB5C59A91A0")
(ecb-mode-test "0000000000000020" "0000000000000000" "A1AB2190545B91D7")
(ecb-mode-test "0000000000000010" "0000000000000000" "0875041E64C570F7")
(ecb-mode-test "0000000000000008" "0000000000000000" "5A594528BEBEF1CC")
(ecb-mode-test "0000000000000004" "0000000000000000" "FCDB3291DE21F0C0")
(ecb-mode-test "0000000000000002" "0000000000000000" "869EFD7F9F265A09")
(ecb-mode-test "0000000000000001" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0000000000000000" "8000000000000000" "95F8A5E5DD31D900")
(ecb-mode-test "0000000000000000" "4000000000000000" "DD7F121CA5015619")
(ecb-mode-test "0000000000000000" "2000000000000000" "2E8653104F3834EA")
(ecb-mode-test "0000000000000000" "1000000000000000" "4BD388FF6CD81D4F")
(ecb-mode-test "0000000000000000" "0800000000000000" "20B9E767B2FB1456")
(ecb-mode-test "0000000000000000" "0400000000000000" "55579380D77138EF")
(ecb-mode-test "0000000000000000" "0200000000000000" "6CC5DEFAAF04512F")
(ecb-mode-test "0000000000000000" "0100000000000000" "0D9F279BA5D87260")
(ecb-mode-test "0000000000000000" "0080000000000000" "D9031B0271BD5A0A")
(ecb-mode-test "0000000000000000" "0040000000000000" "424250B37C3DD951")
(ecb-mode-test "0000000000000000" "0020000000000000" "B8061B7ECD9A21E5")
(ecb-mode-test "0000000000000000" "0010000000000000" "F15D0F286B65BD28")
(ecb-mode-test "0000000000000000" "0008000000000000" "ADD0CC8D6E5DEBA1")
(ecb-mode-test "0000000000000000" "0004000000000000" "E6D5F82752AD63D1")
(ecb-mode-test "0000000000000000" "0002000000000000" "ECBFE3BD3F591A5E")
(ecb-mode-test "0000000000000000" "0001000000000000" "F356834379D165CD")
(ecb-mode-test "0000000000000000" "0000800000000000" "2B9F982F20037FA9")
(ecb-mode-test "0000000000000000" "0000400000000000" "889DE068A16F0BE6")
(ecb-mode-test "0000000000000000" "0000200000000000" "E19E275D846A1298")
(ecb-mode-test "0000000000000000" "0000100000000000" "329A8ED523D71AEC")
(ecb-mode-test "0000000000000000" "0000080000000000" "E7FCE22557D23C97")
(ecb-mode-test "0000000000000000" "0000040000000000" "12A9F5817FF2D65D")
(ecb-mode-test "0000000000000000" "0000020000000000" "A484C3AD38DC9C19")
(ecb-mode-test "0000000000000000" "0000010000000000" "FBE00A8A1EF8AD72")
(ecb-mode-test "0000000000000000" "0000008000000000" "750D079407521363")
(ecb-mode-test "0000000000000000" "0000004000000000" "64FEED9C724C2FAF")
(ecb-mode-test "0000000000000000" "0000002000000000" "F02B263B328E2B60")
(ecb-mode-test "0000000000000000" "0000001000000000" "9D64555A9A10B852")
(ecb-mode-test "0000000000000000" "0000000800000000" "D106FF0BED5255D7")
(ecb-mode-test "0000000000000000" "0000000400000000" "E1652C6B138C64A5")
(ecb-mode-test "0000000000000000" "0000000200000000" "E428581186EC8F46")
(ecb-mode-test "0000000000000000" "0000000100000000" "AEB5F5EDE22D1A36")
(ecb-mode-test "0000000000000000" "0000000080000000" "E943D7568AEC0C5C")
(ecb-mode-test "0000000000000000" "0000000040000000" "DF98C8276F54B04B")
(ecb-mode-test "0000000000000000" "0000000020000000" "B160E4680F6C696F")
(ecb-mode-test "0000000000000000" "0000000010000000" "FA0752B07D9C4AB8")
(ecb-mode-test "0000000000000000" "0000000008000000" "CA3A2B036DBC8502")
(ecb-mode-test "0000000000000000" "0000000004000000" "5E0905517BB59BCF")
(ecb-mode-test "0000000000000000" "0000000002000000" "814EEB3B91D90726")
(ecb-mode-test "0000000000000000" "0000000001000000" "4D49DB1532919C9F")
(ecb-mode-test "0000000000000000" "0000000000800000" "25EB5FC3F8CF0621")
(ecb-mode-test "0000000000000000" "0000000000400000" "AB6A20C0620D1C6F")
(ecb-mode-test "0000000000000000" "0000000000200000" "79E90DBC98F92CCA")
(ecb-mode-test "0000000000000000" "0000000000100000" "866ECEDD8072BB0E")
(ecb-mode-test "0000000000000000" "0000000000080000" "8B54536F2F3E64A8")
(ecb-mode-test "0000000000000000" "0000000000040000" "EA51D3975595B86B")
(ecb-mode-test "0000000000000000" "0000000000020000" "CAFFC6AC4542DE31")
(ecb-mode-test "0000000000000000" "0000000000010000" "8DD45A2DDF90796C")
(ecb-mode-test "0000000000000000" "0000000000008000" "1029D55E880EC2D0")
(ecb-mode-test "0000000000000000" "0000000000004000" "5D86CB23639DBEA9")
(ecb-mode-test "0000000000000000" "0000000000002000" "1D1CA853AE7C0C5F")
(ecb-mode-test "0000000000000000" "0000000000001000" "CE332329248F3228")
(ecb-mode-test "0000000000000000" "0000000000000800" "8405D1ABE24FB942")
(ecb-mode-test "0000000000000000" "0000000000000400" "E643D78090CA4207")
(ecb-mode-test "0000000000000000" "0000000000000200" "48221B9937748A23")
(ecb-mode-test "0000000000000000" "0000000000000100" "DD7C0BBD61FAFD54")
(ecb-mode-test "0000000000000000" "0000000000000080" "2FBC291A570DB5C4")
(ecb-mode-test "0000000000000000" "0000000000000040" "E07C30D7E4E26E12")
(ecb-mode-test "0000000000000000" "0000000000000020" "0953E2258E8E90A1")
(ecb-mode-test "0000000000000000" "0000000000000010" "5B711BC4CEEBF2EE")
(ecb-mode-test "0000000000000000" "0000000000000008" "CC083F1E6D9E85F6")
(ecb-mode-test "0000000000000000" "0000000000000004" "D2FD8867D50D2DFE")
(ecb-mode-test "0000000000000000" "0000000000000002" "06E7EA22CE92708F")
(ecb-mode-test "0000000000000000" "0000000000000001" "166B40B44ABA4BD6")
(ecb-mode-test "0000000000000000" "0000000000000000" "8CA64DE9C1B123A7")
(ecb-mode-test "0101010101010101" "0101010101010101" "994D4DC157B96C52")
(ecb-mode-test "0202020202020202" "0202020202020202" "E127C2B61D98E6E2")
(ecb-mode-test "0303030303030303" "0303030303030303" "984C91D78A269CE3")
(ecb-mode-test "0404040404040404" "0404040404040404" "1F4570BB77550683")
(ecb-mode-test "0505050505050505" "0505050505050505" "3990ABF98D672B16")
(ecb-mode-test "0606060606060606" "0606060606060606" "3F5150BBA081D585")
(ecb-mode-test "0707070707070707" "0707070707070707" "C65242248C9CF6F2")
(ecb-mode-test "0808080808080808" "0808080808080808" "10772D40FAD24257")
(ecb-mode-test "0909090909090909" "0909090909090909" "F0139440647A6E7B")
(ecb-mode-test "0A0A0A0A0A0A0A0A" "0A0A0A0A0A0A0A0A" "0A288603044D740C")
(ecb-mode-test "0B0B0B0B0B0B0B0B" "0B0B0B0B0B0B0B0B" "6359916942F7438F")
(ecb-mode-test "0C0C0C0C0C0C0C0C" "0C0C0C0C0C0C0C0C" "934316AE443CF08B")
(ecb-mode-test "0D0D0D0D0D0D0D0D" "0D0D0D0D0D0D0D0D" "E3F56D7F1130A2B7")
(ecb-mode-test "0E0E0E0E0E0E0E0E" "0E0E0E0E0E0E0E0E" "A2E4705087C6B6B4")
(ecb-mode-test "0F0F0F0F0F0F0F0F" "0F0F0F0F0F0F0F0F" "D5D76E09A447E8C3")
(ecb-mode-test "1010101010101010" "1010101010101010" "DD7515F2BFC17F85")
(ecb-mode-test "1111111111111111" "1111111111111111" "F40379AB9E0EC533")
(ecb-mode-test "1212121212121212" "1212121212121212" "96CD27784D1563E5")
(ecb-mode-test "1313131313131313" "1313131313131313" "2911CF5E94D33FE1")
(ecb-mode-test "1414141414141414" "1414141414141414" "377B7F7CA3E5BBB3")
(ecb-mode-test "1515151515151515" "1515151515151515" "701AA63832905A92")
(ecb-mode-test "1616161616161616" "1616161616161616" "2006E716C4252D6D")
(ecb-mode-test "1717171717171717" "1717171717171717" "452C1197422469F8")
(ecb-mode-test "1818181818181818" "1818181818181818" "C33FD1EB49CB64DA")
(ecb-mode-test "1919191919191919" "1919191919191919" "7572278F364EB50D")
(ecb-mode-test "1A1A1A1A1A1A1A1A" "1A1A1A1A1A1A1A1A" "69E51488403EF4C3")
(ecb-mode-test "1B1B1B1B1B1B1B1B" "1B1B1B1B1B1B1B1B" "FF847E0ADF192825")
(ecb-mode-test "1C1C1C1C1C1C1C1C" "1C1C1C1C1C1C1C1C" "521B7FB3B41BB791")
(ecb-mode-test "1D1D1D1D1D1D1D1D" "1D1D1D1D1D1D1D1D" "26059A6A0F3F6B35")
(ecb-mode-test "1E1E1E1E1E1E1E1E" "1E1E1E1E1E1E1E1E" "F24A8D2231C77538")
(ecb-mode-test "1F1F1F1F1F1F1F1F" "1F1F1F1F1F1F1F1F" "4FD96EC0D3304EF6")
(ecb-mode-test "2020202020202020" "2020202020202020" "18A9D580A900B699")
(ecb-mode-test "2121212121212121" "2121212121212121" "88586E1D755B9B5A")
(ecb-mode-test "2222222222222222" "2222222222222222" "0F8ADFFB11DC2784")
(ecb-mode-test "2323232323232323" "2323232323232323" "2F30446C8312404A")
(ecb-mode-test "2424242424242424" "2424242424242424" "0BA03D9E6C196511")
(ecb-mode-test "2525252525252525" "2525252525252525" "3E55E997611E4B7D")
(ecb-mode-test "2626262626262626" "2626262626262626" "B2522FB5F158F0DF")
(ecb-mode-test "2727272727272727" "2727272727272727" "2109425935406AB8")
(ecb-mode-test "2828282828282828" "2828282828282828" "11A16028F310FF16")
(ecb-mode-test "2929292929292929" "2929292929292929" "73F0C45F379FE67F")
(ecb-mode-test "2A2A2A2A2A2A2A2A" "2A2A2A2A2A2A2A2A" "DCAD4338F7523816")
(ecb-mode-test "2B2B2B2B2B2B2B2B" "2B2B2B2B2B2B2B2B" "B81634C1CEAB298C")
(ecb-mode-test "2C2C2C2C2C2C2C2C" "2C2C2C2C2C2C2C2C" "DD2CCB29B6C4C349")
(ecb-mode-test "2D2D2D2D2D2D2D2D" "2D2D2D2D2D2D2D2D" "7D07A77A2ABD50A7")
(ecb-mode-test "2E2E2E2E2E2E2E2E" "2E2E2E2E2E2E2E2E" "30C1B0C1FD91D371")
(ecb-mode-test "2F2F2F2F2F2F2F2F" "2F2F2F2F2F2F2F2F" "C4427B31AC61973B")
(ecb-mode-test "3030303030303030" "3030303030303030" "F47BB46273B15EB5")
(ecb-mode-test "3131313131313131" "3131313131313131" "655EA628CF62585F")
(ecb-mode-test "3232323232323232" "3232323232323232" "AC978C247863388F")
(ecb-mode-test "3333333333333333" "3333333333333333" "0432ED386F2DE328")
(ecb-mode-test "3434343434343434" "3434343434343434" "D254014CB986B3C2")
(ecb-mode-test "3535353535353535" "3535353535353535" "B256E34BEDB49801")
(ecb-mode-test "3636363636363636" "3636363636363636" "37F8759EB77E7BFC")
(ecb-mode-test "3737373737373737" "3737373737373737" "5013CA4F62C9CEA0")
(ecb-mode-test "3838383838383838" "3838383838383838" "8940F7B3EACA5939")
(ecb-mode-test "3939393939393939" "3939393939393939" "E22B19A55086774B")
(ecb-mode-test "3A3A3A3A3A3A3A3A" "3A3A3A3A3A3A3A3A" "B04A2AAC925ABB0B")
(ecb-mode-test "3B3B3B3B3B3B3B3B" "3B3B3B3B3B3B3B3B" "8D250D58361597FC")
(ecb-mode-test "3C3C3C3C3C3C3C3C" "3C3C3C3C3C3C3C3C" "51F0114FB6A6CD37")
(ecb-mode-test "3D3D3D3D3D3D3D3D" "3D3D3D3D3D3D3D3D" "9D0BB4DB830ECB73")
(ecb-mode-test "3E3E3E3E3E3E3E3E" "3E3E3E3E3E3E3E3E" "E96089D6368F3E1A")
(ecb-mode-test "3F3F3F3F3F3F3F3F" "3F3F3F3F3F3F3F3F" "5C4CA877A4E1E92D")
(ecb-mode-test "4040404040404040" "4040404040404040" "6D55DDBC8DEA95FF")
(ecb-mode-test "4141414141414141" "4141414141414141" "19DF84AC95551003")
(ecb-mode-test "4242424242424242" "4242424242424242" "724E7332696D08A7")
(ecb-mode-test "4343434343434343" "4343434343434343" "B91810B8CDC58FE2")
(ecb-mode-test "4444444444444444" "4444444444444444" "06E23526EDCCD0C4")
(ecb-mode-test "4545454545454545" "4545454545454545" "EF52491D5468D441")
(ecb-mode-test "4646464646464646" "4646464646464646" "48019C59E39B90C5")
(ecb-mode-test "4747474747474747" "4747474747474747" "0544083FB902D8C0")
(ecb-mode-test "4848484848484848" "4848484848484848" "63B15CADA668CE12")
(ecb-mode-test "4949494949494949" "4949494949494949" "EACC0C1264171071")
(ecb-mode-test "4A4A4A4A4A4A4A4A" "4A4A4A4A4A4A4A4A" "9D2B8C0AC605F274")
(ecb-mode-test "4B4B4B4B4B4B4B4B" "4B4B4B4B4B4B4B4B" "C90F2F4C98A8FB2A")
(ecb-mode-test "4C4C4C4C4C4C4C4C" "4C4C4C4C4C4C4C4C" "03481B4828FD1D04")
(ecb-mode-test "4D4D4D4D4D4D4D4D" "4D4D4D4D4D4D4D4D" "C78FC45A1DCEA2E2")
(ecb-mode-test "4E4E4E4E4E4E4E4E" "4E4E4E4E4E4E4E4E" "DB96D88C3460D801")
(ecb-mode-test "4F4F4F4F4F4F4F4F" "4F4F4F4F4F4F4F4F" "6C69E720F5105518")
(ecb-mode-test "5050505050505050" "5050505050505050" "0D262E418BC893F3")
(ecb-mode-test "5151515151515151" "5151515151515151" "6AD84FD7848A0A5C")
(ecb-mode-test "5252525252525252" "5252525252525252" "C365CB35B34B6114")
(ecb-mode-test "5353535353535353" "5353535353535353" "1155392E877F42A9")
(ecb-mode-test "5454545454545454" "5454545454545454" "531BE5F9405DA715")
(ecb-mode-test "5555555555555555" "5555555555555555" "3BCDD41E6165A5E8")
(ecb-mode-test "5656565656565656" "5656565656565656" "2B1FF5610A19270C")
(ecb-mode-test "5757575757575757" "5757575757575757" "D90772CF3F047CFD")
(ecb-mode-test "5858585858585858" "5858585858585858" "1BEA27FFB72457B7")
(ecb-mode-test "5959595959595959" "5959595959595959" "85C3E0C429F34C27")
(ecb-mode-test "5A5A5A5A5A5A5A5A" "5A5A5A5A5A5A5A5A" "F9038021E37C7618")
(ecb-mode-test "5B5B5B5B5B5B5B5B" "5B5B5B5B5B5B5B5B" "35BC6FF838DBA32F")
(ecb-mode-test "5C5C5C5C5C5C5C5C" "5C5C5C5C5C5C5C5C" "4927ACC8CE45ECE7")
(ecb-mode-test "5D5D5D5D5D5D5D5D" "5D5D5D5D5D5D5D5D" "E812EE6E3572985C")
(ecb-mode-test "5E5E5E5E5E5E5E5E" "5E5E5E5E5E5E5E5E" "9BB93A89627BF65F")
(ecb-mode-test "5F5F5F5F5F5F5F5F" "5F5F5F5F5F5F5F5F" "EF12476884CB74CA")
(ecb-mode-test "6060606060606060" "6060606060606060" "1BF17E00C09E7CBF")
(ecb-mode-test "6161616161616161" "6161616161616161" "29932350C098DB5D")
(ecb-mode-test "6262626262626262" "6262626262626262" "B476E6499842AC54")
(ecb-mode-test "6363636363636363" "6363636363636363" "5C662C29C1E96056")
(ecb-mode-test "6464646464646464" "6464646464646464" "3AF1703D76442789")
(ecb-mode-test "6565656565656565" "6565656565656565" "86405D9B425A8C8C")
(ecb-mode-test "6666666666666666" "6666666666666666" "EBBF4810619C2C55")
(ecb-mode-test "6767676767676767" "6767676767676767" "F8D1CD7367B21B5D")
(ecb-mode-test "6868686868686868" "6868686868686868" "9EE703142BF8D7E2")
(ecb-mode-test "6969696969696969" "6969696969696969" "5FDFFFC3AAAB0CB3")
(ecb-mode-test "6A6A6A6A6A6A6A6A" "6A6A6A6A6A6A6A6A" "26C940AB13574231")
(ecb-mode-test "6B6B6B6B6B6B6B6B" "6B6B6B6B6B6B6B6B" "1E2DC77E36A84693")
(ecb-mode-test "6C6C6C6C6C6C6C6C" "6C6C6C6C6C6C6C6C" "0F4FF4D9BC7E2244")
(ecb-mode-test "6D6D6D6D6D6D6D6D" "6D6D6D6D6D6D6D6D" "A4C9A0D04D3280CD")
(ecb-mode-test "6E6E6E6E6E6E6E6E" "6E6E6E6E6E6E6E6E" "9FAF2C96FE84919D")
(ecb-mode-test "6F6F6F6F6F6F6F6F" "6F6F6F6F6F6F6F6F" "115DBC965E6096C8")
(ecb-mode-test "7070707070707070" "7070707070707070" "AF531E9520994017")
(ecb-mode-test "7171717171717171" "7171717171717171" "B971ADE70E5C89EE")
(ecb-mode-test "7272727272727272" "7272727272727272" "415D81C86AF9C376")
(ecb-mode-test "7373737373737373" "7373737373737373" "8DFB864FDB3C6811")
(ecb-mode-test "7474747474747474" "7474747474747474" "10B1C170E3398F91")
(ecb-mode-test "7575757575757575" "7575757575757575" "CFEF7A1C0218DB1E")
(ecb-mode-test "7676767676767676" "7676767676767676" "DBAC30A2A40B1B9C")
(ecb-mode-test "7777777777777777" "7777777777777777" "89D3BF37052162E9")
(ecb-mode-test "7878787878787878" "7878787878787878" "80D9230BDAEB67DC")
(ecb-mode-test "7979797979797979" "7979797979797979" "3440911019AD68D7")
(ecb-mode-test "7A7A7A7A7A7A7A7A" "7A7A7A7A7A7A7A7A" "9626FE57596E199E")
(ecb-mode-test "7B7B7B7B7B7B7B7B" "7B7B7B7B7B7B7B7B" "DEA0B796624BB5BA")
(ecb-mode-test "7C7C7C7C7C7C7C7C" "7C7C7C7C7C7C7C7C" "E9E40542BDDB3E9D")
(ecb-mode-test "7D7D7D7D7D7D7D7D" "7D7D7D7D7D7D7D7D" "8AD99914B354B911")
(ecb-mode-test "7E7E7E7E7E7E7E7E" "7E7E7E7E7E7E7E7E" "6F85B98DD12CB13B")
(ecb-mode-test "7F7F7F7F7F7F7F7F" "7F7F7F7F7F7F7F7F" "10130DA3C3A23924")
(ecb-mode-test "8080808080808080" "8080808080808080" "EFECF25C3C5DC6DB")
(ecb-mode-test "8181818181818181" "8181818181818181" "907A46722ED34EC4")
(ecb-mode-test "8282828282828282" "8282828282828282" "752666EB4CAB46EE")
(ecb-mode-test "8383838383838383" "8383838383838383" "161BFABD4224C162")
(ecb-mode-test "8484848484848484" "8484848484848484" "215F48699DB44A45")
(ecb-mode-test "8585858585858585" "8585858585858585" "69D901A8A691E661")
(ecb-mode-test "8686868686868686" "8686868686868686" "CBBF6EEFE6529728")
(ecb-mode-test "8787878787878787" "8787878787878787" "7F26DCF425149823")
(ecb-mode-test "8888888888888888" "8888888888888888" "762C40C8FADE9D16")
(ecb-mode-test "8989898989898989" "8989898989898989" "2453CF5D5BF4E463")
(ecb-mode-test "8A8A8A8A8A8A8A8A" "8A8A8A8A8A8A8A8A" "301085E3FDE724E1")
(ecb-mode-test "8B8B8B8B8B8B8B8B" "8B8B8B8B8B8B8B8B" "EF4E3E8F1CC6706E")
(ecb-mode-test "8C8C8C8C8C8C8C8C" "8C8C8C8C8C8C8C8C" "720479B024C397EE")
(ecb-mode-test "8D8D8D8D8D8D8D8D" "8D8D8D8D8D8D8D8D" "BEA27E3795063C89")
(ecb-mode-test "8E8E8E8E8E8E8E8E" "8E8E8E8E8E8E8E8E" "468E5218F1A37611")
(ecb-mode-test "8F8F8F8F8F8F8F8F" "8F8F8F8F8F8F8F8F" "50ACE16ADF66BFE8")
(ecb-mode-test "9090909090909090" "9090909090909090" "EEA24369A19F6937")
(ecb-mode-test "9191919191919191" "9191919191919191" "6050D369017B6E62")
(ecb-mode-test "9292929292929292" "9292929292929292" "5B365F2FB2CD7F32")
(ecb-mode-test "9393939393939393" "9393939393939393" "F0B00B264381DDBB")
(ecb-mode-test "9494949494949494" "9494949494949494" "E1D23881C957B96C")
(ecb-mode-test "9595959595959595" "9595959595959595" "D936BF54ECA8BDCE")
(ecb-mode-test "9696969696969696" "9696969696969696" "A020003C5554F34C")
(ecb-mode-test "9797979797979797" "9797979797979797" "6118FCEBD407281D")
(ecb-mode-test "9898989898989898" "9898989898989898" "072E328C984DE4A2")
(ecb-mode-test "9999999999999999" "9999999999999999" "1440B7EF9E63D3AA")
(ecb-mode-test "9A9A9A9A9A9A9A9A" "9A9A9A9A9A9A9A9A" "79BFA264BDA57373")
(ecb-mode-test "9B9B9B9B9B9B9B9B" "9B9B9B9B9B9B9B9B" "C50E8FC289BBD876")
(ecb-mode-test "9C9C9C9C9C9C9C9C" "9C9C9C9C9C9C9C9C" "A399D3D63E169FA9")
(ecb-mode-test "9D9D9D9D9D9D9D9D" "9D9D9D9D9D9D9D9D" "4B8919B667BD53AB")
(ecb-mode-test "9E9E9E9E9E9E9E9E" "9E9E9E9E9E9E9E9E" "D66CDCAF3F6724A2")
(ecb-mode-test "9F9F9F9F9F9F9F9F" "9F9F9F9F9F9F9F9F" "E40E81FF3F618340")
(ecb-mode-test "A0A0A0A0A0A0A0A0" "A0A0A0A0A0A0A0A0" "10EDB8977B348B35")
(ecb-mode-test "A1A1A1A1A1A1A1A1" "A1A1A1A1A1A1A1A1" "6446C5769D8409A0")
(ecb-mode-test "A2A2A2A2A2A2A2A2" "A2A2A2A2A2A2A2A2" "17ED1191CA8D67A3")
(ecb-mode-test "A3A3A3A3A3A3A3A3" "A3A3A3A3A3A3A3A3" "B6D8533731BA1318")
(ecb-mode-test "A4A4A4A4A4A4A4A4" "A4A4A4A4A4A4A4A4" "CA439007C7245CD0")
(ecb-mode-test "A5A5A5A5A5A5A5A5" "A5A5A5A5A5A5A5A5" "06FC7FDE1C8389E7")
(ecb-mode-test "A6A6A6A6A6A6A6A6" "A6A6A6A6A6A6A6A6" "7A3C1F3BD60CB3D8")
(ecb-mode-test "A7A7A7A7A7A7A7A7" "A7A7A7A7A7A7A7A7" "E415D80048DBA848")
(ecb-mode-test "A8A8A8A8A8A8A8A8" "A8A8A8A8A8A8A8A8" "26F88D30C0FB8302")
(ecb-mode-test "A9A9A9A9A9A9A9A9" "A9A9A9A9A9A9A9A9" "D4E00A9EF5E6D8F3")
(ecb-mode-test "AAAAAAAAAAAAAAAA" "AAAAAAAAAAAAAAAA" "C4322BE19E9A5A17")
(ecb-mode-test "ABABABABABABABAB" "ABABABABABABABAB" "ACE41A06BFA258EA")
(ecb-mode-test "ACACACACACACACAC" "ACACACACACACACAC" "EEAAC6D17880BD56")
(ecb-mode-test "ADADADADADADADAD" "ADADADADADADADAD" "3C9A34CA4CB49EEB")
(ecb-mode-test "AEAEAEAEAEAEAEAE" "AEAEAEAEAEAEAEAE" "9527B0287B75F5A3")
(ecb-mode-test "AFAFAFAFAFAFAFAF" "AFAFAFAFAFAFAFAF" "F2D9D1BE74376C0C")
(ecb-mode-test "B0B0B0B0B0B0B0B0" "B0B0B0B0B0B0B0B0" "939618DF0AEFAAE7")
(ecb-mode-test "B1B1B1B1B1B1B1B1" "B1B1B1B1B1B1B1B1" "24692773CB9F27FE")
(ecb-mode-test "B2B2B2B2B2B2B2B2" "B2B2B2B2B2B2B2B2" "38703BA5E2315D1D")
(ecb-mode-test "B3B3B3B3B3B3B3B3" "B3B3B3B3B3B3B3B3" "FCB7E4B7D702E2FB")
(ecb-mode-test "B4B4B4B4B4B4B4B4" "B4B4B4B4B4B4B4B4" "36F0D0B3675704D5")
(ecb-mode-test "B5B5B5B5B5B5B5B5" "B5B5B5B5B5B5B5B5" "62D473F539FA0D8B")
(ecb-mode-test "B6B6B6B6B6B6B6B6" "B6B6B6B6B6B6B6B6" "1533F3ED9BE8EF8E")
(ecb-mode-test "B7B7B7B7B7B7B7B7" "B7B7B7B7B7B7B7B7" "9C4EA352599731ED")
(ecb-mode-test "B8B8B8B8B8B8B8B8" "B8B8B8B8B8B8B8B8" "FABBF7C046FD273F")
(ecb-mode-test "B9B9B9B9B9B9B9B9" "B9B9B9B9B9B9B9B9" "B7FE63A61C646F3A")
(ecb-mode-test "BABABABABABABABA" "BABABABABABABABA" "10ADB6E2AB972BBE")
(ecb-mode-test "BBBBBBBBBBBBBBBB" "BBBBBBBBBBBBBBBB" "F91DCAD912332F3B")
(ecb-mode-test "BCBCBCBCBCBCBCBC" "BCBCBCBCBCBCBCBC" "46E7EF47323A701D")
(ecb-mode-test "BDBDBDBDBDBDBDBD" "BDBDBDBDBDBDBDBD" "8DB18CCD9692F758")
(ecb-mode-test "BEBEBEBEBEBEBEBE" "BEBEBEBEBEBEBEBE" "E6207B536AAAEFFC")
(ecb-mode-test "BFBFBFBFBFBFBFBF" "BFBFBFBFBFBFBFBF" "92AA224372156A00")
(ecb-mode-test "C0C0C0C0C0C0C0C0" "C0C0C0C0C0C0C0C0" "A3B357885B1E16D2")
(ecb-mode-test "C1C1C1C1C1C1C1C1" "C1C1C1C1C1C1C1C1" "169F7629C970C1E5")
(ecb-mode-test "C2C2C2C2C2C2C2C2" "C2C2C2C2C2C2C2C2" "62F44B247CF1348C")
(ecb-mode-test "C3C3C3C3C3C3C3C3" "C3C3C3C3C3C3C3C3" "AE0FEEB0495932C8")
(ecb-mode-test "C4C4C4C4C4C4C4C4" "C4C4C4C4C4C4C4C4" "72DAF2A7C9EA6803")
(ecb-mode-test "C5C5C5C5C5C5C5C5" "C5C5C5C5C5C5C5C5" "4FB5D5536DA544F4")
(ecb-mode-test "C6C6C6C6C6C6C6C6" "C6C6C6C6C6C6C6C6" "1DD4E65AAF7988B4")
(ecb-mode-test "C7C7C7C7C7C7C7C7" "C7C7C7C7C7C7C7C7" "76BF084C1535A6C6")
(ecb-mode-test "C8C8C8C8C8C8C8C8" "C8C8C8C8C8C8C8C8" "AFEC35B09D36315F")
(ecb-mode-test "C9C9C9C9C9C9C9C9" "C9C9C9C9C9C9C9C9" "C8078A6148818403")
(ecb-mode-test "CACACACACACACACA" "CACACACACACACACA" "4DA91CB4124B67FE")
(ecb-mode-test "CBCBCBCBCBCBCBCB" "CBCBCBCBCBCBCBCB" "2DABFEB346794C3D")
(ecb-mode-test "CCCCCCCCCCCCCCCC" "CCCCCCCCCCCCCCCC" "FBCD12C790D21CD7")
(ecb-mode-test "CDCDCDCDCDCDCDCD" "CDCDCDCDCDCDCDCD" "536873DB879CC770")
(ecb-mode-test "CECECECECECECECE" "CECECECECECECECE" "9AA159D7309DA7A0")
(ecb-mode-test "CFCFCFCFCFCFCFCF" "CFCFCFCFCFCFCFCF" "0B844B9D8C4EA14A")
(ecb-mode-test "D0D0D0D0D0D0D0D0" "D0D0D0D0D0D0D0D0" "3BBD84CE539E68C4")
(ecb-mode-test "D1D1D1D1D1D1D1D1" "D1D1D1D1D1D1D1D1" "CF3E4F3E026E2C8E")
(ecb-mode-test "D2D2D2D2D2D2D2D2" "D2D2D2D2D2D2D2D2" "82F85885D542AF58")
(ecb-mode-test "D3D3D3D3D3D3D3D3" "D3D3D3D3D3D3D3D3" "22D334D6493B3CB6")
(ecb-mode-test "D4D4D4D4D4D4D4D4" "D4D4D4D4D4D4D4D4" "47E9CB3E3154D673")
(ecb-mode-test "D5D5D5D5D5D5D5D5" "D5D5D5D5D5D5D5D5" "2352BCC708ADC7E9")
(ecb-mode-test "D6D6D6D6D6D6D6D6" "D6D6D6D6D6D6D6D6" "8C0F3BA0C8601980")
(ecb-mode-test "D7D7D7D7D7D7D7D7" "D7D7D7D7D7D7D7D7" "EE5E9FD70CEF00E9")
(ecb-mode-test "D8D8D8D8D8D8D8D8" "D8D8D8D8D8D8D8D8" "DEF6BDA6CABF9547")
(ecb-mode-test "D9D9D9D9D9D9D9D9" "D9D9D9D9D9D9D9D9" "4DADD04A0EA70F20")
(ecb-mode-test "DADADADADADADADA" "DADADADADADADADA" "C1AA16689EE1B482")
(ecb-mode-test "DBDBDBDBDBDBDBDB" "DBDBDBDBDBDBDBDB" "F45FC26193E69AEE")
(ecb-mode-test "DCDCDCDCDCDCDCDC" "DCDCDCDCDCDCDCDC" "D0CFBB937CEDBFB5")
(ecb-mode-test "DDDDDDDDDDDDDDDD" "DDDDDDDDDDDDDDDD" "F0752004EE23D87B")
(ecb-mode-test "DEDEDEDEDEDEDEDE" "DEDEDEDEDEDEDEDE" "77A791E28AA464A5")
(ecb-mode-test "DFDFDFDFDFDFDFDF" "DFDFDFDFDFDFDFDF" "E7562A7F56FF4966")
(ecb-mode-test "E0E0E0E0E0E0E0E0" "E0E0E0E0E0E0E0E0" "B026913F2CCFB109")
(ecb-mode-test "E1E1E1E1E1E1E1E1" "E1E1E1E1E1E1E1E1" "0DB572DDCE388AC7")
(ecb-mode-test "E2E2E2E2E2E2E2E2" "E2E2E2E2E2E2E2E2" "D9FA6595F0C094CA")
(ecb-mode-test "E3E3E3E3E3E3E3E3" "E3E3E3E3E3E3E3E3" "ADE4804C4BE4486E")
(ecb-mode-test "E4E4E4E4E4E4E4E4" "E4E4E4E4E4E4E4E4" "007B81F520E6D7DA")
(ecb-mode-test "E5E5E5E5E5E5E5E5" "E5E5E5E5E5E5E5E5" "961AEB77BFC10B3C")
(ecb-mode-test "E6E6E6E6E6E6E6E6" "E6E6E6E6E6E6E6E6" "8A8DD870C9B14AF2")
(ecb-mode-test "E7E7E7E7E7E7E7E7" "E7E7E7E7E7E7E7E7" "3CC02E14B6349B25")
(ecb-mode-test "E8E8E8E8E8E8E8E8" "E8E8E8E8E8E8E8E8" "BAD3EE68BDDB9607")
(ecb-mode-test "E9E9E9E9E9E9E9E9" "E9E9E9E9E9E9E9E9" "DFF918E93BDAD292")
(ecb-mode-test "EAEAEAEAEAEAEAEA" "EAEAEAEAEAEAEAEA" "8FE559C7CD6FA56D")
(ecb-mode-test "EBEBEBEBEBEBEBEB" "EBEBEBEBEBEBEBEB" "C88480835C1A444C")
(ecb-mode-test "ECECECECECECECEC" "ECECECECECECECEC" "D6EE30A16B2CC01E")
(ecb-mode-test "EDEDEDEDEDEDEDED" "EDEDEDEDEDEDEDED" "6932D887B2EA9C1A")
(ecb-mode-test "EEEEEEEEEEEEEEEE" "EEEEEEEEEEEEEEEE" "0BFC865461F13ACC")
(ecb-mode-test "EFEFEFEFEFEFEFEF" "EFEFEFEFEFEFEFEF" "228AEA0D403E807A")
(ecb-mode-test "F0F0F0F0F0F0F0F0" "F0F0F0F0F0F0F0F0" "2A2891F65BB8173C")
(ecb-mode-test "F1F1F1F1F1F1F1F1" "F1F1F1F1F1F1F1F1" "5D1B8FAF7839494B")
(ecb-mode-test "F2F2F2F2F2F2F2F2" "F2F2F2F2F2F2F2F2" "1C0A9280EECF5D48")
(ecb-mode-test "F3F3F3F3F3F3F3F3" "F3F3F3F3F3F3F3F3" "6CBCE951BBC30F74")
(ecb-mode-test "F4F4F4F4F4F4F4F4" "F4F4F4F4F4F4F4F4" "9CA66E96BD08BC70")
(ecb-mode-test "F5F5F5F5F5F5F5F5" "F5F5F5F5F5F5F5F5" "F5D779FCFBB28BF3")
(ecb-mode-test "F6F6F6F6F6F6F6F6" "F6F6F6F6F6F6F6F6" "0FEC6BBF9B859184")
(ecb-mode-test "F7F7F7F7F7F7F7F7" "F7F7F7F7F7F7F7F7" "EF88D2BF052DBDA8")
(ecb-mode-test "F8F8F8F8F8F8F8F8" "F8F8F8F8F8F8F8F8" "39ADBDDB7363090D")
(ecb-mode-test "F9F9F9F9F9F9F9F9" "F9F9F9F9F9F9F9F9" "C0AEAF445F7E2A7A")
(ecb-mode-test "FAFAFAFAFAFAFAFA" "FAFAFAFAFAFAFAFA" "C66F54067298D4E9")
(ecb-mode-test "FBFBFBFBFBFBFBFB" "FBFBFBFBFBFBFBFB" "E0BA8F4488AAF97C")
(ecb-mode-test "FCFCFCFCFCFCFCFC" "FCFCFCFCFCFCFCFC" "67B36E2875D9631C")
(ecb-mode-test "FDFDFDFDFDFDFDFD" "FDFDFDFDFDFDFDFD" "1ED83D49E267191D")
(ecb-mode-test "FEFEFEFEFEFEFEFE" "FEFEFEFEFEFEFEFE" "66B2B23EA84693AD")
(ecb-mode-test "FFFFFFFFFFFFFFFF" "FFFFFFFFFFFFFFFF" "7359B2163E4EDC58")
(ecb-mode-test "0001020304050607" "0011223344556677" "3EF0A891CF8ED990")
(ecb-mode-test "2BD6459F82C5B300" "EA024714AD5C4D84" "126EFE8ED312190A")
