/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_lirc.c,v $ -- LIRC input interface
 * $Id: mod_lirc.c,v 1.7 2004/09/22 08:14:26 behrisch Exp $
 *
 * Copyright (C) by Andreas Neuhaus
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "config.h"
#include "irmp3config.h"
#include "irmp3log.h"
#include "irmp3mod.h"
#include "mod_lirc.h"

#include <lirc/lirc_client.h>

/*************************************************************************
 * GLOBALS
 */
fd_set			 mod_lirc_fdset;
struct lirc_config 	*mod_lirc_irconfig;


/*************************************************************************
 * MODULE INFO
 */
mod_t mod_lirc = {
	"mod_lirc",
	mod_lirc_deinit,	// deinit
	mod_lirc_reload,	// reload
	&mod_lirc_fdset,	// watch_fdset
	mod_lirc_poll,		// poll
	NULL,			// update
	NULL,			// message
	NULL,			// SIGCHLD handler
	mod_lirc_init,
	NULL,			// avoid warning
};


/*************************************************************************
 * POLL INPUT DATA
 */
void mod_lirc_poll (int __attribute__((unused)) fd)
{
	char *code, *command;
	int rc;

	if (!lirc_nextcode(&code)) {
		while ((rc = lirc_code2char(mod_lirc_irconfig, code, &command)) == 0 && command) {
			log_printf(LOG_NOISYDEBUG, "mod_lirc_poll(): got command '%s'\n", command);
			mod_sendmsg(MSGTYPE_INPUT, command);
		}
		free(code);
	} else {	// lirc has died
			log_printf(LOG_NORMAL, "mod_lirc_poll(): lirc read returned error .\n");
			FD_ZERO(&mod_lirc_fdset);
	}
}


/*************************************************************************
 * MODULE INIT FUNCTION
 */
char *mod_lirc_init (void)
{
	int mod_lirc_fd=0;

	FD_ZERO(&mod_lirc_fdset);

	// connect to LIRC
	if ((mod_lirc_fd = lirc_init("irmp3", 0)) < 0)
		return "Unable to connect to LIRC";

	log_printf(LOG_DEBUG, "mod_lirc_init(): lirc connection on fd %d\n", mod_lirc_fd);

	// read LIRC config
	if (lirc_readconfig(config_getstr("lirc_config", NULL), &mod_lirc_irconfig, NULL)) {
		lirc_deinit();
		return "Unable to read LIRC config";
	}

	// register our module
	FD_SET(mod_lirc_fd,&mod_lirc_fdset);

	return NULL;
}


/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_lirc_deinit (void)
{
	// free LIRC config
	lirc_freeconfig(mod_lirc_irconfig);

	// disconnect from LIRC
	lirc_deinit();

	log_printf(LOG_DEBUG, "mod_lirc_deinit(): closed lirc connection\n");
	FD_ZERO(&mod_lirc_fdset);
}


/*************************************************************************
 * MODULE RELOAD FUNCTION
 */
char *mod_lirc_reload (void)
{
	log_printf(LOG_DEBUG, "mod_lirc_reload(): reloading lirc config\n");

	// free LIRC config
	lirc_freeconfig(mod_lirc_irconfig);

	// read LIRC config
	lirc_readconfig(config_getstr("lirc_config", NULL), &mod_lirc_irconfig, NULL);

	return NULL;
}


/*************************************************************************
 * EOF
 */
