#
# AC_ARG_ENABLE_MOD(name)
#
AC_DEFUN([AC_ARG_ENABLE_MOD], 
[
  AC_ARG_ENABLE(mod_[$1], [  --disable-mod-$1
                          Do not include mod_$1.])
])

#
# AC_DEFINE_MOD(name, symbol)
#
AC_DEFUN([AC_DEFINE_MOD], 
[
  AC_MSG_CHECKING(mod_[$1] is)
  result=`eval echo $enable_mod_[$1]`
  if test "x$result" != "xno"; then
    AC_MSG_RESULT(enabled)
    AC_DEFINE($2, 1, Include mod_$1.)
    AC_SUBST([$2]_SRC, mod_$1.c)
    AC_SUBST([$2]_OBJ, mod_$1.o)
    AC_SUBST([$2]_DEPS, mod_$1.h)
  else
    AC_MSG_RESULT(disabled)
  fi
])

#
# AC_MOD_DEP_ERROR(mod1, mod2, [message])
#
# Checks whether mod2 is enabled if mod1 is enabled (useful if mod1 depends on mod2).
# Raises an error message with [message] or a standard text.
#
AC_DEFUN([AC_MOD_DEP_ERROR], 
[
  mod1=`eval echo $enable_[$1]`;
  mod2=`eval echo $enable_[$2]`;
  if test "x$mod1" != "xno"; then
    if test "x$mod2" == "xno"; then
      message=`eval echo ifelse($3, , [$1 requires $2. Either enable $2 or disable $1.], $3)`
      AC_MSG_ERROR($message)
    fi
  fi
])

#
# AC_MOD_DEP_WARN(mod1, mod2, [message])
#
# Checks whether mod2 is enabled if mod1 is enabled (useful if mod1 depends on mod2).
# Raises a warning message with [message] or a standard text.
#
AC_DEFUN([AC_MOD_DEP_WARN], 
[
  mod1=`eval echo $enable_[$1]`;
  mod2=`eval echo $enable_[$2]`;
  if test "x$mod1" != "xno"; then
    if test "x$mod2" == "xno"; then
      message=`eval echo ifelse($3, , [$1 requires $2. Either enable $2 or disable $1.], $3)`
      AC_MSG_WARN($message)
    fi
  fi
])


#
# AC_PROG_LIRC(version_required, version_recommended)
#
AC_DEFUN([AC_PROG_LIRC],
[
 if test "x$enable_mod_lirc" != "xno" ; then
  AC_ARG_WITH(lirc, [Specify path to lircd.], lircpath=$withval)
  if test "x$lircpath" == "x"; then
    AC_PATH_PROG(lircpath, lircd, [], [$PATH:/usr/sbin:/usr/local/sbin])
  fi
  if test "x$lircpath" == "x"; then
    enable_mod_lirc=no
  else
  	AC_MSG_CHECKING(lirc version)

	changequote(<, >)
	lircversion=`$lircpath --version | sed 's/^lircd[^0-9]*\([^ ]*\)/\1/'`
	lircversion_int=`eval echo $lircversion | sed 's/\.//g'`
	changequote([, ])
	AC_MSG_RESULT($lircversion)
	if test "[$lircversion]" \< "[$1]"; then
	  AC_MSG_WARN([Sorry, you need at least lirc version $1.])
    	  enable_mod_lirc=no
	fi
	if test "[$lircversion]" \< "[$2]"; then
	  AC_MSG_WARN([lirc version $2 is recommended - use at your own risk.])
	fi
	if test ! -S /dev/lircd; then
	  AC_MSG_WARN([/dev/lircd is not present or is not a socket!])
	fi
	AC_DEFINE_UNQUOTED(LIRCD, "/dev/lircd", [Path to lirc socket])
	AC_DEFINE_UNQUOTED(LIRC_VERSION, "${lircversion}", [lirc version detected])
	AC_DEFINE_UNQUOTED(LIRC_VERSION_INT, ${lircversion_int}, [lirc version expressed as an integer])
	AC_CHECK_LIB(lirc_client, lirc_init)
  fi
 fi
])

#
# AC_PROG_MPG123(version_required, version_recommended)
#
AC_DEFUN([AC_PROG_MPG123],
[
 if test "x$enable_mod_mpg123" != "xno" ; then
  AC_ARG_WITH(mpg123, [Specify path to mpg123.], mpg123path=$withval)
  if test "x$mpg123path" == "x"; then
    AC_PATH_PROG(mpg123path, mpg123)
  fi
  if test "x$mpg123path" == "x"; then
    enable_mod_mpg123=no
  else
  	AC_MSG_CHECKING(mpg123 version)

	changequote({, })
	mpg123version=`$mpg123path --help 2>&1|grep  Version |  sed 's/Version \([0-9\.a-zA-Z]*\).*/\1/g'`
	changequote([, ])
	AC_MSG_RESULT($mpg123version)
	if test "[$mpg123version]" \< "[$1]"; then
	  AC_MSG_WARN([Sorry, you need at least mpg123 version $1.])
    	  enable_mod_mpg123=no
	fi
	if test "[$mpg123version]" \< "[$2]"; then
	  AC_MSG_WARN([mpg123 version $2 is recommended - use at your own risk.])
	fi
	AC_DEFINE_UNQUOTED(MPG123_PATH,    "$mpg123path",    [Path to mpg123 executable])
	AC_DEFINE_UNQUOTED(MPG123_VERSION, "$mpg123version", [mpg123 version detected])
  fi
 fi
])

#
# AC_PROG_FLAC123(version_required, version_recommended)
#
AC_DEFUN([AC_PROG_FLAC123],
[
 if test "x$enable_mod_flac123" != "xno" ; then
  AC_ARG_WITH(flac123, [Specify path to flac123.], flac123path=$withval)
  if test "x$flac123path" == "x"; then
    AC_PATH_PROG(flac123path, flac123)
  fi
  if test "x$flac123path" == "x"; then
    enable_mod_flac123=no
  else
  	AC_MSG_CHECKING(flac123 version)

	changequote({, })
	flac123version=`$flac123path 2>&1|grep  version |  sed 's/version \([0-9\.a-zA-Z]*\).*/\1/g'`
	changequote([, ])
	AC_MSG_RESULT($flac123version)
	if test "[$flac123version]" \< "[$1]"; then
	  AC_MSG_WARN([Sorry, you need at least flac123 version $1.])
    	  enable_mod_flac123=no
	fi
	if test "[$flac123version]" \< "[$2]"; then
	  AC_MSG_WARN([flac123 version $2 is recommended - use at your own risk.])
	fi
	AC_DEFINE_UNQUOTED(FLAC123_PATH,    "$flac123path",    [Path to flac123 executable])
	AC_DEFINE_UNQUOTED(FLAC123_VERSION, "$flac123version", [flac123 version detected])
  fi
 fi
])

#
# AC_PROG_TIMIDITY()
#
AC_DEFUN([AC_PROG_TIMIDITY],
[
 if test "x$enable_mod_timidity" != "xno" ; then
  AC_ARG_WITH(timidity, [Specify path to timidity.], timiditypath=$withval)
  if test "x$timiditypath" == "x"; then
  AC_PATH_PROG(timiditypath, timidity)
  fi
  if test "x$timiditypath" == "x"; then
  enable_mod_timidity=no
  fi
  AC_DEFINE_UNQUOTED(TIMIDITY_PATH,    "$timiditypath",    [Path to timidity executable])
 fi
])
#
# AC_PROG_MPLAYER(version_required, version_recommended)
#
AC_DEFUN([AC_PROG_MPLAYER],
[
 if test "x$enable_mod_mplayer" != "xno" ; then
  AC_ARG_WITH(mplayer, [Specify path to mplayer.], mplayerpath=$withval)
  if test "x$mplayerpath" == "x"; then
    AC_PATH_PROG(mplayerpath, mplayer)
  fi
  if test "x$mplayerpath" == "x"; then
    enable_mod_mplayer=no
  else
  	AC_MSG_CHECKING(mplayer version)

	changequote({, })
	mplayerversion=`$mplayerpath --help 2>&1|grep  MPlayer | head -1 | sed 's/MPlayer \([^ ]*\).*/\1/g'`
	changequote([, ])
	AC_MSG_RESULT($mplayerversion)
	if test "[$mplayerversion]" \< "[$1]"; then
	  AC_MSG_WARN([Sorry, you need at least mplayer version $1.])
    	  enable_mod_mplayer=no
	fi
	if test "[$mplayerversion]" \< "[$2]"; then
	  AC_MSG_WARN([mplayer version $2 is recommended - use at your own risk.])
	fi
	AC_DEFINE_UNQUOTED(MPLAYER_PATH,    "$mplayerpath",    [Path to mplayer executable])
	AC_DEFINE_UNQUOTED(MPLAYER_VERSION, "$mplayerversion", [mplayer version detected])
  fi
 fi
])
#
# AC_PROG_RADIO(version_required, version_recommended)
#
AC_DEFUN([AC_PROG_RADIO],
[
 if test "x$enable_mod_radio" != "xno" ; then
  AC_ARG_WITH(radio, [Specify path to fm, the radio changing program.], radiopath=$withval)
  if test "x$radiopath" == "x"; then
    AC_PATH_PROG(radiopath, fm)
  fi
  if test "x$radiopath" == "x"; then
    enable_mod_radio=no
  else
  	AC_MSG_CHECKING(fmtools version)

	changequote({, })
	radioversion=`$radiopath -h 2>&1|grep  version |  sed 's/fm version \([^ ]*\).*/\1/g'`
	changequote([, ])
	AC_MSG_RESULT($radioversion)
	if test "[$radioversion]" \< "[$1]"; then
	  AC_MSG_WARN([Sorry, you need at least fmtools version $1.])
    	  enable_mod_radio=no
	fi
	if test "[$radioversion]" \< "[$2]"; then
	  AC_MSG_WARN([fmtools version $2 is recommended - use at your own risk.])
	fi
	AC_DEFINE_UNQUOTED(RADIO_PATH,    "$radiopath",    [Path to fm executable])
	AC_DEFINE_UNQUOTED(RADIO_VERSION, "$radioversion", [fmtools version detected])
  fi
 fi
])
