#!/usr/bin/python

"""
Module "whois" for Inguma based in the Scapy's implementation
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""
import os
import sys
import time
import socket

from lib.libexploit import CIngumaModule

name = "whois"
brief_description = "Query whois database"
type = "discover"

class CWhois(CIngumaModule):
    target = ""
    port = 0
    waitTime = 0
    timeout = 1
    exploitType = 1
    services = {}
    results = {}
    dict = None
    ret = False

    def help(self):
        print "target = <target host or network>"

    def run(self, theServer="whois.internic.net"):
        if self.timeout < 5:
            self.timeout = 5

        socket.setdefaulttimeout(self.timeout)
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.connect((theServer, 43))
        s.send(self.target + "\n")

        self.data = ""

        while 1:
            line = s.recv(4096)
            
            if not line:
                break
            else:
                pos = line.lower().find("whois server: ")
                if pos > -1:
                    server = line[pos:]
                    server = server[14:server.find("\n")]

                    print "Redirected to server %s ..." % server
                    print 

                    return self.run(theServer=server)

                self.data += line + "\n"

        s.close()

        return True

    def printSummary(self):
        print "Whois database information"
        print "--------------------------"
        print
        print self.data

