/* You may find the license in the LICENSE file */

function TrayHandler() {
	if (!('trayITrayService' in Ci)) {
		this.available = false;
		return;
	}
	this._trayService = Serv('@tn123.ath.cx/trayservice;1', 'trayITrayService');
	this.available = !!this._trayService;
	window.addEventListener(
		'TrayDblClick',
		function(event) {
			if (event.button == 0) {
				TrayHandler.restore();
			}
		},
		true
	);
	window.addEventListener(
		'TrayClick',
		function(event) {
			if (event.button == 2) {
				TrayHandler.showMenu(event.screenX, event.screenY);
			}
		},
		true
	);
}

TrayHandler.prototype = {
	watch: function tray_watch() {
		if (this.available) {
			this._trayService.watchMinimize(window);
		}
	},
	unwatch: function tray_unwatch() {
		if (this.available) {
			this._trayService.unwatchMinimize(window);
		}
	},
	restore: function tray_restore() {
		if (this.available) {
			this._trayService.restore(window);
		}
	},
	showMenu: function(x, y) {
		$('traymenu').showPopup(
			document.documentElement,
			x,
			y,
			"context",
			"",
			"bottomleft"
		);		
	}
};
TrayHandler = new TrayHandler();