/* engine.c generated by valac 0.14.0, the Vala compiler
 * generated from engine.vala, do not modify */

/* 
 * Copyright (C) 2011-2012 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011-2012 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <libskk/libskk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libutil.h>
#include <config.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>


#define TYPE_SKK_ENGINE (skk_engine_get_type ())
#define SKK_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SKK_ENGINE, SkkEngine))
#define SKK_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SKK_ENGINE, SkkEngineClass))
#define IS_SKK_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SKK_ENGINE))
#define IS_SKK_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SKK_ENGINE))
#define SKK_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SKK_ENGINE, SkkEngineClass))

typedef struct _SkkEngine SkkEngine;
typedef struct _SkkEngineClass SkkEngineClass;
typedef struct _SkkEnginePrivate SkkEnginePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SKK_ENGINE_TYPE_ENTRY (skk_engine_entry_get_type ())
typedef struct _SkkEngineEntry SkkEngineEntry;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _SkkEngine {
	IBusEngine parent_instance;
	SkkEnginePrivate * priv;
};

struct _SkkEngineClass {
	IBusEngineClass parent_class;
};

struct _SkkEnginePrivate {
	SkkContext* context;
	IBusLookupTable* lookup_table;
	guint page_start;
	gboolean lookup_table_visible;
	gboolean show_annotation;
	IBusProperty* input_mode_prop;
	IBusPropList* prop_list;
	GeeMap* input_mode_props;
	GeeMap* input_mode_symbols;
	GeeMap* name_input_modes;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
};

struct _SkkEngineEntry {
	gpointer key;
	gpointer value;
};


static gpointer skk_engine_parent_class = NULL;
static Preferences* skk_engine_preferences;
static Preferences* skk_engine_preferences = NULL;
static GeeArrayList* skk_engine_dictionaries;
static GeeArrayList* skk_engine_dictionaries = NULL;
static gboolean skk_engine_ibus;
static gboolean skk_engine_ibus = FALSE;

GType skk_engine_get_type (void) G_GNUC_CONST;
#define SKK_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SKK_ENGINE, SkkEnginePrivate))
enum  {
	SKK_ENGINE_DUMMY_PROPERTY
};
static GType skk_engine_entry_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SkkEngineEntry* skk_engine_entry_dup (const SkkEngineEntry* self);
static void skk_engine_entry_free (SkkEngineEntry* self);
static void skk_engine_entry_copy (const SkkEngineEntry* self, SkkEngineEntry* dest);
static void skk_engine_entry_destroy (SkkEngineEntry* self);
static gboolean _skk_engine_retrieve_surrounding_text (SkkEngine* self, gchar** text, guint* cursor_pos);
static gboolean _skk_engine_delete_surrounding_text (SkkEngine* self, gint offset, guint nchars);
static void skk_engine_populate_lookup_table (SkkEngine* self);
static void skk_engine_set_lookup_table_cursor_pos (SkkEngine* self);
static void skk_engine_update_preedit (SkkEngine* self);
static void skk_engine_update_candidates (SkkEngine* self);
static void skk_engine_update_input_mode (SkkEngine* self);
static SkkDict* skk_engine_parse_dict_from_plist (PList* plist, GError** error);
static void skk_engine_reload_dictionaries (void);
static void skk_engine_apply_preferences (SkkEngine* self);
static IBusProperty* skk_engine_register_input_mode_property (SkkEngine* self, SkkInputMode mode, const gchar* name, const gchar* label, const gchar* symbol);
static gboolean skk_engine_process_lookup_table_key_event (SkkEngine* self, guint keyval, guint keycode, guint state);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static gboolean skk_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state);
static void skk_engine_real_enable (IBusEngine* base);
static void skk_engine_real_disable (IBusEngine* base);
static void skk_engine_real_reset (IBusEngine* base);
static void skk_engine_real_focus_in (IBusEngine* base);
static void skk_engine_real_focus_out (IBusEngine* base);
static void skk_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state);
gint skk_engine_main (gchar** args, int args_length1);
static void __lambda0_ (void);
static void ___lambda0__ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static void __lambda1_ (const gchar* name, GVariant* value);
static void ___lambda1__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
SkkEngine* skk_engine_new (void);
SkkEngine* skk_engine_construct (GType object_type);
static GObject * skk_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _skk_engine___lambda2_ (SkkEngine* self, const gchar* name, GVariant* value);
static void __skk_engine___lambda2__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self);
static void _skk_engine___lambda3_ (SkkEngine* self);
static void __skk_engine___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _skk_engine___lambda4_ (SkkEngine* self, GObject* s, GParamSpec* p);
static void __skk_engine___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _skk_engine___lambda5_ (SkkEngine* self);
static void __skk_engine___lambda5__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self);
static void _skk_engine___lambda6_ (SkkEngine* self);
static void __skk_engine___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _skk_engine___lambda7_ (SkkEngine* self);
static void __skk_engine___lambda7__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self);
static gboolean __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text (SkkContext* _sender, gchar** text, guint* cursor_pos, gpointer self);
static gboolean __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text (SkkContext* _sender, gint offset, guint nchars, gpointer self);
static void skk_engine_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const SkkEngineEntry SKK_ENGINE_CODE_KEYVALS[3] = {{IBUS_Tab, '\t'}, {IBUS_Return, '\n'}, {IBUS_BackSpace, '\b'}};
static const SkkEngineEntry SKK_ENGINE_NAME_KEYVALS[10] = {{IBUS_Up, "Up"}, {IBUS_Down, "Down"}, {IBUS_Left, "Left"}, {IBUS_Right, "Right"}, {IBUS_Page_Up, "Page_Up"}, {IBUS_KP_Page_Up, "Page_Up"}, {IBUS_Page_Down, "Page_Down"}, {IBUS_KP_Page_Down, "Page_Down"}, {IBUS_Muhenkan, "lshift"}, {IBUS_Henkan, "rshift"}};
static const SkkEngineEntry SKK_ENGINE_IGNORE_KEYVALS[1] = {{IBUS_j, IBUS_CONTROL_MASK}};
static const GOptionEntry SKK_ENGINE_options[2] = {{"ibus", 'i', 0, G_OPTION_ARG_NONE, &skk_engine_ibus, "Component is executed by IBus", NULL}, {NULL}};

static gboolean _skk_engine_retrieve_surrounding_text (SkkEngine* self, gchar** text, guint* cursor_pos) {
	gchar* _vala_text = NULL;
	guint _vala_cursor_pos = 0U;
	gboolean result = FALSE;
	IBusText* _text = NULL;
	guint _cursor_pos = 0U;
	guint anchor_pos = 0U;
	IBusText* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	ibus_engine_get_surrounding_text ((IBusEngine*) self, &_tmp0_, &_tmp1_, &_tmp2_);
	_text = _tmp0_;
	_cursor_pos = _tmp1_;
	anchor_pos = _tmp2_;
	_tmp3_ = _text->text;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_text);
	_vala_text = _tmp4_;
	_vala_cursor_pos = _cursor_pos;
	result = TRUE;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	if (cursor_pos) {
		*cursor_pos = _vala_cursor_pos;
	}
	return result;
}


static gboolean _skk_engine_delete_surrounding_text (SkkEngine* self, gint offset, guint nchars) {
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = offset;
	_tmp1_ = nchars;
	ibus_engine_delete_surrounding_text ((IBusEngine*) self, _tmp0_, _tmp1_);
	result = TRUE;
	return result;
}


static void skk_engine_populate_lookup_table (SkkEngine* self) {
	IBusLookupTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lookup_table;
	ibus_lookup_table_clear (_tmp0_);
	{
		guint _tmp1_;
		gint i;
		_tmp1_ = self->priv->page_start;
		i = (gint) _tmp1_;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				SkkContext* _tmp6_;
				SkkCandidateList* _tmp7_;
				SkkCandidateList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				SkkContext* _tmp11_;
				SkkCandidateList* _tmp12_;
				SkkCandidateList* _tmp13_;
				gint _tmp14_;
				SkkCandidate* _tmp15_ = NULL;
				SkkCandidate* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				IBusText* _tmp19_;
				IBusText* _tmp20_;
				IBusText* _tmp21_;
				IBusText* text;
				IBusLookupTable* _tmp22_;
				IBusText* _tmp23_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->context;
				_tmp7_ = skk_context_get_candidates (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = skk_candidate_list_get_size (_tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp5_ < _tmp10_)) {
					break;
				}
				_tmp11_ = self->priv->context;
				_tmp12_ = skk_context_get_candidates (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = i;
				_tmp15_ = skk_candidate_list_get (_tmp13_, _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = skk_candidate_get_output (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = ibus_text_new_from_string (_tmp18_);
				_tmp20_ = g_object_ref_sink (_tmp19_);
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp16_);
				text = _tmp21_;
				_tmp22_ = self->priv->lookup_table;
				_tmp23_ = text;
				ibus_lookup_table_append_candidate (_tmp22_, _tmp23_);
				_g_object_unref0 (text);
			}
		}
	}
}


static void skk_engine_set_lookup_table_cursor_pos (SkkEngine* self) {
	IBusText* _tmp0_;
	IBusText* _tmp1_;
	IBusText* empty_text;
	SkkContext* _tmp2_;
	SkkCandidateList* _tmp3_;
	SkkCandidateList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint cursor_pos;
	SkkContext* _tmp7_;
	SkkCandidateList* _tmp8_;
	SkkCandidateList* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ibus_text_new_from_static_string ("");
	_tmp1_ = g_object_ref_sink (_tmp0_);
	empty_text = _tmp1_;
	_tmp2_ = self->priv->context;
	_tmp3_ = skk_context_get_candidates (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = skk_candidate_list_get_cursor_pos (_tmp4_);
	_tmp6_ = _tmp5_;
	cursor_pos = _tmp6_;
	_tmp7_ = self->priv->context;
	_tmp8_ = skk_context_get_candidates (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = skk_candidate_list_get_page_visible (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		IBusLookupTable* _tmp12_;
		gint _tmp13_;
		SkkContext* _tmp14_;
		SkkCandidateList* _tmp15_;
		SkkCandidateList* _tmp16_;
		guint _tmp17_;
		guint _tmp18_;
		IBusLookupTable* _tmp19_;
		SkkContext* _tmp20_;
		SkkCandidateList* _tmp21_;
		SkkCandidateList* _tmp22_;
		SkkCandidate* _tmp23_ = NULL;
		SkkCandidate* candidate;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_;
		gboolean _tmp29_;
		_tmp12_ = self->priv->lookup_table;
		_tmp13_ = cursor_pos;
		_tmp14_ = self->priv->context;
		_tmp15_ = skk_context_get_candidates (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = skk_candidate_list_get_page_start (_tmp16_);
		_tmp18_ = _tmp17_;
		ibus_lookup_table_set_cursor_pos (_tmp12_, _tmp13_ - _tmp18_);
		_tmp19_ = self->priv->lookup_table;
		ibus_engine_update_lookup_table_fast ((IBusEngine*) self, _tmp19_, TRUE);
		_tmp20_ = self->priv->context;
		_tmp21_ = skk_context_get_candidates (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = skk_candidate_list_get (_tmp22_, -1);
		candidate = _tmp23_;
		_tmp25_ = self->priv->show_annotation;
		if (_tmp25_) {
			SkkCandidate* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			_tmp26_ = candidate;
			_tmp27_ = skk_candidate_get_annotation (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp24_ = _tmp28_ != NULL;
		} else {
			_tmp24_ = FALSE;
		}
		_tmp29_ = _tmp24_;
		if (_tmp29_) {
			SkkCandidate* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			IBusText* _tmp33_;
			IBusText* _tmp34_;
			IBusText* text;
			IBusText* _tmp35_;
			_tmp30_ = candidate;
			_tmp31_ = skk_candidate_get_annotation (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = ibus_text_new_from_string (_tmp32_);
			_tmp34_ = g_object_ref_sink (_tmp33_);
			text = _tmp34_;
			_tmp35_ = text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp35_, TRUE);
			_g_object_unref0 (text);
		} else {
			IBusText* _tmp36_;
			_tmp36_ = empty_text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp36_, FALSE);
		}
		self->priv->lookup_table_visible = TRUE;
		_g_object_unref0 (candidate);
	} else {
		gboolean _tmp37_;
		_tmp37_ = self->priv->lookup_table_visible;
		if (_tmp37_) {
			ibus_engine_hide_lookup_table ((IBusEngine*) self);
			ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
			self->priv->lookup_table_visible = FALSE;
		}
	}
	_g_object_unref0 (empty_text);
}


static void skk_engine_update_preedit (SkkEngine* self) {
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	IBusText* _tmp3_;
	IBusText* _tmp4_;
	IBusText* text;
	guint underline_offset = 0U;
	guint underline_nchars = 0U;
	SkkContext* _tmp5_;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_;
	IBusText* _tmp13_;
	IBusText* _tmp14_;
	guint _tmp15_ = 0U;
	IBusText* _tmp16_;
	guint _tmp17_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ibus_text_new_from_string (_tmp2_);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	text = _tmp4_;
	_tmp5_ = self->priv->context;
	skk_context_get_preedit_underline (_tmp5_, &_tmp6_, &_tmp7_);
	underline_offset = _tmp6_;
	underline_nchars = _tmp7_;
	_tmp8_ = underline_nchars;
	if (((guint) 0) < _tmp8_) {
		IBusText* _tmp9_;
		guint _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		_tmp9_ = text;
		_tmp10_ = underline_offset;
		_tmp11_ = underline_offset;
		_tmp12_ = underline_nchars;
		ibus_text_append_attribute (_tmp9_, (guint) IBUS_ATTR_TYPE_UNDERLINE, (guint) IBUS_ATTR_UNDERLINE_SINGLE, (guint) ((gint) _tmp10_), (gint) (_tmp11_ + _tmp12_));
	}
	_tmp13_ = text;
	_tmp14_ = text;
	_tmp15_ = ibus_text_get_length (_tmp14_);
	_tmp16_ = text;
	_tmp17_ = ibus_text_get_length (_tmp16_);
	ibus_engine_update_preedit_text ((IBusEngine*) self, _tmp13_, _tmp15_, _tmp17_ > ((guint) 0));
	_g_object_unref0 (text);
}


static void skk_engine_update_candidates (SkkEngine* self) {
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	guint _tmp3_;
	SkkContext* _tmp4_;
	SkkCandidateList* _tmp5_;
	SkkCandidateList* _tmp6_;
	IBusLookupTable* _tmp7_;
	guint _tmp8_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->page_start;
	skk_candidate_list_set_page_start (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->context;
	_tmp5_ = skk_context_get_candidates (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->lookup_table;
	_tmp8_ = ibus_lookup_table_get_page_size (_tmp7_);
	skk_candidate_list_set_page_size (_tmp6_, _tmp8_);
	skk_engine_populate_lookup_table (self);
	skk_engine_set_lookup_table_cursor_pos (self);
}


static void skk_engine_update_input_mode (SkkEngine* self) {
	GeeMap* _tmp0_;
	SkkContext* _tmp1_;
	SkkInputMode _tmp2_;
	SkkInputMode _tmp3_;
	gpointer _tmp4_ = NULL;
	IBusProperty* _prop;
	GeeMap* _tmp5_;
	SkkContext* _tmp6_;
	SkkInputMode _tmp7_;
	SkkInputMode _tmp8_;
	gpointer _tmp9_ = NULL;
	gchar* _tmp10_;
	IBusText* _tmp11_;
	IBusText* _tmp12_;
	IBusText* _tmp13_;
	IBusText* symbol;
	IBusProperty* _tmp14_;
	IBusProperty* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_mode_props;
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_get_input_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_map_get (_tmp0_, GINT_TO_POINTER (_tmp3_));
	_prop = (IBusProperty*) _tmp4_;
	ibus_property_set_state (_prop, PROP_STATE_CHECKED);
	ibus_engine_update_property ((IBusEngine*) self, _prop);
	_tmp5_ = self->priv->input_mode_symbols;
	_tmp6_ = self->priv->context;
	_tmp7_ = skk_context_get_input_mode (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_map_get (_tmp5_, GINT_TO_POINTER (_tmp8_));
	_tmp10_ = (gchar*) _tmp9_;
	_tmp11_ = ibus_text_new_from_string (_tmp10_);
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp10_);
	symbol = _tmp13_;
	_tmp14_ = self->priv->input_mode_prop;
	ibus_property_set_label (_tmp14_, symbol);
	_tmp15_ = self->priv->input_mode_prop;
	ibus_engine_update_property ((IBusEngine*) self, _tmp15_);
	_g_object_unref0 (symbol);
	_g_object_unref0 (_prop);
}


static SkkDict* skk_engine_parse_dict_from_plist (PList* plist, GError** error) {
	SkkDict* result = NULL;
	PList* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* encoding;
	PList* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* type;
	const gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (plist != NULL, NULL);
	_tmp0_ = plist;
	_tmp1_ = plist_get (_tmp0_, "encoding");
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("EUC-JP");
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	}
	_tmp5_ = _tmp2_;
	_tmp6_ = g_strdup (_tmp5_);
	encoding = _tmp6_;
	_tmp7_ = plist;
	_tmp8_ = plist_get (_tmp7_, "type");
	type = _tmp8_;
	_tmp9_ = type;
	if (g_strcmp0 (_tmp9_, "file") == 0) {
		PList* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* file;
		const gchar* _tmp12_;
		PList* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* mode;
		const gchar* _tmp20_;
		_tmp10_ = plist;
		_tmp11_ = plist_get (_tmp10_, "file");
		file = _tmp11_;
		_tmp12_ = file;
		if (_tmp12_ == NULL) {
			result = NULL;
			_g_free0 (file);
			_g_free0 (type);
			_g_free0 (encoding);
			_g_free0 (_tmp2_);
			return result;
		}
		_tmp13_ = plist;
		_tmp14_ = plist_get (_tmp13_, "mode");
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		if (_tmp16_ == NULL) {
			gchar* _tmp17_;
			_tmp17_ = g_strdup ("readonly");
			_g_free0 (_tmp15_);
			_tmp15_ = _tmp17_;
		}
		_tmp18_ = _tmp15_;
		_tmp19_ = g_strdup (_tmp18_);
		mode = _tmp19_;
		_tmp20_ = mode;
		if (g_strcmp0 (_tmp20_, "readonly") == 0) {
			const gchar* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp21_ = file;
			_tmp22_ = g_str_has_suffix (_tmp21_, ".cdb");
			if (_tmp22_) {
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				SkkCdbDict* _tmp25_;
				SkkCdbDict* _tmp26_;
				_tmp23_ = file;
				_tmp24_ = encoding;
				_tmp25_ = skk_cdb_dict_new (_tmp23_, _tmp24_, &_inner_error_);
				_tmp26_ = _tmp25_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (mode);
					_g_free0 (_tmp15_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp2_);
					return NULL;
				}
				result = (SkkDict*) _tmp26_;
				_g_free0 (mode);
				_g_free0 (_tmp15_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp2_);
				return result;
			} else {
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				SkkFileDict* _tmp29_;
				SkkFileDict* _tmp30_;
				_tmp27_ = file;
				_tmp28_ = encoding;
				_tmp29_ = skk_file_dict_new (_tmp27_, _tmp28_, &_inner_error_);
				_tmp30_ = _tmp29_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (mode);
					_g_free0 (_tmp15_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp2_);
					return NULL;
				}
				result = (SkkDict*) _tmp30_;
				_g_free0 (mode);
				_g_free0 (_tmp15_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp2_);
				return result;
			}
		} else {
			const gchar* _tmp31_;
			_tmp31_ = mode;
			if (g_strcmp0 (_tmp31_, "readwrite") == 0) {
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				SkkUserDict* _tmp34_;
				SkkUserDict* _tmp35_;
				_tmp32_ = file;
				_tmp33_ = encoding;
				_tmp34_ = skk_user_dict_new (_tmp32_, _tmp33_, &_inner_error_);
				_tmp35_ = _tmp34_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (mode);
					_g_free0 (_tmp15_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp2_);
					return NULL;
				}
				result = (SkkDict*) _tmp35_;
				_g_free0 (mode);
				_g_free0 (_tmp15_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp2_);
				return result;
			}
		}
		_g_free0 (mode);
		_g_free0 (_tmp15_);
		_g_free0 (file);
	} else {
		const gchar* _tmp36_;
		_tmp36_ = type;
		if (g_strcmp0 (_tmp36_, "server") == 0) {
			PList* _tmp37_;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* host;
			PList* _tmp44_;
			gchar* _tmp45_ = NULL;
			gchar* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* port;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gint _tmp53_ = 0;
			const gchar* _tmp54_;
			SkkSkkServ* _tmp55_;
			SkkSkkServ* _tmp56_;
			_tmp37_ = plist;
			_tmp38_ = plist_get (_tmp37_, "host");
			_tmp39_ = _tmp38_;
			_tmp40_ = _tmp39_;
			if (_tmp40_ == NULL) {
				gchar* _tmp41_;
				_tmp41_ = g_strdup ("localhost");
				_g_free0 (_tmp39_);
				_tmp39_ = _tmp41_;
			}
			_tmp42_ = _tmp39_;
			_tmp43_ = g_strdup (_tmp42_);
			host = _tmp43_;
			_tmp44_ = plist;
			_tmp45_ = plist_get (_tmp44_, "port");
			_tmp46_ = _tmp45_;
			_tmp47_ = _tmp46_;
			if (_tmp47_ == NULL) {
				gchar* _tmp48_;
				_tmp48_ = g_strdup ("1178");
				_g_free0 (_tmp46_);
				_tmp46_ = _tmp48_;
			}
			_tmp49_ = _tmp46_;
			_tmp50_ = g_strdup (_tmp49_);
			port = _tmp50_;
			_tmp51_ = host;
			_tmp52_ = port;
			_tmp53_ = atoi (_tmp52_);
			_tmp54_ = encoding;
			_tmp55_ = skk_skk_serv_new (_tmp51_, (guint16) _tmp53_, _tmp54_, &_inner_error_);
			_tmp56_ = _tmp55_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (port);
				_g_free0 (_tmp46_);
				_g_free0 (host);
				_g_free0 (_tmp39_);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp2_);
				return NULL;
			}
			result = (SkkDict*) _tmp56_;
			_g_free0 (port);
			_g_free0 (_tmp46_);
			_g_free0 (host);
			_g_free0 (_tmp39_);
			_g_free0 (type);
			_g_free0 (encoding);
			_g_free0 (_tmp2_);
			return result;
		}
	}
	result = NULL;
	_g_free0 (type);
	_g_free0 (encoding);
	_g_free0 (_tmp2_);
	return result;
}


static void skk_engine_reload_dictionaries (void) {
	GeeArrayList* _tmp0_;
	Preferences* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* variant;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	size_t _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** strv;
	gint strv_length1;
	gint _strv_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError * _inner_error_ = NULL;
	_tmp0_ = skk_engine_dictionaries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = skk_engine_preferences;
	_tmp2_ = preferences_get (_tmp1_, "dictionaries");
	variant = _tmp2_;
	_tmp3_ = variant;
	g_assert (_tmp3_ != NULL);
	_tmp4_ = variant;
	_tmp6_ = g_variant_dup_strv (_tmp4_, &_tmp5_);
	strv = _tmp6_;
	strv_length1 = _tmp5_;
	_strv_size_ = strv_length1;
	_tmp7_ = strv;
	_tmp7__length1 = strv_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp7_;
		str_collection_length1 = _tmp7__length1;
		for (str_it = 0; str_it < _tmp7__length1; str_it = str_it + 1) {
			gchar* _tmp8_;
			gchar* str = NULL;
			_tmp8_ = g_strdup (str_collection[str_it]);
			str = _tmp8_;
			{
				{
					const gchar* _tmp9_;
					PList* _tmp10_;
					PList* plist;
					PList* _tmp11_;
					SkkDict* _tmp12_ = NULL;
					SkkDict* dict;
					SkkDict* _tmp13_;
					_tmp9_ = str;
					_tmp10_ = plist_new (_tmp9_, &_inner_error_);
					plist = _tmp10_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							goto __catch0_plist_parse_error;
						}
						goto __catch0_g_error;
					}
					_tmp11_ = plist;
					_tmp12_ = skk_engine_parse_dict_from_plist (_tmp11_, &_inner_error_);
					dict = _tmp12_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (plist);
						if (_inner_error_->domain == PLIST_PARSE_ERROR) {
							goto __catch0_plist_parse_error;
						}
						goto __catch0_g_error;
					}
					_tmp13_ = dict;
					if (_tmp13_ != NULL) {
						GeeArrayList* _tmp14_;
						SkkDict* _tmp15_;
						_tmp14_ = skk_engine_dictionaries;
						_tmp15_ = dict;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
					}
					_g_object_unref0 (dict);
					_g_object_unref0 (plist);
				}
				goto __finally0;
				__catch0_plist_parse_error:
				{
					GError* e = NULL;
					const gchar* _tmp16_;
					GError* _tmp17_;
					const gchar* _tmp18_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp16_ = str;
					_tmp17_ = e;
					_tmp18_ = _tmp17_->message;
					g_warning ("engine.vala:280: can't parse plist \"%s\": %s", _tmp16_, _tmp18_);
					_g_error_free0 (e);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp19_;
					GError* _tmp20_;
					const gchar* _tmp21_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp19_ = str;
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					g_warning ("engine.vala:283: can't open dictionary \"%s\": %s", _tmp19_, _tmp21_);
					_g_error_free0 (e);
				}
				__finally0:
				if (_inner_error_ != NULL) {
					_g_free0 (str);
					strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_unref0 (variant);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_free0 (str);
			}
		}
	}
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}


static void skk_engine_apply_preferences (SkkEngine* self) {
	GVariant* variant = NULL;
	Preferences* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_;
	SkkContext* _tmp3_;
	GVariant* _tmp4_;
	size_t _tmp5_;
	const gchar** _tmp6_ = NULL;
	const gchar** _tmp7_;
	gint _tmp7__length1;
	Preferences* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* _tmp10_;
	SkkContext* _tmp11_;
	GVariant* _tmp12_;
	gint32 _tmp13_ = 0;
	Preferences* _tmp14_;
	GVariant* _tmp15_ = NULL;
	GVariant* _tmp16_;
	IBusLookupTable* _tmp17_;
	GVariant* _tmp18_;
	gint32 _tmp19_ = 0;
	Preferences* _tmp20_;
	GVariant* _tmp21_ = NULL;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	gint32 _tmp24_ = 0;
	Preferences* _tmp25_;
	GVariant* _tmp26_ = NULL;
	GVariant* _tmp27_;
	SkkContext* _tmp28_;
	GVariant* _tmp29_;
	gint32 _tmp30_ = 0;
	Preferences* _tmp31_;
	GVariant* _tmp32_ = NULL;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	gboolean _tmp35_ = FALSE;
	Preferences* _tmp36_;
	GVariant* _tmp37_ = NULL;
	GVariant* _tmp38_;
	SkkContext* _tmp39_;
	GVariant* _tmp40_;
	gboolean _tmp41_ = FALSE;
	Preferences* _tmp42_;
	GVariant* _tmp43_ = NULL;
	GVariant* _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = skk_engine_preferences;
	_tmp1_ = preferences_get (_tmp0_, "auto_start_henkan_keywords");
	_g_variant_unref0 (variant);
	variant = _tmp1_;
	_tmp2_ = variant;
	g_assert (_tmp2_ != NULL);
	_tmp3_ = self->priv->context;
	_tmp4_ = variant;
	_tmp6_ = g_variant_get_strv (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	skk_context_set_auto_start_henkan_keywords (_tmp3_, _tmp7_, _tmp5_);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp8_ = skk_engine_preferences;
	_tmp9_ = preferences_get (_tmp8_, "period_style");
	_g_variant_unref0 (variant);
	variant = _tmp9_;
	_tmp10_ = variant;
	g_assert (_tmp10_ != NULL);
	_tmp11_ = self->priv->context;
	_tmp12_ = variant;
	_tmp13_ = g_variant_get_int32 (_tmp12_);
	skk_context_set_period_style (_tmp11_, (SkkPeriodStyle) _tmp13_);
	_tmp14_ = skk_engine_preferences;
	_tmp15_ = preferences_get (_tmp14_, "page_size");
	_g_variant_unref0 (variant);
	variant = _tmp15_;
	_tmp16_ = variant;
	g_assert (_tmp16_ != NULL);
	_tmp17_ = self->priv->lookup_table;
	_tmp18_ = variant;
	_tmp19_ = g_variant_get_int32 (_tmp18_);
	ibus_lookup_table_set_page_size (_tmp17_, (guint) _tmp19_);
	_tmp20_ = skk_engine_preferences;
	_tmp21_ = preferences_get (_tmp20_, "pagination_start");
	_g_variant_unref0 (variant);
	variant = _tmp21_;
	_tmp22_ = variant;
	g_assert (_tmp22_ != NULL);
	_tmp23_ = variant;
	_tmp24_ = g_variant_get_int32 (_tmp23_);
	self->priv->page_start = (guint) _tmp24_;
	_tmp25_ = skk_engine_preferences;
	_tmp26_ = preferences_get (_tmp25_, "initial_input_mode");
	_g_variant_unref0 (variant);
	variant = _tmp26_;
	_tmp27_ = variant;
	g_assert (_tmp27_ != NULL);
	_tmp28_ = self->priv->context;
	_tmp29_ = variant;
	_tmp30_ = g_variant_get_int32 (_tmp29_);
	skk_context_set_input_mode (_tmp28_, (SkkInputMode) _tmp30_);
	_tmp31_ = skk_engine_preferences;
	_tmp32_ = preferences_get (_tmp31_, "show_annotation");
	_g_variant_unref0 (variant);
	variant = _tmp32_;
	_tmp33_ = variant;
	g_assert (_tmp33_ != NULL);
	_tmp34_ = variant;
	_tmp35_ = g_variant_get_boolean (_tmp34_);
	self->priv->show_annotation = _tmp35_;
	_tmp36_ = skk_engine_preferences;
	_tmp37_ = preferences_get (_tmp36_, "egg_like_newline");
	_g_variant_unref0 (variant);
	variant = _tmp37_;
	_tmp38_ = variant;
	g_assert (_tmp38_ != NULL);
	_tmp39_ = self->priv->context;
	_tmp40_ = variant;
	_tmp41_ = g_variant_get_boolean (_tmp40_);
	skk_context_set_egg_like_newline (_tmp39_, _tmp41_);
	_tmp42_ = skk_engine_preferences;
	_tmp43_ = preferences_get (_tmp42_, "typing_rule");
	_g_variant_unref0 (variant);
	variant = _tmp43_;
	_tmp44_ = variant;
	g_assert (_tmp44_ != NULL);
	{
		GVariant* _tmp45_;
		const gchar* _tmp46_ = NULL;
		SkkRule* _tmp47_;
		SkkRule* _tmp48_;
		SkkContext* _tmp49_;
		SkkRule* _tmp50_;
		_tmp45_ = variant;
		_tmp46_ = g_variant_get_string (_tmp45_, NULL);
		_tmp47_ = skk_rule_new (_tmp46_, &_inner_error_);
		_tmp48_ = _tmp47_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				goto __catch1_skk_rule_parse_error;
			}
			_g_variant_unref0 (variant);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp49_ = self->priv->context;
		_tmp50_ = _tmp48_;
		skk_context_set_typing_rule (_tmp49_, _tmp50_);
		_g_object_unref0 (_tmp50_);
	}
	goto __finally1;
	__catch1_skk_rule_parse_error:
	{
		GError* e = NULL;
		GVariant* _tmp51_;
		const gchar* _tmp52_ = NULL;
		GError* _tmp53_;
		const gchar* _tmp54_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp51_ = variant;
		_tmp52_ = g_variant_get_string (_tmp51_, NULL);
		_tmp53_ = e;
		_tmp54_ = _tmp53_->message;
		g_warning ("engine.vala:325: can't load typing rule %s: %s", _tmp52_, _tmp54_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_variant_unref0 (variant);
}


static IBusProperty* skk_engine_register_input_mode_property (SkkEngine* self, SkkInputMode mode, const gchar* name, const gchar* label, const gchar* symbol) {
	IBusProperty* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	IBusText* _tmp2_;
	IBusText* _tmp3_;
	IBusProperty* _tmp4_;
	IBusProperty* _tmp5_;
	IBusProperty* _tmp6_;
	IBusProperty* prop;
	GeeMap* _tmp7_;
	SkkInputMode _tmp8_;
	GeeMap* _tmp9_;
	SkkInputMode _tmp10_;
	const gchar* _tmp11_;
	GeeMap* _tmp12_;
	const gchar* _tmp13_;
	SkkInputMode _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = label;
	_tmp2_ = ibus_text_new_from_string (_tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_tmp4_ = ibus_property_new (_tmp0_, PROP_TYPE_RADIO, _tmp3_, NULL, NULL, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	prop = _tmp6_;
	_tmp7_ = self->priv->input_mode_props;
	_tmp8_ = mode;
	gee_map_set (_tmp7_, GINT_TO_POINTER (_tmp8_), prop);
	_tmp9_ = self->priv->input_mode_symbols;
	_tmp10_ = mode;
	_tmp11_ = symbol;
	gee_map_set (_tmp9_, GINT_TO_POINTER (_tmp10_), _tmp11_);
	_tmp12_ = self->priv->name_input_modes;
	_tmp13_ = name;
	_tmp14_ = mode;
	gee_map_set (_tmp12_, _tmp13_, GINT_TO_POINTER (_tmp14_));
	result = prop;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean skk_engine_process_lookup_table_key_event (SkkEngine* self, guint keyval, guint keycode, guint state) {
	gboolean result = FALSE;
	IBusLookupTable* _tmp0_;
	guint _tmp1_ = 0U;
	guint page_size;
	gboolean _tmp2_ = FALSE;
	guint _tmp3_;
	gboolean _tmp8_;
	guint _tmp28_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lookup_table;
	_tmp1_ = ibus_lookup_table_get_page_size (_tmp0_);
	page_size = _tmp1_;
	_tmp3_ = state;
	if (_tmp3_ == ((guint) 0)) {
		guint _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp4_ = keyval;
		_tmp5_ = g_unichar_to_string ((gunichar) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp7__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp2_ = _vala_string_array_contains (_tmp7_, _tmp7__length1, _tmp6_);
		_g_free0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		guint _tmp9_;
		gunichar _tmp10_ = 0U;
		gchar* _tmp11_ = NULL;
		gchar* label;
		_tmp9_ = keyval;
		_tmp10_ = g_unichar_tolower ((gunichar) _tmp9_);
		_tmp11_ = g_unichar_to_string (_tmp10_);
		label = _tmp11_;
		{
			gint index;
			index = 0;
			{
				gboolean _tmp12_;
				_tmp12_ = TRUE;
				while (TRUE) {
					gboolean _tmp13_;
					gint _tmp15_;
					guint _tmp16_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_ = 0;
					gchar** _tmp19_;
					gint _tmp19__length1;
					gint _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp13_ = _tmp12_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = index;
						index = _tmp14_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp15_ = index;
					_tmp16_ = page_size;
					_tmp17_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp17__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp18_ = MIN ((gint) _tmp16_, _tmp17__length1);
					if (!(_tmp15_ < _tmp18_)) {
						break;
					}
					_tmp19_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp19__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp20_ = index;
					_tmp21_ = _tmp19_[_tmp20_];
					_tmp22_ = label;
					if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
						SkkContext* _tmp23_;
						SkkCandidateList* _tmp24_;
						SkkCandidateList* _tmp25_;
						gint _tmp26_;
						gboolean _tmp27_ = FALSE;
						_tmp23_ = self->priv->context;
						_tmp24_ = skk_context_get_candidates (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = index;
						_tmp27_ = skk_candidate_list_select_at (_tmp25_, (guint) _tmp26_);
						result = _tmp27_;
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	_tmp28_ = state;
	if (_tmp28_ == ((guint) 0)) {
		gboolean retval;
		guint _tmp29_;
		gboolean _tmp46_;
		retval = FALSE;
		_tmp29_ = keyval;
		switch (_tmp29_) {
			case IBUS_Page_Up:
			case IBUS_KP_Page_Up:
			{
				SkkContext* _tmp30_;
				SkkCandidateList* _tmp31_;
				SkkCandidateList* _tmp32_;
				gboolean _tmp33_ = FALSE;
				_tmp30_ = self->priv->context;
				_tmp31_ = skk_context_get_candidates (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = skk_candidate_list_page_up (_tmp32_);
				retval = _tmp33_;
				break;
			}
			case IBUS_Page_Down:
			case IBUS_KP_Page_Down:
			{
				SkkContext* _tmp34_;
				SkkCandidateList* _tmp35_;
				SkkCandidateList* _tmp36_;
				gboolean _tmp37_ = FALSE;
				_tmp34_ = self->priv->context;
				_tmp35_ = skk_context_get_candidates (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = skk_candidate_list_page_down (_tmp36_);
				retval = _tmp37_;
				break;
			}
			case IBUS_Up:
			case IBUS_Left:
			{
				SkkContext* _tmp38_;
				SkkCandidateList* _tmp39_;
				SkkCandidateList* _tmp40_;
				gboolean _tmp41_ = FALSE;
				_tmp38_ = self->priv->context;
				_tmp39_ = skk_context_get_candidates (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = skk_candidate_list_cursor_up (_tmp40_);
				retval = _tmp41_;
				break;
			}
			case IBUS_Down:
			case IBUS_Right:
			{
				SkkContext* _tmp42_;
				SkkCandidateList* _tmp43_;
				SkkCandidateList* _tmp44_;
				gboolean _tmp45_ = FALSE;
				_tmp42_ = self->priv->context;
				_tmp43_ = skk_context_get_candidates (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = skk_candidate_list_cursor_down (_tmp44_);
				retval = _tmp45_;
				break;
			}
			default:
			{
				break;
			}
		}
		_tmp46_ = retval;
		if (_tmp46_) {
			skk_engine_set_lookup_table_cursor_pos (self);
			skk_engine_update_preedit (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gboolean skk_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state) {
	SkkEngine * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _state;
	gboolean _tmp1_ = FALSE;
	SkkContext* _tmp2_;
	SkkCandidateList* _tmp3_;
	SkkCandidateList* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp11_;
	guint _tmp12_;
	SkkModifierType modifiers;
	gchar* name;
	gunichar code;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gboolean _tmp27_;
	const gchar* _tmp33_;
	gunichar _tmp34_;
	SkkModifierType _tmp35_;
	SkkKeyEvent* _tmp36_;
	SkkKeyEvent* key;
	SkkContext* _tmp37_;
	SkkKeyEvent* _tmp38_;
	gboolean _tmp39_ = FALSE;
	gboolean retval;
	SkkContext* _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* output;
	const gchar* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	self = (SkkEngine*) base;
	_tmp0_ = state;
	_state = _tmp0_ & (((IBUS_CONTROL_MASK | IBUS_MOD1_MASK) | IBUS_MOD5_MASK) | IBUS_RELEASE_MASK);
	_tmp2_ = self->priv->context;
	_tmp3_ = skk_context_get_candidates (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = skk_candidate_list_get_page_visible (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		guint _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = keyval;
		_tmp8_ = keycode;
		_tmp9_ = _state;
		_tmp10_ = skk_engine_process_lookup_table_key_event (self, _tmp7_, _tmp8_, _tmp9_);
		_tmp1_ = _tmp10_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp11_ = _tmp1_;
	if (_tmp11_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = _state;
	modifiers = (SkkModifierType) _tmp12_;
	name = NULL;
	code = (gunichar) '\0';
	{
		SkkEngineEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_ENGINE_NAME_KEYVALS;
		entry_collection_length1 = G_N_ELEMENTS (SKK_ENGINE_NAME_KEYVALS);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_ENGINE_NAME_KEYVALS); entry_it = entry_it + 1) {
			SkkEngineEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkEngineEntry _tmp13_;
				gconstpointer _tmp14_;
				guint _tmp15_;
				_tmp13_ = entry;
				_tmp14_ = _tmp13_.key;
				_tmp15_ = keyval;
				if (GPOINTER_TO_UINT (_tmp14_) == _tmp15_) {
					SkkEngineEntry _tmp16_;
					gconstpointer _tmp17_;
					gchar* _tmp18_;
					_tmp16_ = entry;
					_tmp17_ = _tmp16_.value;
					_tmp18_ = g_strdup ((const gchar*) _tmp17_);
					_g_free0 (name);
					name = _tmp18_;
					break;
				}
			}
		}
	}
	{
		SkkEngineEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_ENGINE_CODE_KEYVALS;
		entry_collection_length1 = G_N_ELEMENTS (SKK_ENGINE_CODE_KEYVALS);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_ENGINE_CODE_KEYVALS); entry_it = entry_it + 1) {
			SkkEngineEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				SkkEngineEntry _tmp19_;
				gconstpointer _tmp20_;
				guint _tmp21_;
				_tmp19_ = entry;
				_tmp20_ = _tmp19_.key;
				_tmp21_ = keyval;
				if (GPOINTER_TO_UINT (_tmp20_) == _tmp21_) {
					SkkEngineEntry _tmp22_;
					gconstpointer _tmp23_;
					_tmp22_ = entry;
					_tmp23_ = _tmp22_.value;
					code = GPOINTER_TO_INT (_tmp23_);
					break;
				}
			}
		}
	}
	_tmp25_ = name;
	if (_tmp25_ == NULL) {
		gunichar _tmp26_;
		_tmp26_ = code;
		_tmp24_ = _tmp26_ == ((gunichar) '\0');
	} else {
		_tmp24_ = FALSE;
	}
	_tmp27_ = _tmp24_;
	if (_tmp27_) {
		gboolean _tmp28_ = FALSE;
		guint _tmp29_;
		gboolean _tmp31_;
		_tmp29_ = keyval;
		if (((guint) 0x20) <= _tmp29_) {
			guint _tmp30_;
			_tmp30_ = keyval;
			_tmp28_ = _tmp30_ < ((guint) 0x7F);
		} else {
			_tmp28_ = FALSE;
		}
		_tmp31_ = _tmp28_;
		if (_tmp31_) {
			guint _tmp32_;
			_tmp32_ = keyval;
			code = (gunichar) _tmp32_;
		} else {
			result = FALSE;
			_g_free0 (name);
			return result;
		}
	}
	_tmp33_ = name;
	_tmp34_ = code;
	_tmp35_ = modifiers;
	_tmp36_ = skk_key_event_new (_tmp33_, _tmp34_, _tmp35_);
	key = _tmp36_;
	_tmp37_ = self->priv->context;
	_tmp38_ = key;
	_tmp39_ = skk_context_process_key_event (_tmp37_, _tmp38_);
	retval = _tmp39_;
	_tmp40_ = self->priv->context;
	_tmp41_ = skk_context_poll_output (_tmp40_);
	output = _tmp41_;
	_tmp42_ = output;
	_tmp43_ = strlen (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ > 0) {
		const gchar* _tmp45_;
		IBusText* _tmp46_;
		IBusText* _tmp47_;
		IBusText* text;
		IBusText* _tmp48_;
		_tmp45_ = output;
		_tmp46_ = ibus_text_new_from_string (_tmp45_);
		_tmp47_ = g_object_ref_sink (_tmp46_);
		text = _tmp47_;
		_tmp48_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp48_);
		_g_object_unref0 (text);
	}
	{
		SkkEngineEntry* entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = SKK_ENGINE_IGNORE_KEYVALS;
		entry_collection_length1 = G_N_ELEMENTS (SKK_ENGINE_IGNORE_KEYVALS);
		for (entry_it = 0; entry_it < G_N_ELEMENTS (SKK_ENGINE_IGNORE_KEYVALS); entry_it = entry_it + 1) {
			SkkEngineEntry entry = {0};
			entry = entry_collection[entry_it];
			{
				gboolean _tmp49_ = FALSE;
				SkkEngineEntry _tmp50_;
				gconstpointer _tmp51_;
				guint _tmp52_;
				gboolean _tmp56_;
				_tmp50_ = entry;
				_tmp51_ = _tmp50_.key;
				_tmp52_ = keyval;
				if (GPOINTER_TO_UINT (_tmp51_) == _tmp52_) {
					SkkEngineEntry _tmp53_;
					gconstpointer _tmp54_;
					SkkModifierType _tmp55_;
					_tmp53_ = entry;
					_tmp54_ = _tmp53_.value;
					_tmp55_ = modifiers;
					_tmp49_ = GPOINTER_TO_UINT (_tmp54_) == ((guint) _tmp55_);
				} else {
					_tmp49_ = FALSE;
				}
				_tmp56_ = _tmp49_;
				if (_tmp56_) {
					result = TRUE;
					_g_free0 (output);
					_g_object_unref0 (key);
					_g_free0 (name);
					return result;
				}
			}
		}
	}
	result = retval;
	_g_free0 (output);
	_g_object_unref0 (key);
	_g_free0 (name);
	return result;
}


static void skk_engine_real_enable (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkContext* _tmp1_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	_tmp1_ = self->priv->context;
	skk_context_clear_output (_tmp1_);
	ibus_engine_get_surrounding_text ((IBusEngine*) self, NULL, NULL, NULL);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->enable (IBUS_ENGINE (self));
}


static void skk_engine_real_disable (IBusEngine* base) {
	SkkEngine * self;
	self = (SkkEngine*) base;
	g_signal_emit_by_name ((IBusEngine*) self, "focus-out");
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->disable (IBUS_ENGINE (self));
}


static void skk_engine_real_reset (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkContext* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* output;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_poll_output (_tmp1_);
	output = _tmp2_;
	_tmp3_ = output;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		const gchar* _tmp6_;
		IBusText* _tmp7_;
		IBusText* _tmp8_;
		IBusText* text;
		IBusText* _tmp9_;
		_tmp6_ = output;
		_tmp7_ = ibus_text_new_from_string (_tmp6_);
		_tmp8_ = g_object_ref_sink (_tmp7_);
		text = _tmp8_;
		_tmp9_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp9_);
		_g_object_unref0 (text);
	}
	skk_engine_update_preedit (self);
	skk_engine_update_candidates (self);
	skk_engine_update_input_mode (self);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->reset (IBUS_ENGINE (self));
	_g_free0 (output);
}


static void skk_engine_real_focus_in (IBusEngine* base) {
	SkkEngine * self;
	IBusPropList* _tmp0_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->prop_list;
	ibus_engine_register_properties ((IBusEngine*) self, _tmp0_);
	skk_engine_update_preedit (self);
	skk_engine_update_candidates (self);
	skk_engine_update_input_mode (self);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->focus_in (IBUS_ENGINE (self));
}


static void skk_engine_real_focus_out (IBusEngine* base) {
	SkkEngine * self;
	SkkContext* _tmp0_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	ibus_engine_hide_preedit_text ((IBusEngine*) self);
	ibus_engine_hide_lookup_table ((IBusEngine*) self);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->focus_out (IBUS_ENGINE (self));
}


static void skk_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state) {
	SkkEngine * self;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (SkkEngine*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "setup") == 0) {
		gchar* _tmp1_ = NULL;
		gchar* filename;
		_tmp1_ = g_build_filename (LIBEXECDIR, "ibus-setup-skk", NULL);
		filename = _tmp1_;
		{
			const gchar* _tmp2_;
			_tmp2_ = filename;
			g_spawn_command_line_async (_tmp2_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch2_g_spawn_error;
				}
				_g_free0 (filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally2;
		__catch2_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = filename;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("engine.vala:538: can't spawn %s: %s", _tmp3_, _tmp5_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (filename);
	} else {
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp10_;
		_tmp7_ = prop_name;
		_tmp8_ = g_str_has_prefix (_tmp7_, "InputMode.");
		if (_tmp8_) {
			guint _tmp9_;
			_tmp9_ = prop_state;
			_tmp6_ = _tmp9_ == ((guint) PROP_STATE_CHECKED);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp10_ = _tmp6_;
		if (_tmp10_) {
			SkkContext* _tmp11_;
			GeeMap* _tmp12_;
			const gchar* _tmp13_;
			gpointer _tmp14_ = NULL;
			_tmp11_ = self->priv->context;
			_tmp12_ = self->priv->name_input_modes;
			_tmp13_ = prop_name;
			_tmp14_ = gee_map_get (_tmp12_, _tmp13_);
			skk_context_set_input_mode (_tmp11_, GPOINTER_TO_INT (_tmp14_));
		}
	}
}


static void __lambda0_ (void) {
	ibus_quit ();
}


static void ___lambda0__ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	__lambda0_ ();
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda1_ (const gchar* name, GVariant* value) {
	const gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		skk_engine_reload_dictionaries ();
	}
}


static void ___lambda1__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	__lambda1_ (name, value);
}


gint skk_engine_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* context;
	GOptionContext* _tmp1_;
	IBusBus* _tmp6_;
	IBusBus* _tmp7_;
	IBusBus* bus;
	IBusBus* _tmp8_;
	gboolean _tmp9_ = FALSE;
	IBusBus* _tmp11_;
	IBusBus* _tmp12_;
	IBusConfig* _tmp13_ = NULL;
	IBusConfig* _tmp14_;
	IBusConfig* config;
	IBusConfig* _tmp15_;
	Preferences* _tmp16_;
	GeeArrayList* _tmp17_;
	Preferences* _tmp18_;
	IBusBus* _tmp19_;
	GDBusConnection* _tmp20_ = NULL;
	IBusFactory* _tmp21_;
	IBusFactory* _tmp22_;
	IBusFactory* factory;
	IBusFactory* _tmp23_;
	gboolean _tmp24_;
	GError * _inner_error_ = NULL;
	ibus_init ();
	skk_init ();
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = g_option_context_new ("- ibus skk");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, SKK_ENGINE_options, "ibus-skk");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "%s\n", _tmp5_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp6_ = ibus_bus_new ();
	_tmp7_ = g_object_ref_sink (_tmp6_);
	bus = _tmp7_;
	_tmp8_ = bus;
	_tmp9_ = ibus_bus_is_connected (_tmp8_);
	if (!_tmp9_) {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		fprintf (_tmp10_, "Can not connect to ibus-daemon!\n");
		result = 1;
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	_tmp11_ = bus;
	g_signal_connect (_tmp11_, "disconnected", (GCallback) ___lambda0__ibus_bus_disconnected, NULL);
	_tmp12_ = bus;
	_tmp13_ = ibus_bus_get_config (_tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	config = _tmp14_;
	_tmp15_ = config;
	_tmp16_ = preferences_new (_tmp15_);
	_g_object_unref0 (skk_engine_preferences);
	skk_engine_preferences = _tmp16_;
	_tmp17_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (skk_engine_dictionaries);
	skk_engine_dictionaries = _tmp17_;
	skk_engine_reload_dictionaries ();
	_tmp18_ = skk_engine_preferences;
	g_signal_connect (_tmp18_, "value-changed", (GCallback) ___lambda1__preferences_value_changed, NULL);
	_tmp19_ = bus;
	_tmp20_ = ibus_bus_get_connection (_tmp19_);
	_tmp21_ = ibus_factory_new (_tmp20_);
	_tmp22_ = g_object_ref_sink (_tmp21_);
	factory = _tmp22_;
	_tmp23_ = factory;
	ibus_factory_add_engine (_tmp23_, "skk", TYPE_SKK_ENGINE);
	_tmp24_ = skk_engine_ibus;
	if (_tmp24_) {
		IBusBus* _tmp25_;
		_tmp25_ = bus;
		ibus_bus_request_name (_tmp25_, "org.freedesktop.IBus.SKK", (guint32) 0);
	} else {
		IBusComponent* _tmp26_;
		IBusComponent* _tmp27_;
		IBusComponent* component;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		IBusEngineDesc* _tmp30_;
		IBusEngineDesc* _tmp31_;
		IBusEngineDesc* _tmp32_;
		IBusEngineDesc* engine;
		IBusComponent* _tmp33_;
		IBusEngineDesc* _tmp34_;
		IBusBus* _tmp35_;
		IBusComponent* _tmp36_;
		_tmp26_ = ibus_component_new ("org.freedesktop.IBus.SKK", "SKK", PACKAGE_VERSION, "GPL", "Daiki Ueno <ueno@unixuser.org>", "http://code.google.com/p/ibus/", "", "ibus-skk");
		_tmp27_ = g_object_ref_sink (_tmp26_);
		component = _tmp27_;
		_tmp28_ = g_strdup_printf ("%s/icons/ibus-skk.svg", PACKAGE_DATADIR);
		_tmp29_ = _tmp28_;
		_tmp30_ = ibus_engine_desc_new ("skk", "SKK", "SKK Input Method", "ja", "GPL", "Daiki Ueno <ueno@unixuser.org>", _tmp29_, "us");
		_tmp31_ = g_object_ref_sink (_tmp30_);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp29_);
		engine = _tmp32_;
		_tmp33_ = component;
		_tmp34_ = engine;
		ibus_component_add_engine (_tmp33_, _tmp34_);
		_tmp35_ = bus;
		_tmp36_ = component;
		ibus_bus_register_component (_tmp35_, _tmp36_);
		_g_object_unref0 (engine);
		_g_object_unref0 (component);
	}
	ibus_main ();
	result = 0;
	_g_object_unref0 (factory);
	_g_object_unref0 (config);
	_g_object_unref0 (bus);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return skk_engine_main (argv, argc);
}


SkkEngine* skk_engine_construct (GType object_type) {
	SkkEngine * self = NULL;
	self = (SkkEngine*) g_object_new (object_type, NULL);
	return self;
}


SkkEngine* skk_engine_new (void) {
	return skk_engine_construct (TYPE_SKK_ENGINE);
}


static void _skk_engine___lambda2_ (SkkEngine* self, const gchar* name, GVariant* value) {
	const gchar* _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	skk_engine_apply_preferences (self);
	_tmp0_ = name;
	if (g_strcmp0 (_tmp0_, "dictionaries") == 0) {
		SkkContext* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _tmp3_ = 0;
		gpointer* _tmp4_ = NULL;
		SkkDict** _tmp5_;
		gint _tmp5__length1;
		_tmp1_ = self->priv->context;
		_tmp2_ = skk_engine_dictionaries;
		_tmp4_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp2_, &_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp3_;
		skk_context_set_dictionaries (_tmp1_, _tmp5_, _tmp3_);
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_object_unref), NULL);
	}
}


static void __skk_engine___lambda2__preferences_value_changed (Preferences* _sender, const gchar* name, GVariant* value, gpointer self) {
	_skk_engine___lambda2_ (self, name, value);
}


static void _skk_engine___lambda3_ (SkkEngine* self) {
	skk_engine_update_preedit (self);
}


static void __skk_engine___lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_skk_engine___lambda3_ (self);
}


static void _skk_engine___lambda4_ (SkkEngine* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	skk_engine_update_input_mode (self);
}


static void __skk_engine___lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_skk_engine___lambda4_ (self, _sender, pspec);
}


static void _skk_engine___lambda5_ (SkkEngine* self) {
	skk_engine_populate_lookup_table (self);
}


static void __skk_engine___lambda5__skk_candidate_list_populated (SkkCandidateList* _sender, gpointer self) {
	_skk_engine___lambda5_ (self);
}


static void _skk_engine___lambda6_ (SkkEngine* self) {
	skk_engine_set_lookup_table_cursor_pos (self);
}


static void __skk_engine___lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_skk_engine___lambda6_ (self);
}


static void _skk_engine___lambda7_ (SkkEngine* self) {
	SkkContext* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* output;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp9_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_poll_output (_tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		const gchar* _tmp5_;
		IBusText* _tmp6_;
		IBusText* _tmp7_;
		IBusText* text;
		IBusText* _tmp8_;
		_tmp5_ = output;
		_tmp6_ = ibus_text_new_from_string (_tmp5_);
		_tmp7_ = g_object_ref_sink (_tmp6_);
		text = _tmp7_;
		_tmp8_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp8_);
		_g_object_unref0 (text);
	}
	_tmp9_ = self->priv->lookup_table_visible;
	if (_tmp9_) {
		ibus_engine_hide_lookup_table ((IBusEngine*) self);
		ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
		self->priv->lookup_table_visible = FALSE;
	}
	_g_free0 (output);
}


static void __skk_engine___lambda7__skk_candidate_list_selected (SkkCandidateList* _sender, SkkCandidate* candidate, gpointer self) {
	_skk_engine___lambda7_ (self);
}


static gboolean __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text (SkkContext* _sender, gchar** text, guint* cursor_pos, gpointer self) {
	gboolean result;
	result = _skk_engine_retrieve_surrounding_text (self, text, cursor_pos);
	return result;
}


static gboolean __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text (SkkContext* _sender, gint offset, guint nchars, gpointer self) {
	gboolean result;
	result = _skk_engine_delete_surrounding_text (self, offset, nchars);
	return result;
}


static GObject * skk_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SkkEngine * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	IBusLookupTable* _tmp1_;
	IBusLookupTable* _tmp2_;
	IBusLookupTable* _tmp16_;
	IBusPropList* _tmp17_;
	IBusPropList* _tmp18_;
	IBusPropList* _tmp19_;
	IBusPropList* _tmp20_;
	IBusPropList* props;
	IBusProperty* prop = NULL;
	const gchar* _tmp21_ = NULL;
	IBusProperty* _tmp22_ = NULL;
	IBusPropList* _tmp23_;
	IBusProperty* _tmp24_;
	const gchar* _tmp25_ = NULL;
	IBusProperty* _tmp26_ = NULL;
	IBusPropList* _tmp27_;
	IBusProperty* _tmp28_;
	const gchar* _tmp29_ = NULL;
	IBusProperty* _tmp30_ = NULL;
	IBusPropList* _tmp31_;
	IBusProperty* _tmp32_;
	const gchar* _tmp33_ = NULL;
	IBusProperty* _tmp34_ = NULL;
	IBusPropList* _tmp35_;
	IBusProperty* _tmp36_;
	const gchar* _tmp37_ = NULL;
	IBusProperty* _tmp38_ = NULL;
	IBusPropList* _tmp39_;
	IBusProperty* _tmp40_;
	IBusText* _tmp41_;
	IBusText* _tmp42_;
	const gchar* _tmp43_ = NULL;
	IBusText* _tmp44_;
	IBusText* _tmp45_;
	IBusPropList* _tmp46_;
	IBusProperty* _tmp47_;
	IBusProperty* _tmp48_;
	IBusPropList* _tmp49_;
	IBusProperty* _tmp50_;
	IBusProperty* _tmp51_;
	IBusProperty* _tmp52_;
	const gchar* _tmp53_ = NULL;
	IBusText* _tmp54_;
	IBusText* _tmp55_;
	const gchar* _tmp56_ = NULL;
	IBusText* _tmp57_;
	IBusText* _tmp58_;
	IBusProperty* _tmp59_;
	IBusProperty* _tmp60_;
	IBusPropList* _tmp61_;
	IBusProperty* _tmp62_;
	GeeArrayList* _tmp63_;
	gint _tmp64_ = 0;
	gpointer* _tmp65_ = NULL;
	SkkDict** _tmp66_;
	gint _tmp66__length1;
	SkkContext* _tmp67_;
	Preferences* _tmp68_;
	SkkContext* _tmp69_;
	SkkContext* _tmp70_;
	SkkContext* _tmp71_;
	SkkCandidateList* _tmp72_;
	SkkCandidateList* _tmp73_;
	SkkContext* _tmp74_;
	SkkCandidateList* _tmp75_;
	SkkCandidateList* _tmp76_;
	SkkContext* _tmp77_;
	SkkCandidateList* _tmp78_;
	SkkCandidateList* _tmp79_;
	SkkContext* _tmp80_;
	SkkContext* _tmp81_;
	parent_class = G_OBJECT_CLASS (skk_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SKK_ENGINE (obj);
	_tmp0_ = self->priv->LOOKUP_TABLE_LABELS;
	_tmp0__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
	_tmp1_ = ibus_lookup_table_new ((guint) _tmp0__length1, (guint) 0, TRUE, FALSE);
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->lookup_table);
	self->priv->lookup_table = _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				const gchar* _tmp10_;
				IBusText* _tmp11_;
				IBusText* _tmp12_;
				IBusText* text;
				IBusLookupTable* _tmp13_;
				gint _tmp14_;
				IBusText* _tmp15_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp7__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp8__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = ibus_text_new_from_string (_tmp10_);
				_tmp12_ = g_object_ref_sink (_tmp11_);
				text = _tmp12_;
				_tmp13_ = self->priv->lookup_table;
				_tmp14_ = i;
				_tmp15_ = text;
				ibus_lookup_table_set_label (_tmp13_, (guint) _tmp14_, _tmp15_);
				_g_object_unref0 (text);
			}
		}
	}
	_tmp16_ = self->priv->lookup_table;
	ibus_lookup_table_set_orientation (_tmp16_, (gint) IBUS_ORIENTATION_HORIZONTAL);
	_tmp17_ = ibus_prop_list_new ();
	_tmp18_ = g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->prop_list);
	self->priv->prop_list = _tmp18_;
	_tmp19_ = ibus_prop_list_new ();
	_tmp20_ = g_object_ref_sink (_tmp19_);
	props = _tmp20_;
	_tmp21_ = _ ("Hiragana");
	_tmp22_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_HIRAGANA, "InputMode.Hiragana", _tmp21_, "あ");
	_g_object_unref0 (prop);
	prop = _tmp22_;
	_tmp23_ = props;
	_tmp24_ = prop;
	ibus_prop_list_append (_tmp23_, _tmp24_);
	_tmp25_ = _ ("Katakana");
	_tmp26_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_KATAKANA, "InputMode.Katakana", _tmp25_, "ア");
	_g_object_unref0 (prop);
	prop = _tmp26_;
	_tmp27_ = props;
	_tmp28_ = prop;
	ibus_prop_list_append (_tmp27_, _tmp28_);
	_tmp29_ = _ ("HankakuKatakana");
	_tmp30_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_HANKAKU_KATAKANA, "InputMode.HankakuKatakana", _tmp29_, "_ｱ");
	_g_object_unref0 (prop);
	prop = _tmp30_;
	_tmp31_ = props;
	_tmp32_ = prop;
	ibus_prop_list_append (_tmp31_, _tmp32_);
	_tmp33_ = _ ("Latin");
	_tmp34_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_LATIN, "InputMode.Latin", _tmp33_, "_A");
	_g_object_unref0 (prop);
	prop = _tmp34_;
	_tmp35_ = props;
	_tmp36_ = prop;
	ibus_prop_list_append (_tmp35_, _tmp36_);
	_tmp37_ = _ ("WideLatin");
	_tmp38_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_WIDE_LATIN, "InputMode.WideLatin", _tmp37_, "Ａ");
	_g_object_unref0 (prop);
	prop = _tmp38_;
	_tmp39_ = props;
	_tmp40_ = prop;
	ibus_prop_list_append (_tmp39_, _tmp40_);
	_tmp41_ = ibus_text_new_from_string ("あ");
	_tmp42_ = g_object_ref_sink (_tmp41_);
	_tmp43_ = _ ("Switch input mode");
	_tmp44_ = ibus_text_new_from_string (_tmp43_);
	_tmp45_ = g_object_ref_sink (_tmp44_);
	_tmp46_ = props;
	_tmp47_ = ibus_property_new ("InputMode", PROP_TYPE_MENU, _tmp42_, NULL, _tmp45_, TRUE, TRUE, PROP_STATE_UNCHECKED, _tmp46_);
	_tmp48_ = g_object_ref_sink (_tmp47_);
	_g_object_unref0 (prop);
	prop = _tmp48_;
	_g_object_unref0 (_tmp45_);
	_g_object_unref0 (_tmp42_);
	_tmp49_ = self->priv->prop_list;
	_tmp50_ = prop;
	ibus_prop_list_append (_tmp49_, _tmp50_);
	_tmp51_ = prop;
	_tmp52_ = _g_object_ref0 (_tmp51_);
	_g_object_unref0 (self->priv->input_mode_prop);
	self->priv->input_mode_prop = _tmp52_;
	_tmp53_ = _ ("Setup");
	_tmp54_ = ibus_text_new_from_string (_tmp53_);
	_tmp55_ = g_object_ref_sink (_tmp54_);
	_tmp56_ = _ ("Configure SKK");
	_tmp57_ = ibus_text_new_from_string (_tmp56_);
	_tmp58_ = g_object_ref_sink (_tmp57_);
	_tmp59_ = ibus_property_new ("setup", PROP_TYPE_NORMAL, _tmp55_, "gtk-preferences", _tmp58_, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	_tmp60_ = g_object_ref_sink (_tmp59_);
	_g_object_unref0 (prop);
	prop = _tmp60_;
	_g_object_unref0 (_tmp58_);
	_g_object_unref0 (_tmp55_);
	_tmp61_ = self->priv->prop_list;
	_tmp62_ = prop;
	ibus_prop_list_append (_tmp61_, _tmp62_);
	_tmp63_ = skk_engine_dictionaries;
	_tmp65_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp63_, &_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp66__length1 = _tmp64_;
	_tmp67_ = skk_context_new (_tmp66_, _tmp64_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp67_;
	_tmp66_ = (_vala_array_free (_tmp66_, _tmp66__length1, (GDestroyNotify) g_object_unref), NULL);
	skk_engine_apply_preferences (self);
	_tmp68_ = skk_engine_preferences;
	g_signal_connect_object (_tmp68_, "value-changed", (GCallback) __skk_engine___lambda2__preferences_value_changed, self, 0);
	_tmp69_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp69_, "notify::preedit", (GCallback) __skk_engine___lambda3__g_object_notify, self, 0);
	_tmp70_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp70_, "notify::input-mode", (GCallback) __skk_engine___lambda4__g_object_notify, self, 0);
	_tmp71_ = self->priv->context;
	_tmp72_ = skk_context_get_candidates (_tmp71_);
	_tmp73_ = _tmp72_;
	g_signal_connect_object (_tmp73_, "populated", (GCallback) __skk_engine___lambda5__skk_candidate_list_populated, self, 0);
	_tmp74_ = self->priv->context;
	_tmp75_ = skk_context_get_candidates (_tmp74_);
	_tmp76_ = _tmp75_;
	g_signal_connect_object ((GObject*) _tmp76_, "notify::cursor-pos", (GCallback) __skk_engine___lambda6__g_object_notify, self, 0);
	_tmp77_ = self->priv->context;
	_tmp78_ = skk_context_get_candidates (_tmp77_);
	_tmp79_ = _tmp78_;
	g_signal_connect_object (_tmp79_, "selected", (GCallback) __skk_engine___lambda7__skk_candidate_list_selected, self, 0);
	skk_engine_update_candidates (self);
	skk_engine_update_input_mode (self);
	_tmp80_ = self->priv->context;
	g_signal_connect_object (_tmp80_, "retrieve-surrounding-text", (GCallback) __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text, self, 0);
	_tmp81_ = self->priv->context;
	g_signal_connect_object (_tmp81_, "delete-surrounding-text", (GCallback) __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text, self, 0);
	_g_object_unref0 (prop);
	_g_object_unref0 (props);
	return obj;
}


static void skk_engine_entry_copy (const SkkEngineEntry* self, SkkEngineEntry* dest) {
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	_tmp0_ = (*self).key;
	(*dest).key = _tmp0_;
	_tmp1_ = (*self).value;
	(*dest).value = _tmp1_;
}


static void skk_engine_entry_destroy (SkkEngineEntry* self) {
}


static SkkEngineEntry* skk_engine_entry_dup (const SkkEngineEntry* self) {
	SkkEngineEntry* dup;
	dup = g_new0 (SkkEngineEntry, 1);
	skk_engine_entry_copy (self, dup);
	return dup;
}


static void skk_engine_entry_free (SkkEngineEntry* self) {
	skk_engine_entry_destroy (self);
	g_free (self);
}


static GType skk_engine_entry_get_type (void) {
	static volatile gsize skk_engine_entry_type_id__volatile = 0;
	if (g_once_init_enter (&skk_engine_entry_type_id__volatile)) {
		GType skk_engine_entry_type_id;
		skk_engine_entry_type_id = g_boxed_type_register_static ("SkkEngineEntry", (GBoxedCopyFunc) skk_engine_entry_dup, (GBoxedFreeFunc) skk_engine_entry_free);
		g_once_init_leave (&skk_engine_entry_type_id__volatile, skk_engine_entry_type_id);
	}
	return skk_engine_entry_type_id__volatile;
}


static void skk_engine_class_init (SkkEngineClass * klass) {
	skk_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkEnginePrivate));
	IBUS_ENGINE_CLASS (klass)->process_key_event = skk_engine_real_process_key_event;
	IBUS_ENGINE_CLASS (klass)->enable = skk_engine_real_enable;
	IBUS_ENGINE_CLASS (klass)->disable = skk_engine_real_disable;
	IBUS_ENGINE_CLASS (klass)->reset = skk_engine_real_reset;
	IBUS_ENGINE_CLASS (klass)->focus_in = skk_engine_real_focus_in;
	IBUS_ENGINE_CLASS (klass)->focus_out = skk_engine_real_focus_out;
	IBUS_ENGINE_CLASS (klass)->property_activate = skk_engine_real_property_activate;
	G_OBJECT_CLASS (klass)->constructor = skk_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = skk_engine_finalize;
}


static void skk_engine_instance_init (SkkEngine * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_ = NULL;
	self->priv = SKK_ENGINE_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (SKK_TYPE_INPUT_MODE, NULL, NULL, IBUS_TYPE_PROPERTY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->input_mode_props = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (SKK_TYPE_INPUT_MODE, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	self->priv->input_mode_symbols = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, SKK_TYPE_INPUT_MODE, NULL, NULL, NULL, NULL, NULL);
	self->priv->name_input_modes = (GeeMap*) _tmp2_;
	_tmp3_ = g_strdup ("a");
	_tmp4_ = g_strdup ("s");
	_tmp5_ = g_strdup ("d");
	_tmp6_ = g_strdup ("f");
	_tmp7_ = g_strdup ("j");
	_tmp8_ = g_strdup ("k");
	_tmp9_ = g_strdup ("l");
	_tmp10_ = g_strdup ("q");
	_tmp11_ = g_strdup ("w");
	_tmp12_ = g_strdup ("e");
	_tmp13_ = g_strdup ("r");
	_tmp14_ = g_strdup ("u");
	_tmp15_ = g_strdup ("i");
	_tmp16_ = g_strdup ("o");
	_tmp17_ = g_new0 (gchar*, 14 + 1);
	_tmp17_[0] = _tmp3_;
	_tmp17_[1] = _tmp4_;
	_tmp17_[2] = _tmp5_;
	_tmp17_[3] = _tmp6_;
	_tmp17_[4] = _tmp7_;
	_tmp17_[5] = _tmp8_;
	_tmp17_[6] = _tmp9_;
	_tmp17_[7] = _tmp10_;
	_tmp17_[8] = _tmp11_;
	_tmp17_[9] = _tmp12_;
	_tmp17_[10] = _tmp13_;
	_tmp17_[11] = _tmp14_;
	_tmp17_[12] = _tmp15_;
	_tmp17_[13] = _tmp16_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp17_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 14;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
}


static void skk_engine_finalize (GObject* obj) {
	SkkEngine * self;
	self = SKK_ENGINE (obj);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->lookup_table);
	_g_object_unref0 (self->priv->input_mode_prop);
	_g_object_unref0 (self->priv->prop_list);
	_g_object_unref0 (self->priv->input_mode_props);
	_g_object_unref0 (self->priv->input_mode_symbols);
	_g_object_unref0 (self->priv->name_input_modes);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (skk_engine_parent_class)->finalize (obj);
}


GType skk_engine_get_type (void) {
	static volatile gsize skk_engine_type_id__volatile = 0;
	if (g_once_init_enter (&skk_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkEngine), 0, (GInstanceInitFunc) skk_engine_instance_init, NULL };
		GType skk_engine_type_id;
		skk_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "SkkEngine", &g_define_type_info, 0);
		g_once_init_leave (&skk_engine_type_id__volatile, skk_engine_type_id);
	}
	return skk_engine_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



