/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public final class IntervalType
extends DTIType {
    public final boolean defaultPrecision;
    public final boolean isYearMonth;

    private IntervalType(int n, int n2, long l, int n3, int n4, int n5, boolean bl) {
        super(n, n2, l, n3, n4, n5);
        switch (n4) {
            case 101: 
            case 102: {
                this.isYearMonth = true;
                break;
            }
            default: {
                this.isYearMonth = false;
            }
        }
        this.defaultPrecision = bl;
    }

    @Override
    public int displaySize() {
        switch (this.typeCode) {
            case 101: {
                return (int)this.precision + 1;
            }
            case 107: {
                return (int)this.precision + 4;
            }
            case 102: {
                return (int)this.precision + 1;
            }
            case 103: {
                return (int)this.precision + 1;
            }
            case 108: {
                return (int)this.precision + 4;
            }
            case 109: {
                return (int)this.precision + 7;
            }
            case 110: {
                return (int)this.precision + 10 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 104: {
                return (int)this.precision + 1;
            }
            case 111: {
                return (int)this.precision + 4;
            }
            case 112: {
                return (int)this.precision + 7 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 105: {
                return (int)this.precision + 1;
            }
            case 113: {
                return (int)this.precision + 4 + (this.scale == 0 ? 0 : this.scale + 1);
            }
            case 106: {
                return (int)this.precision + 1 + (this.scale == 0 ? 0 : this.scale + 1);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    @Override
    public Class getJDBCClass() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return IntervalMonthData.class;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalSecondData.class;
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public String getJDBCClassName() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return IntervalMonthData.class.getName();
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return IntervalSecondData.class.getName();
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public int getJDBCPrecision() {
        return this.displaySize();
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 10;
    }

    @Override
    public String getNameString() {
        return "INTERVAL " + IntervalType.getQualifier(this.typeCode);
    }

    public static String getQualifier(int n) {
        switch (n) {
            case 101: {
                return "YEAR";
            }
            case 107: {
                return "YEAR TO MONTH";
            }
            case 102: {
                return "MONTH";
            }
            case 103: {
                return "DAY";
            }
            case 108: {
                return "DAY TO HOUR";
            }
            case 109: {
                return "DAY TO MINUTE";
            }
            case 110: {
                return "DAY TO SECOND";
            }
            case 104: {
                return "HOUR";
            }
            case 111: {
                return "HOUR TO MINUTE";
            }
            case 112: {
                return "HOUR TO SECOND";
            }
            case 105: {
                return "MINUTE";
            }
            case 113: {
                return "MINUTE TO SECOND";
            }
            case 106: {
                return "SECOND";
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public String getDefinition() {
        if (this.precision == 2L && (this.endIntervalType != 106 || this.scale == 6)) {
            return this.getNameString();
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("INTERVAL").append(' ');
        stringBuffer.append(IntervalType.getQualifier(this.startIntervalType));
        if (this.typeCode == 106) {
            stringBuffer.append('(');
            stringBuffer.append(this.precision);
            if (this.scale != 6) {
                stringBuffer.append(',');
                stringBuffer.append(this.scale);
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.precision != 2L) {
            stringBuffer.append('(');
            stringBuffer.append(this.precision);
            stringBuffer.append(')');
        }
        if (this.startIntervalType != this.endIntervalType) {
            stringBuffer.append(' ');
            stringBuffer.append("TO");
            stringBuffer.append(' ');
            stringBuffer.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.endPartIndex]);
            if (this.endIntervalType == 106 && this.scale != 6) {
                stringBuffer.append('(');
                stringBuffer.append(this.scale);
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isIntervalType() {
        return true;
    }

    public boolean isYearMonthIntervalType() {
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return true;
            }
        }
        return false;
    }

    public boolean isDaySecondIntervalType() {
        switch (this.typeCode) {
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean acceptsFractionalPrecision() {
        return this.endIntervalType == 106;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (this.typeCode == type.typeCode) {
            if (this.precision >= type.precision && this.scale >= type.scale) {
                return this;
            }
            if (this.precision <= type.precision && this.scale <= type.scale) {
                return type;
            }
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (type.isCharacterType()) {
            return type.getAggregateType(this);
        }
        if (!type.isIntervalType()) {
            throw Error.error(5562);
        }
        int n = ((IntervalType)type).startIntervalType > this.startIntervalType ? this.startIntervalType : ((IntervalType)type).startIntervalType;
        int n2 = ((IntervalType)type).endIntervalType > this.endIntervalType ? ((IntervalType)type).endIntervalType : this.endIntervalType;
        int n3 = IntervalType.getCombinedIntervalType(n, n2);
        long l = this.precision > type.precision ? this.precision : type.precision;
        int n4 = this.scale > type.scale ? this.scale : type.scale;
        try {
            return IntervalType.getIntervalType(n3, n, n2, l, n4, false);
        }
        catch (RuntimeException runtimeException) {
            throw Error.error(5562);
        }
    }

    @Override
    public Type getCombinedType(Type type, int n) {
        switch (n) {
            case 34: {
                if (!type.isNumberType()) break;
                return IntervalType.getIntervalType(this, 9L, this.scale);
            }
            case 35: {
                if (!type.isNumberType()) break;
                return this;
            }
            case 32: {
                if (type.isDateTimeType()) {
                    return type.getCombinedType(this, n);
                }
                if (!type.isIntervalType()) break;
                IntervalType intervalType = (IntervalType)this.getAggregateType(type);
                return IntervalType.getIntervalType(intervalType, 9L, 0);
            }
            default: {
                return this.getAggregateType(type);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return ((IntervalMonthData)object).compareTo((IntervalMonthData)object2);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return ((IntervalSecondData)object).compareTo((IntervalSecondData)object2);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IntervalMonthData) {
            IntervalMonthData intervalMonthData = (IntervalMonthData)object;
            if (intervalMonthData.units > this.getIntervalValueLimit()) {
                throw Error.error(3435);
            }
        } else if (object instanceof IntervalSecondData) {
            IntervalSecondData intervalSecondData = (IntervalSecondData)object;
            if (intervalSecondData.units > this.getIntervalValueLimit()) {
                throw Error.error(3435);
            }
        }
        return object;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        switch (type.typeCode) {
            case 40: {
                object = object.toString();
            }
            case 1: 
            case 12: 
            case 100: {
                return sessionInterface.getScanner().convertToDatetimeInterval(sessionInterface, (String)object, this);
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                if (object instanceof BigDecimal && !NumberType.isInLongLimits((BigDecimal)object)) {
                    throw Error.error(3435);
                }
                long l = ((Number)object).longValue();
                switch (this.endIntervalType) {
                    case 101: {
                        return IntervalMonthData.newIntervalYear(l, this);
                    }
                    case 102: {
                        return IntervalMonthData.newIntervalMonth(l, this);
                    }
                    case 103: {
                        return IntervalSecondData.newIntervalDay(l, this);
                    }
                    case 104: {
                        return IntervalSecondData.newIntervalHour(l, this);
                    }
                    case 105: {
                        return IntervalSecondData.newIntervalMinute(l, this);
                    }
                    case 106: {
                        int n = 0;
                        if (this.scale > 0 && object instanceof BigDecimal) {
                            n = (int)NumberType.scaledDecimal(object, 9);
                        }
                        return new IntervalSecondData(l, n, this);
                    }
                }
                throw Error.error(5561);
            }
            case 101: {
                long l = ((IntervalMonthData)object).units / 12L * 12L;
                return new IntervalMonthData(l, this);
            }
            case 102: 
            case 107: {
                long l = ((IntervalMonthData)object).units;
                return new IntervalMonthData(l, this);
            }
            case 103: {
                long l = ((IntervalSecondData)object).units;
                l = l / (long)DTIType.yearToSecondFactors[2] * (long)DTIType.yearToSecondFactors[2];
                return new IntervalSecondData(l, 0, this);
            }
            case 104: 
            case 105: 
            case 108: 
            case 109: 
            case 111: {
                long l = ((IntervalSecondData)object).units;
                l = l / (long)DTIType.yearToSecondFactors[this.endPartIndex] * (long)DTIType.yearToSecondFactors[this.endPartIndex];
                return new IntervalSecondData(l, 0, this);
            }
            case 106: 
            case 110: 
            case 112: 
            case 113: {
                long l = ((IntervalSecondData)object).units;
                int n = ((IntervalSecondData)object).nanos;
                n = this.scale == 0 ? 0 : n / DTIType.nanoScaleFactors[this.scale] * DTIType.nanoScaleFactors[this.scale];
                return new IntervalSecondData(l, n, this);
            }
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return this.convertToType(null, object, Type.SQL_VARCHAR);
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                return this.intervalMonthToString(object);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return this.intervalSecondToString(object);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("INTERVAL").append(' ');
        stringBuffer.append('\'').append(this.convertToString(object)).append('\'').append(' ');
        stringBuffer.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.startPartIndex]);
        stringBuffer.append(' ');
        stringBuffer.append("TO");
        stringBuffer.append(' ');
        stringBuffer.append(Tokens.SQL_INTERVAL_FIELD_NAMES[this.endPartIndex]);
        return stringBuffer.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type.typeCode == 0) {
            return true;
        }
        if (type.isCharacterType()) {
            return true;
        }
        if (type.isNumberType()) {
            return true;
        }
        if (!type.isIntervalType()) {
            return false;
        }
        return !(this.isYearMonthIntervalType() ^ ((IntervalType)type).isYearMonthIntervalType());
    }

    @Override
    public int compareToTypeRange(Object object) {
        long l;
        long l2 = precisionLimits[(int)this.precision];
        if (object instanceof IntervalMonthData) {
            l = ((IntervalMonthData)object).units;
        } else if (object instanceof IntervalSecondData) {
            l = ((IntervalSecondData)object).units;
        } else {
            return 0;
        }
        if (l >= l2) {
            return 1;
        }
        if (l < 0L && -l >= l2) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object absolute(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IntervalMonthData ? ((IntervalMonthData)object).units < 0L : ((IntervalSecondData)object).units < 0L || ((IntervalSecondData)object).nanos < 0) {
            return this.negate(object);
        }
        return object;
    }

    @Override
    public Object negate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IntervalMonthData) {
            long l = ((IntervalMonthData)object).units;
            return new IntervalMonthData(-l, this);
        }
        long l = ((IntervalSecondData)object).units;
        int n = ((IntervalSecondData)object).nanos;
        return new IntervalSecondData(-l, -n, this, true);
    }

    @Override
    public Object add(Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                long l = ((IntervalMonthData)object).units + ((IntervalMonthData)object2).units;
                return new IntervalMonthData(l, this);
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                long l = ((IntervalSecondData)object).units + ((IntervalSecondData)object2).units;
                long l2 = ((IntervalSecondData)object).nanos + ((IntervalSecondData)object2).nanos;
                return new IntervalSecondData(l, l2, this, true);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public Object subtract(Object object, Object object2, Type type) {
        if (object == null || object2 == null) {
            return null;
        }
        switch (this.typeCode) {
            case 101: 
            case 102: 
            case 107: {
                if (object instanceof IntervalMonthData && object2 instanceof IntervalMonthData) {
                    long l = ((IntervalMonthData)object).units - ((IntervalMonthData)object2).units;
                    return new IntervalMonthData(l, this);
                }
                if (object instanceof TimestampData && object2 instanceof TimestampData) {
                    boolean bl = this.typeCode == 101;
                    long l = DateTimeType.subtractMonths((TimestampData)object, (TimestampData)object2, bl);
                    return new IntervalMonthData(l, this);
                }
                throw Error.runtimeError(201, "IntervalType");
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                if (object instanceof IntervalSecondData && object2 instanceof IntervalSecondData) {
                    long l = ((IntervalSecondData)object).units - ((IntervalSecondData)object2).units;
                    long l2 = ((IntervalSecondData)object).nanos - ((IntervalSecondData)object2).nanos;
                    return new IntervalSecondData(l, l2, this, true);
                }
                if (object instanceof TimeData && object2 instanceof TimeData) {
                    long l = ((TimeData)object).getSeconds() - ((TimeData)object2).getSeconds();
                    long l3 = ((TimeData)object).getNanos() - ((TimeData)object2).getNanos();
                    return new IntervalSecondData(l, l3, this, true);
                }
                if (!(object instanceof TimestampData) || !(object2 instanceof TimestampData)) break;
                long l = ((TimestampData)object).getSeconds() - ((TimestampData)object2).getSeconds();
                long l4 = ((TimestampData)object).getNanos() - ((TimestampData)object2).getNanos();
                return new IntervalSecondData(l, l4, this, true);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    @Override
    public Object multiply(Object object, Object object2) {
        return this.multiplyOrDivide(object, object2, false);
    }

    @Override
    public Object divide(Object object, Object object2) {
        return this.multiplyOrDivide(object, object2, true);
    }

    private Object multiplyOrDivide(Object object, Object object2, boolean bl) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        Object object3;
        if (object == null || object2 == null) {
            return null;
        }
        if (object instanceof Number) {
            object3 = object;
            object = object2;
            object2 = object3;
        }
        if (bl && NumberType.isZero(object2)) {
            throw Error.error(3432);
        }
        object3 = NumberType.getNumberType(3, 40L, 9);
        BigDecimal bigDecimal3 = (BigDecimal)((NumberType)object3).convertToDefaultType(null, object2);
        if (this.isYearMonth) {
            bigDecimal2 = BigDecimal.valueOf(((IntervalMonthData)object).units);
        } else {
            long l = ((IntervalSecondData)object).units * (long)DTIType.nanoScaleFactors[0] + (long)((IntervalSecondData)object).nanos;
            bigDecimal2 = BigDecimal.valueOf(l, 9);
        }
        BigDecimal bigDecimal4 = bigDecimal = bl ? (BigDecimal)((NumberType)object3).divide(bigDecimal2, bigDecimal3) : (BigDecimal)((NumberType)object3).multiply(bigDecimal2, bigDecimal3);
        if (!NumberType.isInLongLimits(bigDecimal)) {
            throw Error.error(3435);
        }
        if (this.isYearMonth) {
            return new IntervalMonthData(bigDecimal.longValue(), this);
        }
        int n = (int)NumberType.scaledDecimal(bigDecimal, 9);
        return new IntervalSecondData(bigDecimal.longValue(), n, this, true);
    }

    String intervalMonthToString(Object object) {
        StringBuffer stringBuffer = new StringBuffer(8);
        long l = ((IntervalMonthData)object).units;
        if (l < 0L) {
            l = -l;
            stringBuffer.append('-');
        }
        for (int i = this.startPartIndex; i <= this.endPartIndex; ++i) {
            int n = DTIType.yearToSecondFactors[i];
            long l2 = l / (long)n;
            if (i == this.startPartIndex) {
                int n2 = (int)this.precision - IntervalType.getPrecisionExponent(l2);
            } else if (l2 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l2);
            l %= (long)n;
            if (i >= this.endPartIndex) continue;
            stringBuffer.append((char)DTIType.yearToSecondSeparators[i]);
        }
        return stringBuffer.toString();
    }

    String intervalSecondToString(Object object) {
        long l = ((IntervalSecondData)object).units;
        int n = ((IntervalSecondData)object).nanos;
        return this.intervalSecondToString(l, n, false);
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.isIntervalType()) {
            int n = ((IntervalType)type).endPartIndex;
            return n - this.endPartIndex;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getStartIntervalType() {
        return this.startIntervalType;
    }

    @Override
    public int getEndIntervalType() {
        return this.endIntervalType;
    }

    public static IntervalType newIntervalType(int n, long l, int n2) {
        int n3 = IntervalType.getStartIntervalType(n);
        int n4 = IntervalType.getEndIntervalType(n);
        int n5 = n3 > 102 ? 106 : 102;
        return new IntervalType(n5, n, l, n2, n3, n4, false);
    }

    public static IntervalType getIntervalType(IntervalType intervalType, long l, int n) {
        if (intervalType.precision >= l && intervalType.scale >= n) {
            return intervalType;
        }
        return IntervalType.getIntervalType(intervalType.typeCode, l, n);
    }

    public static IntervalType getIntervalType(int n, long l, int n2) {
        int n3 = IntervalType.getStartIntervalType(n);
        int n4 = IntervalType.getEndIntervalType(n);
        return IntervalType.getIntervalType(n, n3, n4, l, n2, false);
    }

    public static IntervalType getIntervalType(int n, int n2, long l, int n3) {
        boolean bl;
        boolean bl2 = bl = l == -1L;
        if (n == -1 || n2 == -1) {
            throw Error.error(3406);
        }
        if (n > n2) {
            throw Error.error(3406);
        }
        if (n <= 1 && n2 > 1) {
            throw Error.error(3406);
        }
        int n4 = DTIType.intervalParts[n];
        int n5 = DTIType.intervalParts[n2];
        int n6 = DTIType.intervalTypes[n][n2];
        if (l == 0L || l > 9L || n3 > 9) {
            throw Error.error(5592);
        }
        if (l == -1L) {
            l = 2L;
        }
        if (n3 == -1) {
            n3 = n5 == 106 ? 6 : 0;
        }
        return IntervalType.getIntervalType(n6, n4, n5, l, n3, bl);
    }

    public static IntervalType getIntervalType(int n, int n2, int n3, long l, int n4, boolean bl) {
        int n5;
        int n6 = n5 = n2 > 102 ? 106 : 102;
        if (bl) {
            return new IntervalType(n5, n, l, n4, n2, n3, bl);
        }
        switch (n) {
            case 101: {
                if (l != 2L) break;
                return SQL_INTERVAL_YEAR;
            }
            case 107: {
                if (l != 2L) break;
                return SQL_INTERVAL_YEAR_TO_MONTH;
            }
            case 102: {
                if (l != 2L) break;
                return SQL_INTERVAL_MONTH;
            }
            case 103: {
                if (l != 2L) break;
                return SQL_INTERVAL_DAY;
            }
            case 108: {
                if (l != 2L) break;
                return SQL_INTERVAL_DAY_TO_HOUR;
            }
            case 109: {
                if (l != 2L) break;
                return SQL_INTERVAL_DAY_TO_MINUTE;
            }
            case 110: {
                if (l != 2L || n4 != 6) break;
                return SQL_INTERVAL_DAY_TO_SECOND;
            }
            case 104: {
                if (l != 2L) break;
                return SQL_INTERVAL_HOUR;
            }
            case 111: {
                if (l != 2L) break;
                return SQL_INTERVAL_HOUR_TO_MINUTE;
            }
            case 105: {
                if (l != 2L) break;
                return SQL_INTERVAL_MINUTE;
            }
            case 112: {
                if (l != 2L || n4 != 6) break;
                return SQL_INTERVAL_HOUR_TO_SECOND;
            }
            case 113: {
                if (l != 2L || n4 != 6) break;
                return SQL_INTERVAL_MINUTE_TO_SECOND;
            }
            case 106: {
                if (l != 2L || n4 != 6) break;
                return SQL_INTERVAL_SECOND;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return new IntervalType(n5, n, l, n4, n2, n3, bl);
    }

    public static int getStartIntervalType(int n) {
        int n2;
        switch (n) {
            case 101: 
            case 107: {
                n2 = 101;
                break;
            }
            case 102: {
                n2 = 102;
                break;
            }
            case 103: 
            case 108: 
            case 109: 
            case 110: {
                n2 = 103;
                break;
            }
            case 104: 
            case 111: 
            case 112: {
                n2 = 104;
                break;
            }
            case 105: 
            case 113: {
                n2 = 105;
                break;
            }
            case 106: {
                n2 = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return n2;
    }

    public static int getEndIntervalType(int n) {
        int n2;
        switch (n) {
            case 101: {
                n2 = 101;
                break;
            }
            case 107: {
                n2 = 102;
                break;
            }
            case 102: {
                n2 = 102;
                break;
            }
            case 103: {
                n2 = 103;
                break;
            }
            case 108: {
                n2 = 104;
                break;
            }
            case 109: {
                n2 = 105;
                break;
            }
            case 110: {
                n2 = 106;
                break;
            }
            case 104: {
                n2 = 104;
                break;
            }
            case 111: {
                n2 = 105;
                break;
            }
            case 112: {
                n2 = 106;
                break;
            }
            case 105: {
                n2 = 105;
                break;
            }
            case 113: {
                n2 = 106;
                break;
            }
            case 106: {
                n2 = 106;
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return n2;
    }

    public static Type getCombinedIntervalType(IntervalType intervalType, IntervalType intervalType2) {
        int n = intervalType2.startIntervalType > intervalType.startIntervalType ? intervalType.startIntervalType : intervalType2.startIntervalType;
        int n2 = intervalType2.endIntervalType > intervalType.endIntervalType ? intervalType2.endIntervalType : intervalType.endIntervalType;
        int n3 = IntervalType.getCombinedIntervalType(n, n2);
        long l = intervalType.precision > intervalType2.precision ? intervalType.precision : intervalType2.precision;
        int n4 = intervalType.scale > intervalType2.scale ? intervalType.scale : intervalType2.scale;
        return IntervalType.getIntervalType(n3, n, n2, l, n4, false);
    }

    public static int getCombinedIntervalType(int n, int n2) {
        if (n == n2) {
            return n;
        }
        switch (n) {
            case 101: {
                if (n2 != 102) break;
                return 107;
            }
            case 103: {
                switch (n2) {
                    case 104: {
                        return 108;
                    }
                    case 105: {
                        return 109;
                    }
                    case 106: {
                        return 110;
                    }
                }
                break;
            }
            case 104: {
                switch (n2) {
                    case 105: {
                        return 111;
                    }
                    case 106: {
                        return 112;
                    }
                }
                break;
            }
            case 105: {
                if (n2 != 106) break;
                return 113;
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    long getIntervalValueLimit() {
        long l;
        switch (this.typeCode) {
            case 101: {
                l = DTIType.precisionLimits[(int)this.precision] * 12L;
                break;
            }
            case 107: {
                l = DTIType.precisionLimits[(int)this.precision] * 12L;
                l += 12L;
                break;
            }
            case 102: {
                l = DTIType.precisionLimits[(int)this.precision];
                break;
            }
            case 103: {
                l = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 108: {
                l = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 109: {
                l = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 110: {
                l = DTIType.precisionLimits[(int)this.precision] * 24L * 60L * 60L;
                break;
            }
            case 104: {
                l = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 111: {
                l = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 112: {
                l = DTIType.precisionLimits[(int)this.precision] * 60L * 60L;
                break;
            }
            case 105: {
                l = DTIType.precisionLimits[(int)this.precision] * 60L;
                break;
            }
            case 113: {
                l = DTIType.precisionLimits[(int)this.precision] * 60L;
                break;
            }
            case 106: {
                l = DTIType.precisionLimits[(int)this.precision];
                break;
            }
            default: {
                throw Error.runtimeError(201, "IntervalType");
            }
        }
        return l;
    }

    @Override
    public int getPart(Session session, Object object, int n) {
        switch (n) {
            case 101: {
                return (int)(((IntervalMonthData)object).units / 12L);
            }
            case 102: {
                long l = ((IntervalMonthData)object).units;
                return n == this.startIntervalType ? (int)l : (int)(l % 12L);
            }
            case 103: {
                return (int)(((IntervalSecondData)object).units / 86400L);
            }
            case 104: {
                long l = ((IntervalSecondData)object).units / 3600L;
                return n == this.startIntervalType ? (int)l : (int)(l % 24L);
            }
            case 105: {
                long l = ((IntervalSecondData)object).units / 60L;
                return n == this.startIntervalType ? (int)l : (int)(l % 60L);
            }
            case 106: {
                long l = ((IntervalSecondData)object).units;
                return n == this.startIntervalType ? (int)l : (int)(l % 60L);
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }

    public long getSeconds(Object object) {
        return ((IntervalSecondData)object).units;
    }

    @Override
    public BigDecimal getSecondPart(Object object) {
        long l = ((IntervalSecondData)object).units;
        if (this.typeCode != 106) {
            l %= 60L;
        }
        int n = ((IntervalSecondData)object).nanos;
        return this.getSecondPart(l, n);
    }

    public long convertToLong(Object object) {
        switch (this.endIntervalType) {
            case 101: 
            case 102: {
                long l = ((IntervalMonthData)object).units;
                return l / (long)DTIType.yearToSecondFactors[this.endPartIndex];
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                long l = ((IntervalSecondData)object).units;
                return l / (long)DTIType.yearToSecondFactors[this.endPartIndex];
            }
        }
        throw Error.runtimeError(201, "IntervalType");
    }
}

