{- This module was generated from data in the Kate syntax highlighting file asp.xml, version 1.03,
   by  Antonio Salazar (savedfastcool@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Asp ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "ASP"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.asp;"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "ASP" }
  context <- currentContext <|> (pushContext "nosource" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("ASP",["nosource"])], synStLanguage = "ASP", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "nosource" -> return () >> pHandleEndLine
    "aspsource" -> return () >> pHandleEndLine
    "asp_onelinecomment" -> (popContext) >> pEndLine
    "doublequotestring" -> return () >> pHandleEndLine
    "singlequotestring" -> return () >> pHandleEndLine
    "htmltag" -> return () >> pHandleEndLine
    "htmlcomment" -> return () >> pHandleEndLine
    "identifiers" -> return () >> pHandleEndLine
    "types1" -> return () >> pHandleEndLine
    "types2" -> return () >> pHandleEndLine
    "scripts" -> return () >> pHandleEndLine
    "scripts_onelinecomment" -> (popContext) >> pEndLine
    "twolinecomment" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Function","kw"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("String","st"),("Comment","co"),("Variable","kw"),("Control Structures","kw"),("Escape Code","kw"),("Other","ot"),("HTML Tag","kw"),("HTML Comment","co"),("Identifier","ot"),("Types","dt")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_control_structures = Set.fromList $ words $ "select case end select if then else elseif end if while do until loop wend for each to in next exit continue"
list_keywords = Set.fromList $ words $ "dim redim preserve const erase nothing set new me function sub call class private public with randomize open close movenext execute eof not true false or and xor"
list_functions = Set.fromList $ words $ "response write redirect end request form querystring servervariables cookies session server createobject abs array asc atn cbool cbyte ccur cdate cdbl chr cint clng cos csng cstr date dateadd datediff datepart dateserial datevalue date day exp filter fix formatcurrency formatdatetime formatnumber formatpercent getobject hex hour inputbox instr instrrev int isarray isdate isempty isnull isnumeric isobject join lbound lcase left len loadpicture log ltrim mid minute month monthname msgbox now oct replace rgb right rnd round rtrim scriptengine scriptenginebuildversion scriptenginemajorversion scriptengineminorversion second sgn sin space split sqr strcomp strreverse string tan time timer timeserial timevalue trim typename ubound ucase vartype weekday weekdayname year add addfolders buildpath clear close copy copyfile copyfolder createfolder createtextfile delete deletefile deletefolder driveexists exists fileexists folderexists getabsolutepathname getbasename getdrive getdrivename getextensionname getfile getfilename getfolder getparentfoldername getspecialfolder gettempname items item keys move movefile movefolder openastextstream opentextfile raise read readall readline remove removeall skip skipline write writeblanklines writeline"

regex_'3c'5cs'2ascript'5cs'2alanguage'3d'22VBScript'22'5b'5e'3e'5d'2a'3e = compileRegex "<\\s*script\\s*language=\"VBScript\"[^>]*>"
regex_'3c'5cs'2ascript'28'5cs'7c'3e'29 = compileRegex "<\\s*script(\\s|>)"
regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a = compileRegex "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*"
regex_'3c'5cs'2a'5c'2f'5cs'2ascript'5cs'2a'3e = compileRegex "<\\s*\\/\\s*script\\s*>"
regex_ = compileRegex ""
regex_'5b0123456789'5d'2a'5c'2e'5c'2e'5c'2e'5b0123456789'5d'2a = compileRegex "[0123456789]*\\.\\.\\.[0123456789]*"
regex_'5cbelseif'5cb = compileRegex "\\belseif\\b"
regex_'5cbelse'5cb = compileRegex "\\belse\\b"
regex_'5cbif'5cb = compileRegex "\\bif\\b"
regex_'5cbend_if'5cb = compileRegex "\\bend if\\b"
regex_'5cbexit_function'5cb = compileRegex "\\bexit function\\b"
regex_'5cbfunction'5cb = compileRegex "\\bfunction\\b"
regex_'5cbend_function'5cb = compileRegex "\\bend function\\b"
regex_'5cbexit_sub'5cb = compileRegex "\\bexit sub\\b"
regex_'5cbsub'5cb = compileRegex "\\bsub\\b"
regex_'5cbend_sub'5cb = compileRegex "\\bend sub\\b"
regex_'5cbclass'5cb = compileRegex "\\bclass\\b"
regex_'5cbend_class'5cb = compileRegex "\\bend class\\b"
regex_'5cbexit_do'5cb = compileRegex "\\bexit do\\b"
regex_'5cbdo'5cb = compileRegex "\\bdo\\b"
regex_'5cbloop'5cb = compileRegex "\\bloop\\b"
regex_'5cbexit_while'5cb = compileRegex "\\bexit while\\b"
regex_'5cbwhile'5cb = compileRegex "\\bwhile\\b"
regex_'5cbwend'5cb = compileRegex "\\bwend\\b"
regex_'5cbexit_for'5cb = compileRegex "\\bexit for\\b"
regex_'5cbfor'5cb = compileRegex "\\bfor\\b"
regex_'5cbnext'5cb = compileRegex "\\bnext\\b"
regex_'5cbselect_case'5cb = compileRegex "\\bselect case\\b"
regex_'5cbend_select'5cb = compileRegex "\\bend select\\b"
regex_'5c'5c'5b0'2d7'5d'7b1'2c3'7d = compileRegex "\\\\[0-7]{1,3}"
regex_'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b1'2c2'7d = compileRegex "\\\\x[0-9A-Fa-f]{1,2}"
regex_'5cs'2a'3d'5cs'2a = compileRegex "\\s*=\\s*"
regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a = compileRegex "\\s*#?[a-zA-Z0-9]*"

defaultAttributes = [("nosource","Normal Text"),("aspsource","ASP Text"),("asp_onelinecomment","Comment"),("doublequotestring","String"),("singlequotestring","String"),("htmltag","Identifier"),("htmlcomment","HTML Comment"),("identifiers","Identifier"),("types1","Types"),("types2","Types"),("scripts","Normal Text"),("scripts_onelinecomment","Comment"),("twolinecomment","Comment")]

parseRules "nosource" = 
  do (attr, result) <- (((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2ascript'5cs'2alanguage'3d'22VBScript'22'5b'5e'3e'5d'2a'3e >>= withAttribute "HTML Tag") >>~ pushContext "aspsource")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2ascript'28'5cs'7c'3e'29 >>= withAttribute "HTML Tag") >>~ pushContext "scripts")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'3f'5cs'2a'5ba'2dzA'2dZ'5f'3a'5d'5ba'2dzA'2dZ0'2d9'2e'5f'3a'2d'5d'2a >>= withAttribute "HTML Tag") >>~ pushContext "htmltag")
                        <|>
                        ((pString False "<!--" >>= withAttribute "HTML Comment") >>~ pushContext "htmlcomment"))
     return (attr, result)

parseRules "aspsource" = 
  do (attr, result) <- (((pString False "%>" >>= withAttribute "Keyword") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'5cs'2ascript'5cs'2a'3e >>= withAttribute "HTML Tag") >>~ (popContext))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Comment") >>~ pushContext "asp_onelinecomment")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "doublequotestring")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "singlequotestring")
                        <|>
                        ((pDetectChar False '&' >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_ >>= withAttribute "String"))
                        <|>
                        ((pRegExpr regex_'5b0123456789'5d'2a'5c'2e'5c'2e'5c'2e'5b0123456789'5d'2a >>= withAttribute "String"))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pInt >>= withAttribute "Decimal"))
                        <|>
                        ((pAnyChar ";()}{:,[]" >>= withAttribute "Other"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" Set.empty >>= withAttribute "Other"))
                        <|>
                        ((pRegExpr regex_'5cbelseif'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbelse'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbif'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbend_if'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbexit_function'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbfunction'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbend_function'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbexit_sub'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbsub'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbend_sub'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbclass'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbend_class'5cb >>= withAttribute "Keyword"))
                        <|>
                        ((pRegExpr regex_'5cbexit_do'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbdo'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbloop'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbexit_while'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbwhile'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbwend'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbexit_for'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbfor'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbnext'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbselect_case'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pRegExpr regex_'5cbend_select'5cb >>= withAttribute "Control Structures"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_control_structures >>= withAttribute "Control Structures"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute "Function")))
     return (attr, result)

parseRules "asp_onelinecomment" = 
  do (attr, result) <- ((pString False "%>" >>= withAttribute "Keyword") >>~ (popContext >> popContext))
     return (attr, result)

parseRules "doublequotestring" = 
  do (attr, result) <- (((pDetect2Chars False '"' '"' >>= withAttribute "Escape Code"))
                        <|>
                        ((pRegExpr regex_'5c'5c'5b0'2d7'5d'7b1'2c3'7d >>= withAttribute "Escape Code"))
                        <|>
                        ((pRegExpr regex_'5c'5cx'5b0'2d9A'2dFa'2df'5d'7b1'2c2'7d >>= withAttribute "Escape Code"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "singlequotestring" = 
  do (attr, result) <- (((pDetect2Chars False '\'' '\'' >>= withAttribute "Escape Code"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "htmltag" = 
  do (attr, result) <- (((pDetect2Chars False '/' '>' >>= withAttribute "HTML Tag") >>~ (popContext))
                        <|>
                        ((pDetectChar False '>' >>= withAttribute "HTML Tag") >>~ (popContext))
                        <|>
                        ((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute "Identifier") >>~ pushContext "identifiers"))
     return (attr, result)

parseRules "htmlcomment" = 
  do (attr, result) <- (((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pString False "-->" >>= withAttribute "HTML Comment") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5cs'2a'3d'5cs'2a >>= withAttribute "Normal Text") >>~ pushContext "identifiers"))
     return (attr, result)

parseRules "identifiers" = 
  do (attr, result) <- (((pRegExpr regex_'5cs'2a'23'3f'5ba'2dzA'2dZ0'2d9'5d'2a >>= withAttribute "String") >>~ (popContext))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Types") >>~ pushContext "types1")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Types") >>~ pushContext "types2"))
     return (attr, result)

parseRules "types1" = 
  do (attr, result) <- (((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "Types") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "types2" = 
  do (attr, result) <- (((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "Types") >>~ (popContext >> popContext)))
     return (attr, result)

parseRules "scripts" = 
  do (attr, result) <- (((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "scripts_onelinecomment")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "twolinecomment")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_control_structures >>= withAttribute "Control Structures"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_functions >>= withAttribute "Function"))
                        <|>
                        ((pString False "<%" >>= withAttribute "Keyword") >>~ pushContext "aspsource")
                        <|>
                        ((pRegExpr regex_'3c'5cs'2a'5c'2f'5cs'2ascript'5cs'2a'3e >>= withAttribute "HTML Tag") >>~ (popContext))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "doublequotestring")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "singlequotestring")
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pInt >>= withAttribute "Decimal"))
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Normal Text"))
                        <|>
                        ((pAnyChar ";()}{:,[]" >>= withAttribute "Other"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" Set.empty >>= withAttribute "Other")))
     return (attr, result)

parseRules "scripts_onelinecomment" = 
  do (attr, result) <- ((pRegExpr regex_'3c'5cs'2a'5c'2f'5cs'2ascript'5cs'2a'3e >>= withAttribute "HTML Tag") >>~ (popContext >> popContext))
     return (attr, result)

parseRules "twolinecomment" = 
  do (attr, result) <- ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
