-- |
-- Module:     FRP.NetWire.Pure
-- Copyright:  (c) 2011 Ertugrul Soeylemez
-- License:    BSD3
-- Maintainer: Ertugrul Soeylemez <es@ertes.de>
--
-- Pure wire sessions.

module FRP.NetWire.Pure
    ( -- * Pure sessions
      stepSF,
      stepWirePure
    )
    where

import Data.Functor.Identity
import FRP.NetWire.Wire


-- | Perform the next instant of a pure wire over the identity monad.

stepSF :: Time -> a -> SF a b -> (Output b, SF a b)
stepSF dt x' = runIdentity . stepWirePure dt x'


-- | Perform the next instant of a pure wire.

stepWirePure :: Monad m => Time -> a -> Wire m a b -> m (Output b, Wire m a b)
stepWirePure dt x' w' = toGen w' (PureState dt) x'
