module Tests.LegacyTests
    ( legacyTests
    ) where

import Codec.Archive.LibZip.LegacyZeroZero

import Tests.Common

import qualified Data.ByteString as B
import Test.HUnit

legacyTests = TestList
  [ "read list of files" ~: do
      files <- withZip testzip [] $ \z -> getFiles z [] :: IO [String]
      files @?= testfiles
  , "read file size" ~: do
      sz <- withZip testzip [] $ \z -> getFileSize z lastfile []
      sz @?= lastfilesize
  , "case-insensitive file names" ~: do
    sz <- withZip testzip [] $ \z ->
          getFileSize z (map2 toUpper toLower $ lastfile) [FileNOCASE]
    sz @?= lastfilesize
  , "open error if exists (with ExclFlag)" ~: do
    err <- catchZipError
            (withZip testzip [ExclFlag] $ \_ -> return ErrOK)
            (return . id)
    err @?= ErrEXISTS
  , "read file" ~: do
    txt <- withZip testzip [] $ \z -> readZipFile z lastfile []
    txt @?= toByteString world_txt
  , "open file by index" ~: do
    txt <- withZip testzip [] $ \z -> do
        f <- fopen_index z 1 [] -- index 0 is of the parent dir
        bytes <- fread f (length world_txt)
        return $ B.pack bytes
    txt @?= toByteString world_txt
  ]


toByteString :: String -> B.ByteString
toByteString s = B.pack $ map (fromIntegral . fromEnum) s

