// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************

#include <QObject>  //lint !e537 Repeated include
#include <QThread>

#ifndef __DEVICE_H__
   #include "device.h"
#endif

#ifndef __COMMON_H__
   #include "common.h"
#endif

class t_ThreadScanWorker: public QObject
{
   Q_OBJECT

   public slots:
      virtual void SlotRescan (void) = 0;

   signals:
      void SignalScanFinished (t_pDeviceList);
      void SignalScanStarted  (void)         ;
};

class t_ThreadScanWorkerPartedLocal;
class t_ThreadScanWorkerParted: public t_ThreadScanWorker
{
   Q_OBJECT

   public:
      t_ThreadScanWorkerParted (APIRET &rc);
     ~t_ThreadScanWorkerParted (void);

   public slots:
      void SlotRescan (void);

   private:
      t_ThreadScanWorkerPartedLocal *pOwn;
};


class t_ThreadScanWorkerHALLocal;
class t_ThreadScanWorkerHAL: public t_ThreadScanWorker
{
   Q_OBJECT

   public:
      t_ThreadScanWorkerHAL (APIRET &rc);
     ~t_ThreadScanWorkerHAL (void);

   private:
      QList<QVariant> CallMethod        (const QString &Device, const QString &Method, const QString &Argument);
      QVariant        CallMethodSingle  (const QString &Device, const QString &Method, const QString &Argument);
      APIRET          GetProperty       (const QString &Device, const QString &Property, QList<QVariant> &VarList);
      APIRET          GetPropertySingle (const QString &Device, const QString &Property, QVariant        &Var    );
      bool            PropertyContains  (const QString &Device, const QString &Property, const QString   &Str    );

   public slots:
      void SlotRescan (void);

   private:
      t_ThreadScanWorkerHALLocal *pOwn;
};


class t_ThreadScan: public QThread
{
   public:
      t_ThreadScan (void);
      APIRET Start (t_ThreadScanWorker **ppWorker);  // Return ptr to worker, so calling fn may emit signals to it
      APIRET Stop  ();

   protected:
      void run (void);

   private:
      t_ThreadScanWorker **ppoWorker;
      APIRET                 oWorkerRc;
};

enum
{
   ERROR_THREADSCAN_NOT_STARTED = ERROR_BASE_THREADSCAN,
   ERROR_THREADSCAN_NOT_STOPPED,
   ERROR_THREADSCAN_EXITCODE_NONZERO,
   ERROR_THREADSCAN_PROCESS_NOTSTARTED,
   ERROR_THREADSCAN_PROCESS_NOTFINISHED,
   ERROR_THREADSCAN_DBUSHAL_NOTWORKING,
   ERROR_THREADSCAN_LIBPARTED_NOTWORKING,
   ERROR_THREADSCAN_PROPERTY_NONEXISTENT,
   ERROR_THREADSCAN_CALLED_FROM_WRONG_THREAD
};

