#ifndef INCLUDE_GTKPBINIT_H
#define INCLUDE_GTKPBINIT_H
/* ----------------------------------------------------------------------------
 * gtkpbinit.h
 * prototypes and definitions for gtkpbinit.c.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <signal.h>
#include <gtk/gtk.h>
#include "audio.h"
#include "themes.h"

/* temporary structure to hold command line arguments extracted
 * by libpopt. This arguments will be checked, filtered and if
 * everything is all right copied to their final location in
 * evaluate_args(). This mechanism is always the same if GNOME is
 * used or not.
 */
struct poptArgs {
	char *audiodev;
	char *theme;
	char *pidfile;
	int  detach;
	int  version;
};
	
#define DEFAULT_PIDFILE "/var/run/" PACKAGE ".pid"
#define DEFAULT_THEME "Classic"

struct init {
	char *themename;		/* name of theme to use */
	struct theme *themedata;
	GtkWidget *window;
	struct dspdata dsp;		/* data for sound player */
	int timeout;			/* timeout value for closing popup windows */
	int argc;               /* copy of command line arguments */
	char **argv;
};

/* prototypes */
int prg_init(struct init *md);
void signalhandler (int signum);
int install_sighandler();
int evaluate_args(struct init *md, struct poptArgs *args);
void init_init(struct init *md, int argc, char *argv[]);
int check_path (char *source, int type);

#endif    /* INCLUDE_GTKPBINIT_H */
