/* gtask-test.vala
 *
 * Copyright (C) 2008 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __TEST_4_H__
#define __TEST_4_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define G_TYPE_TEST_GTASK (g_test_gtask_get_type ())
#define G_TEST_GTASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_TEST_GTASK, GTestGTask))
#define G_TEST_GTASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), G_TYPE_TEST_GTASK, GTestGTaskClass))
#define G_IS_TEST_GTASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_TEST_GTASK))
#define G_IS_TEST_GTASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G_TYPE_TEST_GTASK))
#define G_TEST_GTASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), G_TYPE_TEST_GTASK, GTestGTaskClass))

typedef struct _GTestGTask GTestGTask;
typedef struct _GTestGTaskClass GTestGTaskClass;
typedef struct _GTestGTaskPrivate GTestGTaskPrivate;

struct _GTestGTask {
	GObject parent_instance;
	GTestGTaskPrivate * priv;
};

struct _GTestGTaskClass {
	GObjectClass parent_class;
};


void g_test_gtask_main (char** args, int args_length1);
void g_test_gtask_test_vala1 (void);
void g_test_gtask_run (GTestGTask* self);
GTestGTask* g_test_gtask_construct (GType object_type);
GTestGTask* g_test_gtask_new (void);
GType g_test_gtask_get_type (void);


G_END_DECLS

#endif
