//*****************************************************************************
//                                Version.hpp                                 *
//                               -------------                                *
// Description : Version specifier for the GNU Spice GUI application.         *
// Started     : 15/08/2003                                                   *
// Last Update : Refer below                                                  *
// Copyright   : (C) 2003 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef VERSION_HPP
#define VERSION_HPP

#define  APP_NAME     wxT("GNU Spice GUI")
#define  APP_VERSION  wxT("Version 0.9.65 Alpha (29/02/2008)")

#endif // VERSION_HPP

//*****************************************************************************
// THINGS TO DO:
//
// (18/10/2004) The Simulation class is evil. It needs a major re-think to make
//              it easier to understand and maintain.
// (21/04/2005) Could an existing opamp symbols used in schematics instead of
//              my opamp-3.sym?
// (31/01/2006) While performing a simulation if the gSpiceUI GUI is corrupted
//              it isn't re-drawn until after the simulation is complete. Need
//              wxYield statements in appropriate places to allow the GUI to be
//              updated.
// (10/10/2007) Convert NG-Spice phase results from radians to degrees. Refer
//              to section 10.5 Variables -> "units". The SET command doesn't
//              seem to work in batch mode.
// (10/10/2007) In NG-Spice the variable "numdgt" could be useful for setting
//              displayed precision. Refer to section 10.5 Variables.
// (26/09/2007) Add global settings for the units of angle and the displayed
//              precision in tables of data.
// (07/06/2007) If a current source is chosen the source setup dialogs displays
//              units of Volts.
// (19/06/2007) In FrmMain the run simulation mechanism is evil. It needs a
//              major overhaul. The Stop button doesn't work because the app.
//              stays in the OnSimRun( ) event handler while the simulation
//              runs so no other events are handled until this is exited.
// (17/07/2007) The transient analysis IC option isn't loaded correctly from
//              the simulation file for NG-Spice.
// (24/08/2007) Change the simulation engine a few times and the layout of the
//              main frame can get corrupted. Maximize then window gSpiceUI and
//              things are almost back to normal. Alot less corruption occurs
//              with wxWidgets v2.8.4. Using wxWidgets v2.8.5, changed the
//              simulation engine 4 time and got a segmentation fault. Seems to
//              behave better with wxWidgets 2.8.7 but not yet perfect.
// (28/08/2007) When a simulation is ends prematurely because of problems in
//              the simulator notify the user that this has happened. Need a
//              mechanism to determining if the end of the sweep range was
//              actually reached.
// (18/10/2007) Makefile.deps contains duplicate dependencies; this is benign
//              but none the less annoying.
// (25/10/2007) For NG-Spice simulations if R1 and C1 are connected in parallel
//              and R1 is selected as a test component after a reload operation
//              both R1 and C1 will be highlighted as test components.
// (19/02/2008) If gspiceui is exited with gschem open, any unsaved changes in
//              the schematic file are lost.
//*****************************************************************************
// GNU-Cap :
//
// (29/03/2004) The PRINT command doesn't produce a label for the independent
//              parameter ie. temperature or OP, voltage for DC.
// (20/04/2005) In the AC analysis the following source line is not interpreted
//              correctly: "Vin 2 3 GENERATOR(1) AC 100.00m". The AC magnitude
//              "100.00m" is not interpreted as "0.1"; replace it with "0.1"
//              and everything works OK.
// (21/04/2005) At times the first result line from a DC analysis is clearly
//              incorrect.
//*****************************************************************************
// NG-Spice :
//
// (11/05/2007) PRINT statement parser is broken. Eg. PRINT TRAN V(0,1) V(0,2)
//              is interpreted as one parameter -V(1)-V(2) instead of two; in
//              contrast PRINT TRAN V(1,0) V(2,0) is interpreted correctly. In
//              addition eg. PRINT AC VDB(0,1) wont run at all.
//              Notes : The .PRINT statement parsing starts in fixem( char * )
//                      (src/frontend/dotcards.c) which calls gettoks( char * )
//                      which calls gettok( char ** ) (../src/misc/string.c).
//                      I think the bug is in gettok( char ** ) or how it is
//                      used by gettoks( char * ).
//*****************************************************************************
// GWave :
//
// (29/03/2004) GWave can't handle the banner that Gnu-CAP includes in it's
//              output.
//*****************************************************************************
// GNetList :
//
// (12/04/2005) When schem. file imported via command line "gnetlist.log" left
//              in gspiceui bin directory. When schem. file imported via GUI
//              "gnetlist.log" left in schematic directory.
// (19/07/2005) If a relative model file path specified in schematic file the
//              path is regarded as relative to the CWD not the schematic file
//              path which would be more logical.
//*****************************************************************************
// wxWidgets Library Bugs :
//
// (17/11/2003) v2.4.1 : In class wxFileDialog wildcards can only be set in the
//                       constructor. The method SetWildcard( ) is not properly
//                       implemented. See constructor in src/generic/filedlgg.cpp
//                       and set method in include/wx/generic/filedlgg.h.
// (13/08/2004) v2.4.2 : In class wxFileDialog styles can only be set in the
//                       constructor. The method SetStyle( ) does notthing.
// (04/02/2004) v2.8.3 : The class wxFileName has an undocumented function
//                       SetPath( ).
// (19/02/2004) v2.4.2 : In the class wxSpinCtrl when using SetValue( (int) 0 )
//                       for initialization the spin control is left blank.
// (21/02/2004) v2.4.2 : In the class wxTextFile function IsOpened( ) returns
//                       TRUE after Open( ) but FALSE after Create( ).
// (18/09/2004) v2.5.2 : In the class wxTextCtrl style setting wxTE_RIGHT is
//                       ignored in Create( ) function.
// (01/10/2004) v2.5.2 : No mention of wxControl constructor in documentation.
// (06/04/2005) v2.5.2 : When the wxFrame is resized wxStatusBar isn't.
// (12/04/2005) v2.5.4 : "make uninstall" does nothing.
// (28/05/2007) v2.8.3 : In the class PnlValue class and function DoLayout( )
//                       wxWidgets ignores the request to vertically align the
//                       StaticText object.
// (07/09/2007) v2.8.5 : Cannot set the font in the choice control in the
//                       PnlValue class when no file loaded at startup. It
//                       should inherit the font from it's parent; every other
//                       control does. This seems to be bug in wxWidgets v2.8.5
//                       and v2.6.3.
//*****************************************************************************
