# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Gscan2pdf.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 1;
BEGIN {
  use Gscan2pdf;
  use Gscan2pdf::Document;
  use PDF::API2;
};

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

# Thumbnail dimensions
our $widtht  = 100;
our $heightt = 100;

use Log::Log4perl qw(:easy);
Log::Log4perl->easy_init($DEBUG);
our $logger = Log::Log4perl::get_logger;
my $prog_name = 'gscan2pdf';
use Locale::gettext 1.05;    # For translations
our $d = Locale::gettext->domain($prog_name);
Gscan2pdf->setup($d, $logger);

# Create test image
system('convert rose: test.pnm');

my $slist = Gscan2pdf::Document->new;
$slist->get_file_info( 'test.pnm', undef, undef, undef, sub {
 my ($info) = @_;
 $slist->import_file( $info, 1, 1, undef, undef, undef, sub {
  $slist->{data}[0][2]{hocr} = <<EOS;
<!DOCTYPE html
 PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN
 http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
 <head>
  <meta content="ocr_line ocr_page" name="ocr-capabilities"/>
  <meta content="en" name="ocr-langs"/>
  <meta content="Latn" name="ocr-scripts"/>
  <meta content="" name="ocr-microformats"/>
  <title>OCR Output</title>
 </head>
 <body>
  <div class="ocr_page" title="bbox 0 0 70 46>
   <p class="ocr_par">
    <span class=\"ocr_line\" title=\"bbox 10 10 60 11\">The quick brown fox</span>
   </p>
  </div>
 </body>
</html>
EOS
  $slist->save_pdf('test.pdf', [ $slist->{data}[0][2] ], undef, undef, undef, undef, undef, sub {Gtk2->main_quit});
 })
});
Gtk2->main;

like( `pdftotext test.pdf -`, qr/The quick brown fox/, 'PDF with expected text' );

#########################

unlink 'test.pnm', 'test.pdf';
Gscan2pdf->quit();
