/*
 * gather.c		- gather and report process info.
 *
 * Michael Hamilton (michael@actrix.gen.nz).
 * Copyright (c) 1995
 *
 * Snarfed and HEAVILY modified from top in process ps
 * by Branko Lankester and Roger Binns.
 *
 */


#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <time.h>
#include <sys/ioctl.h>
#include <pwd.h>
#ifdef USE_OBSOLETE
#include <linux/sched.h>
#endif
#include <linux/tty.h>
#include <termcap.h>
#include <termios.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <ctype.h>
#include <setjmp.h>
#include <stdarg.h>

#include "ps.h"
#include "sysinfo.h"
#include "readproc.h"
#include "whattime.h"
#include "signals.h"

#define MAX_HEIGHT 100.0

static unsigned **memory_info = NULL;

void show_process(proc_t *info, char *sort_id, double up_seconds, time_t now)
{
  int pid;
  double cpu_utilisation;	/* cpu_time / total_time */
  double memory_utilisation;
  double resident;
  double total_time;		/* elapsed_time / system_uptime */
  double cpu_ticks;
  double elapsed_ticks;
  double used;
  char id[50];

  if (!info) {
    return ;
  }
  
  cpu_ticks = (info->utime + info->stime) ;
  
  /* Start_time is in herz from boot time - dispite what any other comment says. */

				/* Percent of uptime of a processes existance. */
  elapsed_ticks = up_seconds * HZ - info->start_time;

  total_time = MAX_HEIGHT * (elapsed_ticks / (double) HZ) / up_seconds; 

  cpu_utilisation = MAX_HEIGHT * cpu_ticks / elapsed_ticks ;

  used = memory_info[meminfo_main][meminfo_used] + memory_info[meminfo_swap][meminfo_used];

  //fprintf(stderr, "s=%d r=%d u=%lf\n",  info->vsize, info->rss, used );

  memory_utilisation = 
    MAX_HEIGHT * (double) info->vsize / used;

  resident = 
    MAX_HEIGHT * (double) info->rss * 4096 / used ;


  if (strcmp(sort_id, info->user) != 0) {
    if (*sort_id != '\0') {
      printf("  </group>\n");
    }
    printf("  <group id=\"%s\">\n", info->user);
    strcpy(sort_id, info->user);
  }
  
  printf("   <item id=\"%d\">\n", info->pid);
  printf("    <cpu  data=\"%f\"/>\n", cpu_utilisation);
  printf("    <rss  data=\"%f\"/>\n", resident);
  printf("    <mem  data=\"%f\"/>\n", memory_utilisation);
  printf("    <time data=\"%f\"/>\n", total_time);
  printf("   </item>\n");
}


/*#####################################################################
 *#######   A readproctable function that uses already allocated  #####
 *#######   table entries.                                        #####
 *#####################################################################
 */
#define Do(x) (flags & PROC_ ## x)

proc_t** readproctab2(int flags, proc_t** tab, ...) {
    PROCTAB* PT = NULL;
    static proc_t *buff;
    int n = 0;
    static int len = 0;
    va_list ap;

    va_start(ap, tab);		/* pass through args to openproc */
    if (Do(UID)) {
	/* temporary variables to ensure that va_arg() instances
	 * are called in the right order
	 */
	uid_t* u;
	int i;

	u = va_arg(ap, uid_t*);
	i = va_arg(ap, int);
	PT = openproc(flags, u, i);
    }
    else if (Do(PID) || Do(TTY) || Do(STAT))
	PT = openproc(flags, va_arg(ap, void*)); /* assume ptr sizes same */
    else
	PT = openproc(flags);
    va_end(ap);
    buff = (proc_t *) 1;
    while (n<len && buff) {     /* read table: (i) already allocated chunks */
	if (tab[n]->cmdline) {
	    free((void*)*tab[n]->cmdline);
	    tab[n]->cmdline = NULL;
	}
        buff = readproc(PT, tab[n]);
	if (buff) n++;
    }
    if (buff) {
	do {               /* (ii) not yet allocated chunks */
	    tab = xrealloc(tab, (n+1)*sizeof(proc_t*));/* realloc as we go, using */
	    buff = readproc(PT, NULL);		  /* final null to terminate */
	    if(buff) tab[n]=buff;
	    len++;
	    n++;
	} while (buff);			  /* stop when NULL reached */
	tab[n-1] = xcalloc(NULL, sizeof (proc_t));
	tab[n-1]->pid=-1;		 /* Mark end of Table */
    } else {
	if (n == len) {
	    tab = xrealloc(tab, (n+1)*sizeof(proc_t*));
	    tab[n] = xcalloc(NULL, sizeof (proc_t));
	    tab[n]->cmdline = NULL;
	    len++;
	}
	tab[n]->pid=-1;    /* Use this instead of NULL when not at the end of */
    }                   /* the allocated space */
    closeproc(PT);
    return tab;
}

static int compareItems(const void *arg1, const void *arg2)
{
  const proc_t **item1 = (const proc_t **) arg1;
  const proc_t **item2 = (const proc_t **) arg2;
  int result;
  if ((result = strcmp((*item1)->user, (*item2)->user)) != 0) {
    if (strcmp((*item1)->user, "root") == 0) {
      return 1;
    }
    else if (strcmp((*item2)->user, "root") == 0) {
      return -1;
    }
    else if (strcmp((*item1)->user, "daemon") == 0) {
      return 1;
    }
    else if (strcmp((*item2)->user, "daemon") == 0) {
      return -1;
    }
    else if (strcmp((*item1)->user, "bin") == 0) {
      return 1;
    }
    else if (strcmp((*item2)->user, "bin") == 0) {
      return -1;
    }
    return result;
  }
  return (*item1)->pid - (*item2)->pid;
}

void show_all_processes ()
{
  double up ;
  double idle ;

  time_t now;

  char host[200] ;
  char sort_id[100] = "";

  int count, i;

  static proc_t **p_table = NULL;
  const int proc_flags=PROC_FILLMEM|PROC_FILLCMD|PROC_FILLTTY|PROC_FILLUSR;

  

  uptime(&up, &idle) ;

  p_table = readproctab2(proc_flags, p_table, NULL);

  for (count = 0; p_table[count]->pid != -1; count++) {} ;

  if (count == 0) {
    fprintf(stderr, "No processes available\n");
    sleep(1);
  }
  else {
    gethostname(host, 79);
    now = time(NULL);
    printf(" <dataset id=\"%s %s\">\n", host, ctime(&now));
    for (i = 0;  i < count ; ++i) {
      qsort((void *) (p_table), count, sizeof(proc_t *), &compareItems);
      show_process(p_table[i], sort_id, up, now) ;
    }
    if (*sort_id != '\0') {
      printf("  </group>\n");
    }
    printf(" </dataset>\n");
  }
  /*freeproctab(p_table);*/
}

void usage(void) 
{
  printf("Usage: gather [-sleep n]\n");
}

int
main(int argc, char **argv)
{
  /* loop, collecting process info and sleeping */
  
  int i, seconds = 2;    

  for (i = 1; i < argc; ++i) {

    if (!strcmp("-sleep", argv[i])) {
      seconds = strtol(argv[++i],NULL,0);

    } else {
      usage();
    }
  }

  setvbuf(stdout,NULL,_IONBF,0);

  memory_info = meminfo();

  printf("<?xml version=\"1.0\"?>\n<!DOCTYPE datastream [\n"
	 "<!ELEMENT datastream (dataset)*>\n"
	 "<!ELEMENT dataset (group)*>\n"
	 "<!ATTLIST dataset\n"
	 "	id	CDATA	#REQUIRED>\n"
	 "<!ELEMENT group (item)*>\n"
	 "<!ATTLIST group\n"
	 "	id	CDATA	#REQUIRED>\n"
	 "<!ELEMENT item (cpu, workingset, memory)>\n"
	 "<!ATTLIST item\n"
	 "	id	CDATA	#REQUIRED>\n"
	 "<!ELEMENT cpu EMPTY>\n"
	 "<!ATTLIST cpu\n"
	 "	data	CDATA	#REQUIRED>\n"
	 "<!ELEMENT workingset EMPTY>\n"
	 "<!ATTLIST workingset\n"
	 "	data	CDATA	#REQUIRED>\n"
	 "<!ELEMENT memory EMPTY>\n"
	 "<!ATTLIST memory\n"
	 "	data	CDATA	#REQUIRED>\n"
	 "]>\n");

  printf("<datastream>\n");
  for (;;) {
    show_all_processes() ;
    sleep(seconds) ;
  }
  printf("</datastream>\n");
}



