/*
 * Grace - GRaphing, Advanced Computation and Exploration of data
 * 
 * Home page: http://plasma-gate.weizmann.ac.il/Grace/
 * 
 * Copyright (c) 1991-1995 Paul J Turner, Portland, OR
 * Copyright (c) 1996-2003 Grace Development Team
 * 
 * Maintained by Evgeny Stambulchik
 * 
 * 
 *                           All Rights Reserved
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __BITMAPS_H_
#define __BITMAPS_H_

static char * grace_icon_xpm[] = {
"48 39 6 1",
" 	c #000000000000",
".	c #FFFFFFFFFFFF",
"X	c #BEFBBEFBBEFB",
"o	c #51445144FFFF",
"O	c #FFFF14514103",
"+	c #0000AAAA1861",
"                                                ",
" .............................................. ",
" .............................................. ",
" ...............                  ............. ",
" .............................................. ",
" .................              ............... ",
" .............................................. ",
" .......                                 ...... ",
" ....... XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ...... ",
" ....... XXXXXXXXXXXXXXXXXXXXXXXXXXoXXXX ...... ",
" ..... . XXoooXX      XXXXXXXXXXXoooXXXX ...... ",
" .. .... XXXXXXXXXXXXXXXXXXXXXXXXoXooOXX ...... ",
" .. .... XXOOOXX     XXXXXXXXXXXXoXOoXXX ...... ",
" .. .... XXXXXXXXXXXXXXXXXXXXXXXoOOXooXX ...... ",
" .. .... XX+++XX     XXXXooXXXXOoXXXXoXX ...... ",
" .. .. . XXXXXXXXXXXXXXXoXoXXXOoXXXXXXXX ...... ",
" .. .... XXXXXXXXXXXXXXXoXoXOOooXXXXXXXX ...... ",
" .. .... XXXXXXXXXXXXXXoXXooXXoXXXXXXXXX ...... ",
" .. .... XXXXXXXoXXXXXooXOOoXoXXXXXXXXXX ...... ",
" .. .... XXXXXXooXXXXXoOOXXooXXXXXXXXXXX ...... ",
" .. .. . XXXXXXoXoXXXoOXXXXXXXXXXXXXXXXX ...... ",
" .. .... XXXXXooXoXXOoXXXXXXXXXXXXXXXXXX ...... ",
" .. .... XXXXooXXooOooXXXXXXXXXXXXXXXXXX ...... ",
" .. .... XXXXoXXOOoXoXXXXXXXXXX+++++XXXX ...... ",
" .. .... XXXXoXOXXoXoXXXXXXXXXX+++++XXXX ...... ",
" .. .. . XXXooOXXXXoXXXX+++++XX+++++XXXX ...... ",
" .. .... XXOoXXXXXXXXXXX+++++XX+++++XXXX ...... ",
" .. .... XOoXXXXX+++++XX+++++XX+++++XXXX ...... ",
" .. .... XXoXXXXX+++++XX+++++XX+++++XXXX ...... ",
" ....... XooXXXXX+++++XX+++++XX+++++XXXX ...... ",
" ..... . XXXXXXXX+++++XX+++++XX+++++XXXX ...... ",
" .......                                 ...... ",
" .............................................. ",
" ........ .... .... .... .... .... .... ....... ",
" .............................................. ",
" ..............                    ............ ",
" .............................................. ",
" .............................................. ",
"                                                "};

#define redraw_width 16
#define redraw_height 16
static unsigned char redraw_bits[] = {
   0x00, 0x3e, 0x00, 0x1f, 0x80, 0x8f, 0xc0, 0xc7, 0xe0, 0xe3, 0xa0, 0xf1,
   0x10, 0xf8, 0x10, 0x7c, 0x08, 0x3c, 0x08, 0x18, 0x0c, 0x0c, 0x1c, 0x03,
   0xfe, 0x00, 0x3e, 0x00, 0x0f, 0x00, 0x03, 0x00};
#define auto_width 16
#define auto_height 16
static unsigned char auto_bits[] = {
   0x00, 0x00, 0x08, 0x0c, 0x1c, 0x0c, 0x3e, 0x1e, 0x08, 0x1e, 0x08, 0x33,
   0x08, 0x3f, 0x88, 0x61, 0x88, 0x61, 0x3e, 0x00, 0x5c, 0x10, 0x68, 0x30,
   0xf0, 0x7f, 0x60, 0x30, 0x40, 0x10, 0x00, 0x00};
#define auto_x_width 16
#define auto_x_height 16
static unsigned char auto_x_bits[] = {
   0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0xc0, 0x03, 0x60, 0x06,
   0xe0, 0x07, 0x30, 0x0c, 0x30, 0x0c, 0x00, 0x00, 0x08, 0x10, 0x0c, 0x30,
   0xfe, 0x7f, 0x0c, 0x30, 0x08, 0x10, 0x00, 0x00};
#define auto_y_width 16
#define auto_y_height 16
static unsigned char auto_y_bits[] = {
   0x00, 0x00, 0x08, 0x00, 0x1c, 0x00, 0x3e, 0x00, 0x08, 0x0c, 0x08, 0x0c,
   0x08, 0x1e, 0x08, 0x1e, 0x08, 0x33, 0x08, 0x3f, 0x88, 0x61, 0x88, 0x61,
   0x3e, 0x00, 0x1c, 0x00, 0x08, 0x00, 0x00, 0x00};
#define auto_tick_width 16
#define auto_tick_height 16
static unsigned char auto_tick_bits[] = {
   0x00, 0x00, 0x08, 0x0c, 0x3e, 0x0c, 0x08, 0x1e, 0x08, 0x1e, 0x08, 0x33,
   0x08, 0x3f, 0x9c, 0x61, 0x88, 0x61, 0x08, 0x00, 0x08, 0x20, 0x08, 0x21,
   0xfe, 0x7f, 0x08, 0x21, 0x08, 0x20, 0x00, 0x00};
#define left_width 16
#define left_height 16
static unsigned char left_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x38, 0x00, 0xfe, 0x7f,
   0x38, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
   0x21, 0x84, 0x21, 0x84, 0x00, 0x00, 0x00, 0x00};
#define right_width 16
#define right_height 16
static unsigned char right_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x1c, 0xfe, 0x7f,
   0x00, 0x1c, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
   0x21, 0x84, 0x21, 0x84, 0x00, 0x00, 0x00, 0x00};
#define up_width 16
#define up_height 16
static unsigned char up_bits[] = {
   0x1c, 0x00, 0x10, 0x04, 0x10, 0x04, 0x10, 0x0e, 0x10, 0x0e, 0x1c, 0x1f,
   0x10, 0x15, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x1c, 0x04, 0x10, 0x04,
   0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x1c, 0x00};
#define down_width 16
#define down_height 16
static unsigned char down_bits[] = {
   0x1c, 0x00, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x1c, 0x04,
   0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x15, 0x1c, 0x1f, 0x10, 0x0e,
   0x10, 0x0e, 0x10, 0x04, 0x10, 0x04, 0x1c, 0x00};
#define expand_width 16
#define expand_height 16
static unsigned char expand_bits[] = {
   0xfe, 0xff, 0x82, 0x83, 0xc2, 0x87, 0x02, 0x81, 0x02, 0x81, 0x4a, 0xa5,
   0x0e, 0xe1, 0xfe, 0xff, 0x0e, 0xe1, 0x4a, 0xa5, 0x02, 0x81, 0x02, 0x81,
   0xc2, 0x87, 0x82, 0x83, 0xfe, 0xff, 0x00, 0x00};
#define shrink_width 16
#define shrink_height 16
static unsigned char shrink_bits[] = {
   0x54, 0x55, 0x02, 0x81, 0xc0, 0x07, 0x82, 0x83, 0x00, 0x01, 0xca, 0xa7,
   0x58, 0x34, 0x7e, 0xfc, 0x58, 0x34, 0xca, 0xa7, 0x00, 0x01, 0x82, 0x83,
   0xc0, 0x07, 0x02, 0x81, 0x54, 0x55, 0x00, 0x00};
#define zoom_width 16
#define zoom_height 16
static unsigned char zoom_bits[] = {
   0x00, 0x00, 0x70, 0x00, 0xd8, 0x00, 0x8c, 0x01, 0x06, 0x03, 0x02, 0x02,
   0x06, 0x03, 0x8c, 0x01, 0xd8, 0x03, 0x70, 0x07, 0x00, 0x0e, 0x00, 0x1c,
   0x00, 0x38, 0x00, 0x70, 0x00, 0x60, 0x00, 0x00};
#define zoom_x_width 16
#define zoom_x_height 16
static unsigned char zoom_x_bits[] = {
   0x00, 0x00, 0x70, 0x00, 0xd8, 0x00, 0x8c, 0x01, 0x06, 0x03, 0x02, 0x02,
   0x06, 0x03, 0x8c, 0x01, 0xd8, 0x03, 0x70, 0x07, 0x00, 0x0e, 0xcc, 0x1c,
   0x78, 0x38, 0x30, 0x70, 0x78, 0x60, 0xcc, 0x00};
#define zoom_y_width 16
#define zoom_y_height 16
static unsigned char zoom_y_bits[] = {
   0x00, 0x00, 0x70, 0x00, 0xd8, 0x00, 0x8c, 0x01, 0x06, 0x03, 0x02, 0x02,
   0x06, 0x03, 0x8c, 0x01, 0xd8, 0x03, 0x70, 0x07, 0x00, 0x0e, 0xcc, 0x1c,
   0x78, 0x38, 0x30, 0x70, 0x30, 0x60, 0x30, 0x00};
#define atext_width 16
#define atext_height 16
static unsigned char atext_bits[] = {
   0x07, 0x00, 0xf2, 0xff, 0xf2, 0xff, 0x12, 0x86, 0x02, 0x06, 0x02, 0x06,
   0x02, 0x06, 0x02, 0x06, 0x02, 0x06, 0x02, 0x06, 0x02, 0x06, 0x02, 0x06,
   0x02, 0x06, 0x02, 0x06, 0x02, 0x0f, 0x07, 0x00};
#define exit_width 16
#define exit_height 16
static unsigned char exit_bits[] = {
   0x00, 0x00, 0x80, 0x01, 0xb0, 0x0d, 0xb8, 0x1d, 0x8c, 0x31, 0x8c, 0x31,
   0x86, 0x61, 0x86, 0x61, 0x86, 0x61, 0x86, 0x61, 0x0c, 0x30, 0x0c, 0x30,
   0x38, 0x1c, 0xf0, 0x0f, 0xc0, 0x03, 0x00, 0x00};

#endif /* __BITMAPS_H_ */
