#include "piecePairDialog.h"
#include "piecePair.h"

#include <qglobal.h>
#include <QScrollArea>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qslider.h>

class PiecePairView : public QWidget
{
public:
  PiecePairView(const osl::state::NumEffectState &state,
		QWidget *parent = 0, const char *name = 0)
    : QWidget(parent, name) {
    PiecePair *pair = new OpeningPair(state, this);
    PiecePair *endPair = new EndingPieces(state, this);
    ProgressPieces *progressPair = new ProgressPieces(state, this);
    openingLayout = new QVBoxLayout;
    openingLayout->addWidget(new QLabel("Opening", this));
    openingLayout->addWidget(pair);
    endingLayout = new QVBoxLayout;
    endingLayout->addWidget(new QLabel("Ending", this));
    endingLayout->addWidget(endPair);
    progressLayout = new QVBoxLayout;
    progressLayout->addWidget(new QLabel("Progress", this));
    progressLayout->addWidget(progressPair);
    QSlider *slider = new QSlider(0, 15, 1,
				  progressPair->progress16(),
				  Qt::Horizontal,
				  this);
    slider->setTickInterval(4);
    slider->setTickmarks(QSlider::Below);
    progressLayout->addWidget(slider);
    connect(slider, SIGNAL(valueChanged(int)),
	    progressPair, SLOT(setProgress(int)));
  
    QHBoxLayout *layout = new QHBoxLayout(this);
    layout->addLayout(openingLayout);
    layout->addLayout(endingLayout);
    layout->addLayout(progressLayout);
  }

  QSize minimumSizeHint() const {
    return QSize(openingLayout->sizeHint().width()
		 + endingLayout->sizeHint().width(),
		 progressLayout->sizeHint().height());
  }
private:
  QVBoxLayout *openingLayout, *endingLayout, *progressLayout;
};

PiecePairDialog::PiecePairDialog(const osl::state::NumEffectState &state,
				 QWidget *parent, const char *name)
  : QDialog(parent, name)
{
  QScrollArea *sv = new QScrollArea(this);
  PiecePairView *view = new PiecePairView(state, sv->viewport());
  sv->setWidget(view);
  QVBoxLayout *mainLayout = new QVBoxLayout(this);
  mainLayout->addWidget(sv);
  QPushButton *button = new QPushButton(this);
  button->setText("&OK");
  mainLayout->addWidget(button);
  connect(button, SIGNAL(clicked()), this, SLOT(accept()));
  resize(view->minimumSizeHint());
}
