#ifndef _KIFU_VIEWER_H
#define _KIFU_VIEWER_H
#include "boardTabChild.h"
#include "osl/state/simpleState.h"
#include "osl/record/searchInfo.h"
#include "osl/stl/vector.h"
#include "kifuFile.h"
#include <boost/scoped_ptr.hpp>
#include <boost/thread/mutex.hpp>
#include <QMutex>

class MoveList;
class QTableWidget;
class QListWidget;
class QTimer;
class QTextBrowser;

class KifuViewer : public BoardTabChild
{
Q_OBJECT
public:
  KifuViewer(QWidget *parent = 0, const char *name = 0);
  ~KifuViewer();
  void forward();
  void backward();
  void open(const osl::state::SimpleState& state,
	    const osl::stl::vector<osl::Move>& board_moves);
  void open(const osl::state::SimpleState& state,
	    const osl::stl::vector<osl::Move>& board_moves,
	    const osl::stl::vector<int>& consumed_time);
  void open(KifuFile *file);
  void toInitialState();
  void toLastState();
  void watchFile(bool enable);

  int moveCount() const {
    return index + 1;
  }
  osl::NumEffectState getStateAndMovesToCurrent(osl::stl::vector<osl::Move> &moves);
  const KifuFile *getKifuFile();
  QString getFilename() {
    return filename;
  }
  QWidget *moveGenerateDialog();
  static void setAnalyzeOnline(bool enable);
  void analyze();
public slots:
  void updateIndex(int i);
  void openEvalGraph(bool force);
  void updateStatusForAnalysis();
  void prepareUpdateForAnalysis(const osl::state::SimpleState &state,
				const osl::stl::vector<osl::Move> &moves,
				int limit, osl::Move next_move);
protected:
  osl::Move getNextMove();
private slots:
  void boardMoved(osl::Move move);
  void updateTime();
  void reloadFile();
  void stopAnalysisOnline();
signals:
  void stateReset();  
  void indexUpdate(int);  
  void analyzeOnlineDisabled();
private:
  int consumedTime(osl::Player player) const;
  QString secondToTime(int time);
  void updateStateToIndex(int n);
  void updateState();
  void resetState();
  void clearState();

  MoveList *list;
  QTableWidget *timeView;
  QListWidget *players;
  QListWidget *moveInfoView;
  QTextBrowser *commentView;
  QTimer *timer;
  uint lastReadTime;
  int index;
  osl::stl::vector<osl::Move> manualMoves;
  int manualIndex;
  osl::stl::vector<QString> comments;
  osl::stl::vector<osl::record::SearchInfo> move_info;
  QString filename;
  boost::scoped_ptr<KifuFile> kifuFile;
  QMutex kifuFileMutex;
  bool ignoreMoveSignal;
  static volatile bool analyzeOnlineEnabled, stateForAnalysisChanged;
  volatile bool watchFileEnabled;
  struct AnalysisOnlineThread;
  static boost::scoped_ptr<AnalysisOnlineThread> thread;
  static boost::scoped_ptr<osl::NumEffectState> stateForAnalysis;
public:
  class AnalysisOnlineDialog;
  static AnalysisOnlineDialog *analysisOnlineDialog;
};

#endif // _KIFU_VIEWER_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
