#ifndef _MOVE_TREE_H
#define _MOVE_TREE_H
#include "osl/move.h"
#include <qglobal.h>
#if QT_VERSION >= 0x040000
#include <Q3ListView>
#else
#include <qlistview.h>
#define Q3ListView QListView
#define Q3ListViewItem QListViewItem
#define Q3PopupMenu QPopupMenu
#endif

class MoveTreeItem;
class Q3PopupMenu;

class MoveTree : public Q3ListView
{
Q_OBJECT
public:
  MoveTree(QWidget *parent = 0, const char *name = 0) : Q3ListView(parent, name) {
    setRootIsDecorated(true);
  }
  virtual ~MoveTree();
  void contextMenuEvent(QContextMenuEvent *event);
public slots:
  void expandBest();
  void expandAll();
  void closeAll();
signals:
  void moveGenerate();
protected:
  void expandBestChildren(MoveTreeItem *item);
  virtual void showContextMenu(Q3PopupMenu *);
};

class MoveTreeItem : public Q3ListViewItem
{
  // Str1 must correspond to m.
public:
  MoveTreeItem(MoveTree *parent, osl::Move m,
	       QString str1 = QString::null, QString str2 = QString::null,
	       QString str3 = QString::null, QString str4 = QString::null,
	       QString str5 = QString::null, QString str6 = QString::null,
	       QString str7 = QString::null, QString str8 = QString::null)
    : Q3ListViewItem(parent, str1, str2, str3, str4, str5, str6, str7, str8),
      move(m) {
  }
  MoveTreeItem(MoveTreeItem *parent, osl::Move m,
	       QString str1 = QString::null, QString str2 = QString::null,
	       QString str3 = QString::null, QString str4 = QString::null,
	       QString str5 = QString::null, QString str6 = QString::null,
	       QString str7 = QString::null, QString str8 = QString::null)
    : Q3ListViewItem(parent, str1, str2, str3, str4, str5, str6, str7, str8),
      move(m) {
  }
  osl::Move getMove() const {
    return move;
  }
  virtual bool isBestMove() const {
    return true;
  }
  int compare(Q3ListViewItem *i, int col, bool ascending) const;
private:
  osl::Move move;
};

#endif // _MOVE_TREE_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
