#include "boardEditor2.h"
#include "gpsshogi/gui/editBoard2.h"
#include "osl/record/csa.h"
#include "osl/record/csaIOError.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QLineEdit>
#include <QRegExp>
#include <iostream>

BoardEditor2::BoardEditor2(QWidget *parent)
  : TabChild(parent), state(osl::HIRATE), player(osl::BLACK)
{
  QHBoxLayout *hlayout = new QHBoxLayout;
  board = new gpsshogi::gui::EditBoard2(this);
  hlayout->addWidget(board);
  QVBoxLayout *vlayout = new QVBoxLayout;
  line_edit = new QLineEdit(this);
  vlayout->addWidget(line_edit);
  QPushButton *clear_button = new QPushButton("&Clear Board", this);
  vlayout->addWidget(clear_button);
  QPushButton *to_black_stand_button = new QPushButton("To &Black Stand", this);
  QPushButton *to_white_stand_button = new QPushButton("To &White Stand", this);
  vlayout->addWidget(to_black_stand_button);
  vlayout->addWidget(to_white_stand_button);
  hlayout->addLayout(vlayout);
  setLayout(hlayout);

  connect(clear_button, SIGNAL(clicked()),
	  board, SLOT(clearState()));
  connect(line_edit, SIGNAL(returnPressed()),
	  this, SLOT(processText()));
  connect(to_black_stand_button, SIGNAL(clicked()),
	  this, SLOT(reserveToBlack()));
  connect(to_white_stand_button, SIGNAL(clicked()),
	  this, SLOT(reserveToWhite()));
}

const osl::state::SimpleState& BoardEditor2::getState()
{
  state = board->getState();
  return state;
}

void BoardEditor2::setState(const osl::state::SimpleState &state)
{
  board->setState(state);
}

void BoardEditor2::processText()
{
  QRegExp regex("^(\\+|-)?([1-9][1-9])?(..)$");
  if (regex.indexIn(line_edit->text()) != -1)
  {
    osl::Ptype ptype;
    try
    {
      ptype = osl::record::csa::strToPtype(regex.cap(3).toUpper().ascii());
    }
    catch (osl::CsaIOError &)
    {
      return;
    }
    int pos = regex.cap(2).toInt();
    if (regex.cap(1) == "-")
      player = osl::WHITE;
    else if (regex.cap(1) == "+")
      player = osl::BLACK;
    board->moveReserve(player,
		       ptype,
		       pos == 0 ? osl::Position::STAND() :
		       osl::Position(pos / 10, pos % 10));
    line_edit->setText("");
  }
}

void BoardEditor2::reserveToBlack()
{
  board->reserveToStand(osl::BLACK);
}

void BoardEditor2::reserveToWhite()
{
  board->reserveToStand(osl::WHITE);
}
