#!/usr/bin/perl -w
use strict;
use Getopt::Std;
use NKF;
use Net::Twitter;
use Encode;

my %options;
getopts('t:TS:u:', \%options);

# ./tweet.pl [-et:TS:] files

my $name = "gpsshogi";
my $name_en = "gpsshogi_en";
open(PASS, "passwd") || die "open $!";
my $pass = <PASS>;
close PASS;
my $dryrun=  ! defined $options{T};
my $url = $options{u};
my $seconds = $options{S};
my $titlefile = $options{t};

my $host = 'twitter.com';
my $apiurl = "http://$host";
my $apihost = "$host:80";

my $twit = Net::Twitter->new({username=>$name, password=>$pass, apiurl=>$apiurl, apihost=>$apihost});
my $twit_en = Net::Twitter->new({username=>$name_en, password=>$pass, apiurl=>$apiurl, apihost=>$apihost});

#my $twitter_com = "twitter.com"; # "128.121.146.228";
#  my $ret = system("curl", "-v", "-u", "$name:$pass", "-d", "status=$content", "http://$twitter_com/statuses/update.json")

sub say ($) {
  my ($original) = @_;
  my $content = nkf("-w", $original);
  my $utf8 = Encode::decode_utf8($content);
  $content = Encode::encode_utf8(substr($utf8, 0, 140))
    if (length($utf8) > 140);
  print STDERR "\nSEND $name:$content\n\n";
  return
    if ($dryrun);
  foreach my $i (1..3) {
    my $ret = $twit->update({status => $content});
    print STDERR $twit->http_code."\n";
    print STDERR $twit->http_message."\n";
    sleep 1;
    return $ret if $ret;
    print STDERR "failed $i\n";
    print STDERR join(' ', %{$twit->get_error})."\n";
  }
}
sub say_en ($) {
  my ($content) = @_;
  $content = substr($content, 0, 140)
    if (length($content) > 140);
  print STDERR "\nSEND $name_en:$content\n\n";
  return
    if ($dryrun);
  foreach my $i (1..3) {
    my $ret = $twit_en->update({status => $content});
    print STDERR $twit_en->http_code."\n";
    print STDERR $twit_en->http_message."\n";
    sleep 1;
    return $ret if $ret;
    print STDERR "failed $i\n";
    print STDERR %{$twit_en->get_error}."\n";
  }
}

sub announce_title ($$$$) {
  my ($title, $url, $seconds, $cont) = @_;
  open (PROG, "./analyze-kif --version|") || die "open $!";
  my $version = <PROG>; chomp $version;
  close PROG;
  my $name = "gpsshogi ";
  if ($cont) {
    $name = " ( " . $name;
    $url = $url . " ) ";
  }
  say($name . $version . " (max " . $seconds . " sec)  \n" . $title . " " . $url);
  say_en($name . $version . " (max " . $seconds . " sec)  \n" . " " . $url);
}

if ($titlefile && $url && $seconds) {
  open (TITLE, $titlefile) || die "open $!";
  my @title = <TITLE>;
  close TITLE;
  &announce_title(join("",@title), $url, $seconds, 1);
}


foreach my $file (@ARGV) {
  open (IN, $file) || die "open $!";
  my @contents = <IN>;
  close IN;
  if ($file =~ /-en.txt/) {
    say_en(join("", @contents));
  }
  else {
    say(join("", @contents));
  }
}
