#include "kisen_position.h"
#include "osl/checkmate/h_seed/seedMap.h"
#include "osl/checkmate/h_seed/features.h"
#include "osl/record/csaRecord.h"
#include "osl/numEffectState.h"
#include "osl/perfmon.h"

#include <boost/scoped_ptr.hpp>
#include <sstream>
#include <string>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <unistd.h>

using namespace osl;
using namespace osl::checkmate::h_seed;
using record::csa::ICsaRecordStream;

/**
 * @file
 * ꤵ줿̤δ¬ͤɽ.
 *   ˶  ˶
 * ̤ΰ, ζ PtypeO*8 (/)
 */
void usage(const char *prog)
{
  using namespace std;
  cerr << "Usage: " << prog << " -H heuristic_type [-o out] [-k kisen_file_name] "
       << endl;
  exit(1);
}

std::ostream *output = 0;
Features *features=0;

bool verbose = true;
void process_position(KisenFile&, int record_id, int move_id);

int main(int argc, char **argv)
{
  nice(20);

  const char *program_name = argv[0];
  bool error_flag = false;
  const char *kisen_filename = 0;
  const char *output_filename = 0;
  SeedMap seeds;

  extern char *optarg;
  extern int optind;
  char c;
  while ((c = getopt(argc, argv, "H:k:o:vh")) != EOF)
  {
    switch(c)
    {
    case 'H':	features = seeds.find(optarg);
      break;
    case 'k':	kisen_filename = optarg;
      break;
    case 'o':	output_filename = optarg;
      assert(output_filename);
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;

  if (error_flag || (! kisen_filename) || (! features))
    usage(program_name);

  boost::scoped_ptr<std::ostream> os;
  if (output_filename)
  {
    os.reset(new std::ofstream(output_filename));
    output = &*os;
  }
  else
  {
    output = &std::cout;
  }

  try
  {
    if (kisen_filename)
    {
      KisenFile kisen_file(kisen_filename);
      std::string line;
      while (std::getline(std::cin, line))
      {
	std::istringstream ss(line);
	int record_id, move_id;
	ss >> record_id >> move_id;
	assert(ss);
	process_position(kisen_file, record_id, move_id);
      }
    }
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << "\n";
    return 1;
  }
}


void analyzeState(std::ostream& os, int record_id, int move_id, 
		  const NumEffectState& state)
{
  assert((move_id < 0) ^ ((abs(move_id) % 2) == (state.getTurn() == BLACK)));
  os << record_id << " " << move_id << "\t ";
  const Player attacker = (move_id < 0) ? state.getTurn() : alt(state.getTurn());
  const Player defender = alt(attacker);
  // std::cerr << state.getTurn() << " " << attacker << "\n";
  features->init(state, defender);
  os << *features << "\n";
}

void process_position(KisenFile& kisen_file, int record_id, int move_id)
{
  const NumEffectState state(kisen_position(kisen_file, record_id, move_id));
  analyzeState(*output, record_id, move_id, state);
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
