// BROKEN

#include "osl/checkmate/dualCheckmateSearcher.h"
#include "osl/checkmate/dualCheckmateSearcher.tcc"
#include "osl/checkmate/checkmateSearcher.tcc"

#include "osl/checkmate/analyzer/treeWriter.h"
#include "osl/checkmate/analyzer/proofTreeTraverser.h"

#include "osl/checkmate/dominanceTable.h"
#include "osl/checkmate/checkmateRecorder.h"
#include "osl/checkmate/libertyEstimator.h"
#include "osl/checkmate/pieceCost.h"
#include "osl/checkmate/nullCost.h"
#include "osl/checkmate/nullEstimator.h"

#include "osl/record/csaRecord.h"
#include "osl/record/record.h"
#include "osl/record/kisen.h"
#include "osl/utility/pin.h"
#include "osl/hashEffectState.h"
#include "osl/perfmon.h"

#include "osl/doUndoMoveStack.h"

#include <boost/scoped_ptr.hpp>
#include <iostream>
#include <cstdlib>
#include <unistd.h>

using namespace osl;
using namespace osl::checkmate;
using namespace osl::checkmate::analyzer;
using record::csa::ICsaRecordStream;

/**
 * @file
 * ʤ顤̤ФƵ;Ƥӡ
 * ؼΥƥФڤ礭Ĵ٤.
 */
void usage(const char *prog)
{
  using namespace std;
  cerr << "Usage: " << prog << " [-o out] [-l nodelimit] [-k kisenFileName] "
       << "[-F skip-first-n-records] csa-filenames "
       << endl;
  exit(1);
}

class CostTable
{
  CArray<int, 3*3*PTYPE_SIZE*PTYPE_SIZE> data;
public:
  explicit CostTable(int max_cost=20)
  {
    assert(max_cost > 0);
    std::fill(data.begin(), data.end(), max_cost);
  }
  static int index(const NumEffectState& state, Move move)
  {
    const Position to = getTo(move);
    const Player attacker = getPlayer(move);
    const Player defender = alt(attacker);

    int attack_effect = state.countEffect2(attacker, to);
    if (! isOffBoard(getFrom(move)))
      attack_effect -= 1;
    const int defense_effect = state.countKingEffect(defender, to);

    int result = attack_effect*3 + defense_effect;
    result *= 3;

    const Ptype ptype = getPtype(move);
    const Ptype captured = getCapturePtype(move);

    result += ptype;
    result *= PTYPE_SIZE;
    result += captured;
    return result;
  }
  void updateMin(const NumEffectState& state, Move move, int new_cost)
  {
    const int index = CostTable::index(state, move);
    data[index] = std::min(data[index], new_cost);
  }
};



struct SacrificeAnalyzer
{
  struct CallBack : public TreeWriter
  {
    NumEffectState& state;
    DoUndoMoveStack<NumEffectState> stack;
    const Player attacker;
    CallBack(Player a, NumEffectState& s) : state(s), attacker(a)
    {
    }
    virtual ~CallBack() { assert(stack.empty()); }
    virtual void sacrifice(Move move, int attack_effect, int defense_effect,
			   int tree_size, int leaf_size) 
    {
      if (attack_effect == 0)
      {
	std::cout << move << " " << tree_size << " " << leaf_size << "\n";
	if (leaf_size < 10)
	{
	  // (getCapturePtype(move) == PTYPE_EMPTY)
	  std::cerr << state
		    << attack_effect << " " << defense_effect << "\n";
	}
      }
    }
    void showMove(const CheckHashRecord *from,
		  const CheckMove& move)
    {
      stack.push(state, move.move);
    }
    void showMoveAfter(const CheckHashRecord *from,
		       const CheckMove& check_move) 
    
    {
      const Move move = check_move.move;
      if (getPlayer(move) == attacker)
      {
	const Position to = getTo(move);
	const int attack_effect = state.countEffect2(attacker, to);
	const PieceMask pins = utility::Pin::make(state, alt(attacker));
	// ؤstateʤΤ
	const int defense_effect = state.countKingEffect(alt(attacker), to, pins);
	if (attack_effect < defense_effect)
	{
	  TreeWriter w;
	  ProofTreeTraverser traverser(w);
	  PathEncoding path(attacker);
	  traverser.traverseOrNode(MOVE_INVALID, from, key, path);
	  const int tree_size = traverser.getVisited().size();
	  const int leaf_size = traverser.getLeaves();
	  sacrifice(move, attack_effect, defense_effect, tree_size, leaf_size);
	}
      }
      
      stack.pop();
    }
  };
  CallBack *callback;
  explicit SacrificeAnalyzer(CallBack& c) : callback(&c)
  {
  }
  void analyze(const CheckHashRecord *record, const PathEncoding& path)
  {
    assert(record && isCheckmateSuccess(record->proofDisproof));
    ProofTreeTraverser traverser(*callback);
    if (callback->state.getTurn() == callback->attacker)
      traverser.traverseOrNode(MOVE_INVALID, record, path);
    else
      traverser.traverseAndNode(MOVE_INVALID, record, path);
  }
};

// Ȥꤢcheckstat 
bool verbose=false;
unsigned long long totalCycles=0;
size_t limit = 409600; // 3900;
bool forceAttack = false;
int numCheckmate=0, numEscape=0, numUnkown=0;
size_t logThreshold = 0;
bool useHeuristics = true;

template <class Table, class H, class Cost>
void search(const char *filename);
void searchFile(const char *filename);

int main(int argc, char **argv)
{
  const char *program_name = argv[0];
  bool error_flag = false;
  extern char *optarg;
  extern int optind;

  const char *FILES = 0;
  char c;
  while ((c = getopt(argc, argv, "A:a:F:EL:l:Pptvh")) != EOF)
  {
    switch(c)
    {
    case 'F':	FILES = optarg;
      break;
    case 'L':	logThreshold = atoi(optarg);
      assert(logThreshold);
      break;
    case 'l':	limit = atoi(optarg);
      assert(limit);
      break;
    case 'P':	useHeuristics = false;
      break;
    case 't':	forceAttack = true;
      break;
    case 'v':	verbose = true;
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;

  if (error_flag || ((argc < 1) && (! FILES)))
    usage(program_name);

  std::cerr << "limit " << limit << "\n";
  try
  {
    for (int i=0; i<argc; ++i)
    {
      searchFile(argv[i]);
      totalCycles = 0;
    }
    if (FILES)
    {
      std::ifstream is(FILES);
      std::string filename;
      while (is >> filename)
      {
	searchFile(filename.c_str());
	totalCycles = 0;
      }
    }
    std::cerr << "check " << numCheckmate << " escape " << numEscape
	      << " unknown " << numUnkown << "\n";
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << "\n";
    return 1;
  }
}

void searchFile(const char *filename)
{
  if (verbose)
    std::cerr << "\nsolving " << filename << "\n";
  if (useHeuristics)
    search<DominanceTable,LibertyEstimator,PieceCost>(filename);
  else
    search<DominanceTable,PureLibertyEstimator,NullCost>(filename);
}

/**
 * CSA Υե뤫 stream 1()ɤ
 */
void readCsaState(std::istream& is, SimpleState& state)
{
  record::Record rec;
  record::csa::ICsaRecordStream irs(is);
  irs.load(&rec);
  state = rec.getInitialState();
}


/**
 * @param P ¦
 */
template <Player P, class Searcher>
void testWinOrLose(const char *curFilename,
		   Searcher& searcher,
		   const SimpleState& sstate, int limit)
{
  typedef typename Searcher::table_t table_t;
  HashEffectState state((NumEffectState(sstate)));
  const PathEncoding path(state.getTurn());
  if ((! forceAttack) 
      && state.hasEffectBy(alt(P),state.template getKingPosition<P>()))
  {
    // ꤫鲦꤬äƤ
    clock_start();
    const bool lose = searcher.template isLosingState<P>(limit, state, path);
    totalCycles += clock_stop();
#if 0
    std::cerr << " done\n";
#endif
    if (verbose)
    {
      const table_t& table = searcher.getTable(alt(P));
      const CheckHashRecord *record = table.find(state.getHash());
      SacrificeAnalyzer::CallBack printer(alt(P), state);
      SacrificeAnalyzer analyzer(printer);
      if (lose)
      {
	++numCheckmate;
	std::cerr << "lose\n";
	analyzer.analyze(record, path);
	return;
      }
      else
      {
	assert(record);
	if (isCheckmateFail(record->proofDisproof)
	    || record->findLoop(path))
	{
	  ++numEscape;
	  std::cerr << "escape\n";
	  return;
	}
	else
	{
	  assert(! isFinal(record->proofDisproof));
	  ++numUnkown;
	  std::cerr << "unknown " << record->proofDisproof << "\n";
	  return;
	}
      }
    }
  }
  else
  {
    Move checkmateMove;
    clock_start();
    const bool win = searcher.
      template isWinningState<P>(limit, state, path, checkmateMove);
    totalCycles += clock_stop();
#if 0
    std::cerr << " done\n";
#endif
    if (verbose)
    {
      const table_t& table = searcher.getTable(P);
      const CheckHashRecord *record = table.find(state.getHash());
      SacrificeAnalyzer::CallBack printer(P, state);
      SacrificeAnalyzer analyzer(printer);

      if ((record->proofDisproof != Checkmate)
	  && (record->proofDisproof != NoCheckmate))
	std::cerr << record->proofDisproof << "\n";
      // std::cerr << record->bestResultInSolved << "\n";
      if (win)
      {
	++numCheckmate;
	std::cerr << "win by " << checkmateMove << "\n";
	analyzer.analyze(record, path);
	return;
      }
      else
      {
	assert(record);
	if (isFinal(record->proofDisproof)
	    || record->findLoop(path))
	{
	  ++numEscape;
	  std::cerr << "no checkmate\n";
	  return;
	}
	else
	{
	  ++numUnkown;
	  std::cerr << "unknown " << record->proofDisproof << "\n";
	  return;
	}
      }
    }
  }
}

template <class Table, class H, class Cost>
void search(const char *filename)
{
  std::ifstream is(filename);
  typedef DualCheckmateSearcher<HashEffectState, Table, H, Cost> searcher_t;
  searcher_t searcher(20000000, verbose);

  SimpleState state;
  readCsaState(is, state);

  if (state.getTurn() == BLACK)
    testWinOrLose<BLACK,searcher_t>(filename, searcher, state, limit);
  else
    testWinOrLose<WHITE,searcher_t>(filename, searcher, state, limit);


  clock_message(totalCycles, "total ", 
		searcher.searcher(BLACK).getTotalNodeCount()
		+ searcher.searcher(WHITE).getTotalNodeCount());
  clock_message(totalCycles, "unique", 
		searcher.getTable(BLACK).size()
		+ searcher.getTable(WHITE).size());
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
