#!/usr/bin/perl -w
use strict;
use Getopt::Std;

# sync.pl -l localdir -h host -r remotedir
# -- localdir/in -> remotedir@host/in
# -- remotedir@host/out -> remotedir@host/out

my %options;
getopts("l:h:r:",\%options);

my ($localdir, $host, $remotedir, $lpath, $rpath)
  = ($options{l} || "local-csa",
     $options{h} || "macpro",
     $options{r} || "remote-csa",
     $options{L} || "..",
     $options{R} || "/home/kaneko/up/gpsshogi",
    );

system "mkdir", "-p", "$localdir/in";
system "mkdir", "-p", "$localdir/out";
system "ssh $host mkdir -p $remotedir/in";
system "ssh $host mkdir -p $remotedir/out";
system "ssh $host chmod 777 $remotedir/in";
system "ssh $host chmod 777 $remotedir/out";

{
  my $pid=fork;
  if (!$pid){
    my $cmd = "perl $lpath/bin/util/filetostdout.pl -k -d $localdir/in | ssh $host perl -I $rpath/bin $rpath/bin/util/stdintofile.pl -d $remotedir/in";
    print STDERR "$cmd\n";
    system($cmd);
    exit(0);
  }
}

{
  my $pid=fork;
  if (!$pid){
    my $cmd = "ssh $host perl -I $rpath/bin $rpath/bin/util/filetostdout.pl -k -d $remotedir/out | perl $lpath/bin/util/stdintofile.pl -d $localdir/out";
    print STDERR "$cmd\n";
    system($cmd);
    exit(0);
  }
}

wait;
wait;
