/*
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GPASS_GNOME_ATTRIBUTE_WIDGETS_H__
#define __GPASS_GNOME_ATTRIBUTE_WIDGETS_H__

#include <gtk/gtk.h>

#include "gpass/attribute.h"
#include "gpass/entry-factory.h"

G_BEGIN_DECLS

/***********************************************************
 *
 * GPassGnomeAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_ATTRIBUTE (gpass_gnome_attribute_get_type())
#define GPASS_GNOME_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_ATTRIBUTE, \
                                GPassGnomeAttribute))
#define GPASS_GNOME_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_ATTRIBUTE, \
                             GPassGnomeAttributeClass))
#define GPASS_IS_GNOME_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_ATTRIBUTE))
#define GPASS_IS_GNOME_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_ATTRIBUTE))
#define GPASS_GNOME_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_ATTRIBUTE, \
                               GPassGnomeAttributeClass))

typedef struct {
    GObject parent;

    GPassAttribute *attribute;
    GtkWidget *label;
    GtkWidget *widget;
} GPassGnomeAttribute;

typedef struct {
    GObjectClass parent;

    void (*create_widget)(GPassGnomeAttribute *self);
    void (*value_to_widget)(GPassGnomeAttribute *self);
    void (*widget_to_value)(GPassGnomeAttribute *self);
} GPassGnomeAttributeClass;

GType gpass_gnome_attribute_get_type(void);

GPassGnomeAttribute *gpass_gnome_attribute_new(GPassAttribute *attribute);
GError *gpass_gnome_attribute_set(GPassGnomeAttribute *self, ...);
GError *gpass_gnome_attribute_get(GPassGnomeAttribute *self, ...);

/***********************************************************
 *
 * GPassGnomeTypeAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_TYPE_ATTRIBUTE \
    (gpass_gnome_type_attribute_get_type())
#define GPASS_GNOME_TYPE_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_TYPE_ATTRIBUTE, \
                                GPassGnomeTypeAttribute))
#define GPASS_GNOME_TYPE_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_TYPE_ATTRIBUTE, \
                             GPassGnomeTypeAttributeClass))
#define GPASS_IS_GNOME_TYPE_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_TYPE_ATTRIBUTE))
#define GPASS_IS_GNOME_TYPE_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_TYPE_ATTRIBUTE))
#define GPASS_GNOME_TYPE_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_TYPE_ATTRIBUTE, \
                               GPassGnomeTypeAttributeClass))

typedef struct {
    GPassGnomeAttribute parent;
} GPassGnomeTypeAttribute;

typedef struct {
    GPassGnomeAttributeClass parent;
} GPassGnomeTypeAttributeClass;

GType gpass_gnome_type_attribute_get_type(void);

void gpass_gnome_type_attribute_append(GPassGnomeTypeAttribute *self,
                                       GPassEntryFactoryCursor *cursor);
void gpass_gnome_type_attribute_clear(GPassGnomeTypeAttribute *self);

/***********************************************************
 *
 * GPassGnomeIntegerAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_INTEGER_ATTRIBUTE \
    (gpass_gnome_integer_attribute_get_type())
#define GPASS_GNOME_INTEGER_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_INTEGER_ATTRIBUTE, \
                                GPassGnomeIntegerAttribute))
#define GPASS_GNOME_INTEGER_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_INTEGER_ATTRIBUTE, \
                             GPassGnomeIntegerAttributeClass))
#define GPASS_IS_GNOME_INTEGER_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_INTEGER_ATTRIBUTE))
#define GPASS_IS_GNOME_INTEGER_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_INTEGER_ATTRIBUTE))
#define GPASS_GNOME_INTEGER_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_INTEGER_ATTRIBUTE, \
                               GPassGnomeIntegerAttributeClass))

typedef struct {
    GPassGnomeAttribute parent;
} GPassGnomeIntegerAttribute;

typedef struct {
    GPassGnomeAttributeClass parent;
} GPassGnomeIntegerAttributeClass;

GType gpass_gnome_integer_attribute_get_type(void);

/***********************************************************
 *
 * GPassGnomeBooleanAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_BOOLEAN_ATTRIBUTE \
    (gpass_gnome_boolean_attribute_get_type())
#define GPASS_GNOME_BOOLEAN_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_BOOLEAN_ATTRIBUTE, \
                                GPassGnomeBooleanAttribute))
#define GPASS_GNOME_BOOLEAN_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_BOOLEAN_ATTRIBUTE, \
                             GPassGnomeBooleanAttributeClass))
#define GPASS_IS_GNOME_BOOLEAN_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_BOOLEAN_ATTRIBUTE))
#define GPASS_IS_GNOME_BOOLEAN_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_BOOLEAN_ATTRIBUTE))
#define GPASS_GNOME_BOOLEAN_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_BOOLEAN_ATTRIBUTE, \
                               GPassGnomeBooleanAttributeClass))

typedef struct {
    GPassGnomeAttribute parent;
} GPassGnomeBooleanAttribute;

typedef struct {
    GPassGnomeAttributeClass parent;
} GPassGnomeBooleanAttributeClass;

GType gpass_gnome_boolean_attribute_get_type(void);

/***********************************************************
 *
 * GPassGnomeTimeAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_TIME_ATTRIBUTE \
    (gpass_gnome_time_attribute_get_type())
#define GPASS_GNOME_TIME_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_TIME_ATTRIBUTE, \
                                GPassGnomeTimeAttribute))
#define GPASS_GNOME_TIME_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_TIME_ATTRIBUTE, \
                             GPassGnomeTimeAttributeClass))
#define GPASS_IS_GNOME_TIME_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_TIME_ATTRIBUTE))
#define GPASS_IS_GNOME_TIME_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_TIME_ATTRIBUTE))
#define GPASS_GNOME_TIME_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_TIME_ATTRIBUTE, \
                               GPassGnomeTimeAttributeClass))

typedef struct {
    GPassGnomeAttribute parent;
} GPassGnomeTimeAttribute;

typedef struct {
    GPassGnomeAttributeClass parent;
} GPassGnomeTimeAttributeClass;

GType gpass_gnome_time_attribute_get_type(void);

/***********************************************************
 *
 * GPassGnomeStringAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_STRING_ATTRIBUTE \
    (gpass_gnome_string_attribute_get_type())
#define GPASS_GNOME_STRING_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_STRING_ATTRIBUTE, \
                                GPassGnomeStringAttribute))
#define GPASS_GNOME_STRING_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_STRING_ATTRIBUTE, \
                             GPassGnomeStringAttributeClass))
#define GPASS_IS_GNOME_STRING_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_STRING_ATTRIBUTE))
#define GPASS_IS_GNOME_STRING_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_STRING_ATTRIBUTE))
#define GPASS_GNOME_STRING_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_STRING_ATTRIBUTE, \
                               GPassGnomeStringAttributeClass))

typedef struct {
    GPassGnomeAttribute parent;
} GPassGnomeStringAttribute;

typedef struct {
    GPassGnomeAttributeClass parent;
} GPassGnomeStringAttributeClass;

GType gpass_gnome_string_attribute_get_type(void);

/***********************************************************
 *
 * GPassGnomeTextAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_TEXT_ATTRIBUTE \
    (gpass_gnome_text_attribute_get_type())
#define GPASS_GNOME_TEXT_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_TEXT_ATTRIBUTE, \
                                GPassGnomeTextAttribute))
#define GPASS_GNOME_TEXT_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_TEXT_ATTRIBUTE, \
                             GPassGnomeTextAttributeClass))
#define GPASS_IS_GNOME_TEXT_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_TEXT_ATTRIBUTE))
#define GPASS_IS_GNOME_TEXT_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_TEXT_ATTRIBUTE))
#define GPASS_GNOME_TEXT_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_TEXT_ATTRIBUTE, \
                               GPassGnomeTextAttributeClass))

typedef struct {
    GPassGnomeAttribute parent;
} GPassGnomeTextAttribute;

typedef struct {
    GPassGnomeAttributeClass parent;
} GPassGnomeTextAttributeClass;

GType gpass_gnome_text_attribute_get_type(void);

/***********************************************************
 *
 * GPassGnomePasswordAttribute
 *
 ***********************************************************/
#define GPASS_TYPE_GNOME_PASSWORD_ATTRIBUTE \
    (gpass_gnome_password_attribute_get_type())
#define GPASS_GNOME_PASSWORD_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), GPASS_TYPE_GNOME_PASSWORD_ATTRIBUTE, \
                                GPassGnomePasswordAttribute))
#define GPASS_GNOME_PASSWORD_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), GPASS_TYPE_GNOME_PASSWORD_ATTRIBUTE, \
                             GPassGnomePasswordAttributeClass))
#define GPASS_IS_GNOME_PASSWORD_ATTRIBUTE(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), GPASS_TYPE_GNOME_PASSWORD_ATTRIBUTE))
#define GPASS_IS_GNOME_PASSWORD_ATTRIBUTE_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), GPASS_TYPE_GNOME_PASSWORD_ATTRIBUTE))
#define GPASS_GNOME_PASSWORD_ATTRIBUTE_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS((obj), GPASS_TYPE_GNOME_PASSWORD_ATTRIBUTE, \
                               GPassGnomePasswordAttributeClass))

typedef struct {
    GPassGnomeAttribute parent;
} GPassGnomePasswordAttribute;

typedef struct {
    GPassGnomeAttributeClass parent;
} GPassGnomePasswordAttributeClass;

GType gpass_gnome_password_attribute_get_type(void);

G_END_DECLS

#endif /* #ifndef __GPASS_GNOME_ATTRIBUTE_WIDGETS_H__ */
