# tests/test_quote.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'karma')
plugins.reload('gozerplugs.plugs', 'quote')

class test_quote(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'

    def test_quoteadd(self):
        result = self.b.test('quote-add')
        self.assert_(stringinlist('<quote>', result))

    def test_quoteadd2(self):
        result = self.b.test('quote-add mekker')
        self.assert_(stringinlist('added', result))

    def test_quotewho(self):
        result = self.b.test('quote-who')
        self.assert_(stringinlist('<nr>', result))

    def test_quotewho2(self):
        result = self.b.test('quote-who mekker')
        self.assert_(stringinlist('must be an integer', result))

    def test_quotewho3(self):
        id = self.b.test('quote-add bla bla')[0].split()[1]
        result = self.b.test('quote-who %s' % id)
        self.assert_(stringinlist('was made', result))

    def test_quotedel(self):
        result = self.b.test('quote-del')
        self.assert_(stringinlist('<nr>', result))

    def test_quotedel2(self):
        result = self.b.test('quote-del mekker')
        self.assert_(stringinlist('be an integer', result))

    def test_quotedel3(self):
        id = self.b.test('quote-add bla bla')[0].split()[1]
        result = self.b.test('quote-del %s' % id)
        self.assert_(stringinlist('deleted', result))

    def test_quotedel4(self):
        result = self.b.test('quote-del 1451345134')
        self.assert_(stringinlist("can't delete", result))

    def test_quotelast(self):
        self.b.test('quote-add mekker')
        result = self.b.test('quote-last')
        self.assert_(stringinlist("mekker", result))

    def test_quotelast2(self):
        result = self.b.test('quote-last 2')
        self.assert_(len(result) == 2)
        self.assert_(stringinlist("#", result))

    def test_quote22(self):
        result = self.b.test('quote-2')
        self.assert_(len(result) == 2)
        self.assert_(stringinlist("#", result))

    def test_quoteid(self):
        result = self.b.test('quote-id')
        self.assert_(stringinlist('<nr>', result))

    def test_quoteid2(self):
        result = self.b.test('quote-id mekker')
        self.assert_(stringinlist('must be an integer', result))

    def test_quoteid(self):
        id = self.b.test('quote-add mekker')[0].split()[1]
        result = self.b.test('quote-id %s' % id)
        self.assert_(stringinlist('#', result))

    def test_quote(self):
        result = self.b.test('quote')
        self.assert_(stringinlist('#', result))

    def test_quotesearch(self):
        result = self.b.test('quote-search')
        self.assert_(stringinlist('<item>', result))

    def test_quotesearch2(self):
        self.b.test('quote-add mekker')
        result = self.b.test('quote-search mek')
        self.assert_(stringinlist('mekker', result))

    def test_quotecount(self):
        result = self.b.test('quote-count')
        self.assert_(stringinlist('quotes count is', result))

    def test_quotegood(self):
        self.b.test('quote 1++')
        result = self.b.test('quote-good')
        self.assert_(stringinlist('quote goodness', result))

    def test_quotebad(self):
        self.b.test('quote 2--')
        result = self.b.test('quote-bad')
        self.assert_(stringinlist('quote badness', result))
