# tests/test_install.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'install')

class test_install(unittest.TestCase):
    b = Bot('testbot', ['test@test', ])
    b.userhosts['test'] = 'test@test'

    def test_install(self):
        result = self.b.test('install mekker')
        self.assert_(stringinlist('maybe', result))

    def test_install2(self):
        result = self.b.test('install gozerbot.org plugs mekker')
        self.assert_(stringinlist('no mekker', result))

    def test_install3(self):
        result = self.b.test('install gozerbot.org plugs 8b')
        self.assert_(stringinlist('reloaded', result))

    def test_installplug(self):
        result = self.b.test('install-plug')
        self.assert_(stringinlist('<plugname>', result))

    def test_installplug2(self):
        result = self.b.test('install-plug mekker')
        self.assert_(stringinlist('no mekker', result))

    def test_installplug3(self):
        result = self.b.test('install-plug 8b')
        self.assert_(stringinlist('reloaded', result))

    def test_installlist(self):
        result = self.b.test('install-list')
        self.assert_(stringinlist('8b', result))

    def test_installsites(self):
        result = self.b.test('install-sites')
        self.assert_(stringinlist('gozerbot.org', result))
