//  Gnomoradio - gnomoradio/playlist-druid.cc
//  Copyright (C) 2004  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "playlist-druid.h"
#include "criteria-creator.h"
#include "wraporadio/wraporadio.h"

using namespace std;
using namespace Gnomoradio;
using namespace Gtk;

Gnomoradio::PlaylistDruid::PlaylistDruid ()
	: blank_list(_("Standard Playlist (user configurable)")),
	  radio_list(_("Radio Playlist (automatically chooses songs)")),
	search_list(_("Search Playlist (generated by user-defined criteria)"))
{
	set_border_width(8);

        // select type page
	Gtk::Label *instructions1 = manage(new Gtk::Label(_("Please select the type of playlist that you wish to create.")));
	instructions1->set_line_wrap();

	Gtk::RadioButton::Group group = blank_list.get_group();
	radio_list.set_group(group);
	search_list.set_group(group);

	Gtk::VBox *type_vbox = new Gtk::VBox(false, 8);

	first_page = type_vbox;

	type_vbox->pack_start(*instructions1, PACK_SHRINK);
	type_vbox->pack_start(blank_list, PACK_SHRINK);
	type_vbox->pack_start(radio_list, PACK_SHRINK);
	type_vbox->pack_start(search_list, PACK_SHRINK);

	druid.append_page(first_page);

	// dummy page
	Gtk::Label *dum = manage(new Gtk::Label(_("dummy")));
	Gtk::VBox *dummy_page = new Gtk::VBox;
	dummy_page->pack_start(*dum);
	druid.append_page(dummy_page);

	// make druid ready to start
	signal_hide().connect(sigc::mem_fun(*this, &PlaylistDruid::on_hide_window));

	druid.signal_next.connect(sigc::mem_fun(*this, &PlaylistDruid::on_signal_next));

	add(druid);
	set_default_size(400, 250);
	
	druid.signal_finished.connect(sigc::mem_fun(*this, &PlaylistDruid::create_list));

	druid.pages_ready();
}

Gnomoradio::PlaylistDruid::~PlaylistDruid ()
{

}

void Gnomoradio::PlaylistDruid::on_signal_next (Gtk::Widget *from_page)
{
	if (from_page == first_page)
		complete_druid_setup();
}

void Gnomoradio::PlaylistDruid::complete_druid_setup ()
{
	druid.remove_everything_after_current_page();

	// select name page
	Gtk::Label *instructions2 = manage(new Gtk::Label(_("Please choose a name for your playlist.")));
	instructions2->set_line_wrap();

	Gtk::Label *playlist_name_label = manage(new Gtk::Label(_("Playlist Name: ")));
	playlist_name_entry.set_text(_("Untitled"));
	playlist_name_entry.signal_changed().connect(sigc::mem_fun(*this, &Gnomoradio::PlaylistDruid::on_playlist_name_entry_changed));

	Gtk::HBox *playlist_name_hbox = manage(new Gtk::HBox);
	playlist_name_hbox->pack_start(*playlist_name_label, PACK_SHRINK);
	playlist_name_hbox->pack_start(playlist_name_entry, PACK_SHRINK);

	Gtk::VBox *name_page_vbox = new Gtk::VBox(false, 8);
	name_page_vbox->pack_start(*instructions2, PACK_SHRINK);
	name_page_vbox->pack_start(*playlist_name_hbox, PACK_SHRINK);

	druid.append_page(name_page_vbox);

	// Finish druid for a Radio Playlist
	if (radio_list.get_active()){
		Gtk::Label *radio_list_label = manage(new Gtk::Label(_("You can now choose the percentage of new songs that you want Gnomoradio to recommend and import for this Radio Playlist.  If set to zero, this list will download no new music.")));
		radio_list_label->set_line_wrap();

		// make some adjustments...
		Gtk::Adjustment *freq_adj = new Gtk::Adjustment(15, 0, 100);
		Gtk::Adjustment *plan_ahead_adj = new Gtk::Adjustment(60, 5, 4320);

		// Imported song frequency
		Gtk::Label *frequency_label1 = manage(new Gtk::Label(_("Import ")));
		Gtk::Label *frequency_label2 = manage(new Gtk::Label(_("% of new playlist songs")));
		Gtk::HBox *frequency_hbox = manage(new Gtk::HBox(false, 4));

		frequency.set_adjustment(*freq_adj);

		frequency_hbox->pack_start(*frequency_label1, PACK_SHRINK);
		frequency_hbox->pack_start(frequency, PACK_SHRINK);
		frequency_hbox->pack_start(*frequency_label2, PACK_SHRINK);

		Gtk::VBox *radio_list_vbox = new Gtk::VBox(false, 8);
		
		radio_list_vbox->pack_start(*radio_list_label, PACK_SHRINK);
		radio_list_vbox->pack_start(*frequency_hbox, PACK_SHRINK);

		druid.append_page(radio_list_vbox);
	}

	//complete druid for a search list
	if (search_list.get_active()) {
		Gtk::VBox *search_list_vbox = new Gtk::VBox(false, 8);

		Gtk::Label *search_list_label = manage(new Gtk::Label(_("Songs appearing in this playlist must fulfill the following criterion.  Click Add Criteria to set rules for the new playlist.")));
		search_list_label->set_line_wrap();

		criteria_creator.signal_show().connect(sigc::mem_fun(*this, &Gnomoradio::PlaylistDruid::disable_druid_advance)); 
		criteria_creator.signal_no_more_inputs.connect(sigc::mem_fun(*this, &Gnomoradio::PlaylistDruid::disable_druid_advance));
		criteria_creator.signal_changed.connect(sigc::mem_fun(*this, &Gnomoradio::PlaylistDruid::enable_druid_advance));

		search_list_vbox->pack_start(*search_list_label, PACK_SHRINK, 10);
		search_list_vbox->pack_start(criteria_creator, PACK_EXPAND_WIDGET);

		druid.append_page(search_list_vbox);
	}

	druid.pages_ready();
}

void Gnomoradio::PlaylistDruid::on_playlist_name_entry_changed ()
{
	if (playlist_name_entry.get_text_length() == 0)
		druid.set_able_to_move_on(false);
	else
		druid.set_able_to_move_on(true);
}

void Gnomoradio::PlaylistDruid::create_list ()
{
	if (blank_list.get_active())
		Wraporadio::SongList(playlist_name_entry.get_text());
	else if (radio_list.get_active())
		Wraporadio::SongListRadio(playlist_name_entry.get_text(), (unsigned short) frequency.get_value());
	else if (search_list.get_active())
		new Wraporadio::SongListSearch(criteria_creator.get_criterion(), playlist_name_entry.get_text());
}

void Gnomoradio::PlaylistDruid::on_hide_window ()
{
	delete this;
}
