/* history.c generated by valac 0.12.0, the Vala compiler
 * generated from history.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))
typedef struct _ParamSpecHistory ParamSpecHistory;

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryPrivate {
	GFile* history_dir;
	gboolean loaded;
	sqlite3* db;
};

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};


static gpointer history_parent_class = NULL;

gpointer history_ref (gpointer instance);
void history_unref (gpointer instance);
GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_history (GValue* value, gpointer v_object);
void value_take_history (GValue* value, gpointer v_object);
gpointer value_get_history (const GValue* value);
GType history_get_type (void) G_GNUC_CONST;
#define HISTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HISTORY, HistoryPrivate))
enum  {
	HISTORY_DUMMY_PROPERTY
};
History* history_new (GFile* data_dir);
History* history_construct (GType object_type, GFile* data_dir);
GFile* history_add (History* self, const gchar* date, const gchar* _result_, GError** error);
static void history_load (History* self);
void history_remove (History* self, GFile* file);
void history_update (History* self, GFile* file, const gchar* fen, const gchar* _result_);
GList* history_get_unfinished (History* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void history_load_history_recursive (History* self, GFile* base_dir, GFile* dir, gboolean load_files, GError** error);
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
const gchar* pgn_game_get_date (PGNGame* self);
const gchar* pgn_game_get_result (PGNGame* self);
static void history_finalize (History* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


History* history_construct (GType object_type, GFile* data_dir) {
	History* self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GFile* _tmp4_ = NULL;
	g_return_val_if_fail (data_dir != NULL, NULL);
	self = (History*) g_type_create_instance (object_type);
	_tmp0_ = g_file_get_path (data_dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "history", NULL, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_g_object_unref0 (self->priv->history_dir);
	self->priv->history_dir = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	return self;
}


History* history_new (GFile* data_dir) {
	return history_construct (TYPE_HISTORY, data_dir);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


GFile* history_add (History* self, const gchar* date, const gchar* _result_, GError** error) {
	GFile* result = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar* _tmp2_;
	gchar* year;
	gchar* _tmp3_;
	gchar* month;
	gchar* _tmp4_;
	gchar* day;
	gchar* relative_path = NULL;
	GFile* file = NULL;
	gint version;
	sqlite3_stmt* statement = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	sqlite3_stmt* _tmp25_ = NULL;
	gint _tmp26_;
	gint _tmp27_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (_result_ != NULL, NULL);
	history_load (self);
	_tmp1_ = _tmp0_ = g_strsplit (date, ".", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = _vala_array_length (_tmp0_);
	_tmp2_ = g_strdup ("????");
	year = _tmp2_;
	_tmp3_ = g_strdup ("??");
	month = _tmp3_;
	_tmp4_ = g_strdup ("??");
	day = _tmp4_;
	if (tokens_length1 == 3) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = g_strdup (tokens[0]);
		_g_free0 (year);
		year = _tmp5_;
		_tmp6_ = g_strdup (tokens[1]);
		_g_free0 (month);
		month = _tmp6_;
		_tmp7_ = g_strdup (tokens[2]);
		_g_free0 (day);
		day = _tmp7_;
	}
	version = 0;
	while (TRUE) {
		gchar* filename = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		GFile* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		GFileOutputStream* _tmp20_ = NULL;
		GFileOutputStream* _tmp21_;
		if (version == 0) {
			gchar* _tmp8_ = NULL;
			_tmp8_ = g_strdup_printf ("%s-%s-%s.pgn", year, month, day);
			_g_free0 (filename);
			filename = _tmp8_;
		} else {
			gchar* _tmp9_ = NULL;
			_tmp9_ = g_strdup_printf ("%s-%s-%s-%d.pgn", year, month, day, version);
			_g_free0 (filename);
			filename = _tmp9_;
		}
		_tmp10_ = g_build_filename (year, month, day, filename, NULL, NULL);
		_g_free0 (relative_path);
		relative_path = _tmp10_;
		_tmp11_ = g_file_get_path (self->priv->history_dir);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_build_filename (_tmp12_, relative_path, NULL, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		_g_object_unref0 (file);
		file = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_tmp16_ = g_file_get_path (file);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_path_get_dirname (_tmp17_);
		_tmp19_ = _tmp18_;
		g_mkdir_with_parents (_tmp19_, 0755);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		_tmp20_ = g_file_create (file, G_FILE_CREATE_NONE, NULL, &_inner_error_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp21_);
		if (_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_g_free0 (filename);
		break;
		goto __finally15;
		__catch15_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			if (!g_error_matches (e, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				GError* _tmp22_;
				_tmp22_ = _g_error_copy0 (e);
				_inner_error_ = _tmp22_;
				_g_error_free0 (e);
				goto __finally15;
			}
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			_g_object_unref0 (file);
			_g_free0 (relative_path);
			_g_free0 (day);
			_g_free0 (month);
			_g_free0 (year);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		version++;
		_g_free0 (filename);
	}
	_tmp23_ = g_strdup_printf ("INSERT INTO GameTable (date, path, result) VALUES (0, \"%s\", \"%s\")", relative_path, _result_);
	_tmp24_ = _tmp23_;
	_tmp26_ = sqlite3_prepare_v2 (self->priv->db, _tmp24_, -1, &_tmp25_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp25_;
	g_assert (_tmp26_ == SQLITE_OK);
	_g_free0 (_tmp24_);
	_tmp27_ = sqlite3_step (statement);
	if (_tmp27_ != SQLITE_DONE) {
		const gchar* _tmp28_ = NULL;
		_tmp28_ = sqlite3_errmsg (self->priv->db);
		g_warning ("history.vala:56: Failed to insert game into history index: %s", _tmp28_);
	}
	result = file;
	_sqlite3_finalize0 (statement);
	_g_free0 (relative_path);
	_g_free0 (day);
	_g_free0 (month);
	_g_free0 (year);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void history_remove (History* self, GFile* file) {
	gchar* _tmp0_ = NULL;
	gchar* relative_path;
	sqlite3_stmt* statement = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_relative_path (self->priv->history_dir, file);
	relative_path = _tmp0_;
	_tmp1_ = g_strdup_printf ("DELETE FROM GameTable WHERE path=\"%s\"", relative_path);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (self->priv->db, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp3_;
	g_assert (_tmp4_ == SQLITE_OK);
	_g_free0 (_tmp2_);
	_tmp5_ = sqlite3_step (statement);
	if (_tmp5_ != SQLITE_DONE) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = sqlite3_errmsg (self->priv->db);
		g_warning ("history.vala:68: Failed to remove game from history index: %s", _tmp6_);
	}
	_sqlite3_finalize0 (statement);
	_g_free0 (relative_path);
}


void history_update (History* self, GFile* file, const gchar* fen, const gchar* _result_) {
	gchar* _tmp0_ = NULL;
	gchar* relative_path;
	sqlite3_stmt* statement = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (fen != NULL);
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = g_file_get_relative_path (self->priv->history_dir, file);
	relative_path = _tmp0_;
	_tmp1_ = g_strdup_printf ("UPDATE GameTable SET fen=\"%s\", result=\"%s\" WHERE path=\"%s\"", fen, _result_, relative_path);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_prepare_v2 (self->priv->db, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp3_;
	g_assert (_tmp4_ == SQLITE_OK);
	_g_free0 (_tmp2_);
	_tmp5_ = sqlite3_step (statement);
	if (_tmp5_ != SQLITE_DONE) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = sqlite3_errmsg (self->priv->db);
		g_warning ("history.vala:78: Failed to update game in history index: %s", _tmp6_);
	}
	_sqlite3_finalize0 (statement);
	_g_free0 (relative_path);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* history_get_unfinished (History* self) {
	GList* result = NULL;
	GList* values;
	sqlite3_stmt* statement = NULL;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_;
	gint _result_;
	g_return_val_if_fail (self != NULL, NULL);
	history_load (self);
	values = NULL;
	_tmp1_ = sqlite3_prepare_v2 (self->priv->db, "SELECT path FROM GameTable WHERE result=\"*\"", -1, &_tmp0_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp0_;
	_result_ = _tmp1_;
	g_assert (_result_ == SQLITE_OK);
	while (TRUE) {
		gint _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* path;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		GFile* _tmp9_ = NULL;
		_tmp2_ = sqlite3_step (statement);
		_result_ = _tmp2_;
		if (!(_result_ == SQLITE_ROW)) {
			break;
		}
		_tmp3_ = sqlite3_column_text (statement, 0);
		_tmp4_ = g_strdup (_tmp3_);
		path = _tmp4_;
		g_debug ("history.vala:94: %s is unfinished", path);
		_tmp5_ = g_file_get_path (self->priv->history_dir);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_build_filename (_tmp6_, path, NULL, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_file_new_for_path (_tmp8_);
		values = g_list_append (values, _tmp9_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (path);
	}
	if (_result_ != SQLITE_DONE) {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = sqlite3_errmsg (self->priv->db);
		g_warning ("history.vala:99: Failed to get unfinished games: %s", _tmp10_);
	}
	result = values;
	_sqlite3_finalize0 (statement);
	return result;
}


static void history_load (History* self) {
	gboolean _tmp0_;
	gboolean have_history;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	sqlite3* _tmp7_ = NULL;
	gint _tmp8_;
	gboolean _tmp9_;
	sqlite3_stmt* statement = NULL;
	sqlite3_stmt* _tmp11_ = NULL;
	gint _tmp12_;
	gint _result_;
	gint _tmp13_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	GFile* _tmp18_ = NULL;
	GFile* _tmp19_;
	GFile* old_history_dir;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->loaded) {
		return;
	}
	_tmp0_ = g_file_query_exists (self->priv->history_dir, NULL);
	have_history = _tmp0_;
	_tmp1_ = g_file_get_path (self->priv->history_dir);
	_tmp2_ = _tmp1_;
	g_mkdir_with_parents (_tmp2_, 0755);
	_g_free0 (_tmp2_);
	_tmp3_ = g_file_get_path (self->priv->history_dir);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_filename (_tmp4_, "index.db", NULL);
	_tmp6_ = _tmp5_;
	_tmp8_ = sqlite3_open_v2 (_tmp6_, &_tmp7_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp7_;
	_tmp9_ = _tmp8_ != SQLITE_OK;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	if (_tmp9_) {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = sqlite3_errmsg (self->priv->db);
		g_warning ("history.vala:114: Failed to load history index: %s", _tmp10_);
	}
	_tmp12_ = sqlite3_prepare_v2 (self->priv->db, "CREATE TABLE IF NOT EXISTS GameTable (id INTEGER PRIMARY KEY, date INT" \
"EGER, path TEXT, fen TEXT, result TEXT)", -1, &_tmp11_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp11_;
	_result_ = _tmp12_;
	g_assert (_result_ == SQLITE_OK);
	_tmp13_ = sqlite3_step (statement);
	if (_tmp13_ != SQLITE_DONE) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = sqlite3_errmsg (self->priv->db);
		g_warning ("history.vala:121: Failed to create game table: %s", _tmp14_);
	}
	_tmp15_ = g_get_home_dir ();
	_tmp16_ = g_build_filename (_tmp15_, ".gnome2", "glchess", "history", NULL, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_file_new_for_path (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_);
	old_history_dir = _tmp19_;
	if (!have_history) {
		gboolean _tmp21_;
		_tmp21_ = g_file_query_exists (old_history_dir, NULL);
		_tmp20_ = _tmp21_;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		_tmp22_ = g_file_get_path (old_history_dir);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_file_get_path (self->priv->history_dir);
		_tmp25_ = _tmp24_;
		g_debug ("history.vala:127: Migrating history from %s to %s", _tmp23_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		history_load_history_recursive (self, old_history_dir, old_history_dir, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		goto __finally16;
		__catch16_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("history.vala:134: Failed to migrate history: %s", e->message);
			_g_error_free0 (e);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (old_history_dir);
			_sqlite3_finalize0 (statement);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->loaded = TRUE;
	_g_object_unref0 (old_history_dir);
	_sqlite3_finalize0 (statement);
}


static gpointer _pgn_game_ref0 (gpointer self) {
	return self ? pgn_game_ref (self) : NULL;
}


static void history_load_history_recursive (History* self, GFile* base_dir, GFile* dir, gboolean load_files, GError** error) {
	GFileEnumerator* _tmp0_ = NULL;
	GFileEnumerator* children;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_dir != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = g_file_enumerate_children (dir, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
	children = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	while (TRUE) {
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* info;
		GFileType _tmp2_;
		_tmp1_ = g_file_enumerator_next_file (children, NULL, &_inner_error_);
		info = _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (children);
			return;
		}
		if (info == NULL) {
			_g_object_unref0 (info);
			_g_object_unref0 (children);
			return;
		}
		_tmp2_ = g_file_info_get_file_type (info);
		switch (_tmp2_) {
			case G_FILE_TYPE_REGULAR:
			{
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				GFile* _tmp8_ = NULL;
				GFile* _tmp9_;
				GFile* f;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				PGN* _tmp12_ = NULL;
				PGN* pgn;
				gconstpointer _tmp13_ = NULL;
				PGNGame* _tmp14_;
				PGNGame* game;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GFile* _tmp17_ = NULL;
				GFile* new_file;
				if (!load_files) {
					break;
				}
				_tmp3_ = g_file_get_path (dir);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_file_info_get_name (info);
				_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL, NULL);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_file_new_for_path (_tmp7_);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				_g_free0 (_tmp4_);
				f = _tmp9_;
				_tmp10_ = g_file_get_path (f);
				_tmp11_ = _tmp10_;
				g_debug ("history.vala:158: Migrating %s", _tmp11_);
				_g_free0 (_tmp11_);
				_tmp12_ = pgn_new_from_file (f, &_inner_error_);
				pgn = _tmp12_;
				if (_inner_error_ != NULL) {
					goto __catch17_g_error;
				}
				_tmp13_ = g_list_nth_data (pgn->games, (guint) 0);
				_tmp14_ = _pgn_game_ref0 ((PGNGame*) _tmp13_);
				game = _tmp14_;
				_tmp15_ = pgn_game_get_date (game);
				_tmp16_ = pgn_game_get_result (game);
				_tmp17_ = history_add (self, _tmp15_, _tmp16_, &_inner_error_);
				new_file = _tmp17_;
				if (_inner_error_ != NULL) {
					_pgn_game_unref0 (game);
					_pgn_unref0 (pgn);
					goto __catch17_g_error;
				}
				g_file_copy (f, new_file, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_object_unref0 (new_file);
					_pgn_game_unref0 (game);
					_pgn_unref0 (pgn);
					goto __catch17_g_error;
				}
				_g_object_unref0 (new_file);
				_pgn_game_unref0 (game);
				_pgn_unref0 (pgn);
				goto __finally17;
				__catch17_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("history.vala:171: Failed to migrate file: %s", e->message);
					_g_error_free0 (e);
				}
				__finally17:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (f);
					_g_object_unref0 (info);
					_g_object_unref0 (children);
					return;
				}
				_g_object_unref0 (f);
				break;
			}
			case G_FILE_TYPE_DIRECTORY:
			{
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* path;
				GFile* _tmp23_ = NULL;
				GFile* _tmp24_;
				_tmp18_ = g_file_get_path (dir);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_file_info_get_name (info);
				_tmp21_ = g_build_filename (_tmp19_, _tmp20_, NULL, NULL);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp19_);
				path = _tmp22_;
				_tmp23_ = g_file_new_for_path (path);
				_tmp24_ = _tmp23_;
				history_load_history_recursive (self, base_dir, _tmp24_, TRUE, &_inner_error_);
				_g_object_unref0 (_tmp24_);
				if (_inner_error_ != NULL) {
					goto __catch18_g_error;
				}
				goto __finally18;
				__catch18_g_error:
				{
					GError * e;
					e = _inner_error_;
					_inner_error_ = NULL;
					g_warning ("history.vala:182: Couldn't open directory %s: %s", path, e->message);
					_g_error_free0 (e);
				}
				__finally18:
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (path);
					_g_object_unref0 (info);
					_g_object_unref0 (children);
					return;
				}
				_g_free0 (path);
				break;
			}
			default:
			{
				break;
			}
		}
		_g_object_unref0 (info);
	}
	_g_object_unref0 (children);
}


static void value_history_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_history_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		history_unref (value->data[0].v_pointer);
	}
}


static void value_history_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_history_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_history_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		History* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_history_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	History** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_history (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHistory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_history (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
	return value->data[0].v_pointer;
}


void value_set_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


void value_take_history (GValue* value, gpointer v_object) {
	History* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}


static void history_class_init (HistoryClass * klass) {
	history_parent_class = g_type_class_peek_parent (klass);
	HISTORY_CLASS (klass)->finalize = history_finalize;
	g_type_class_add_private (klass, sizeof (HistoryPrivate));
}


static void history_instance_init (History * self) {
	self->priv = HISTORY_GET_PRIVATE (self);
	self->priv->loaded = FALSE;
	self->ref_count = 1;
}


static void history_finalize (History* obj) {
	History * self;
	self = HISTORY (obj);
	_g_object_unref0 (self->priv->history_dir);
	_sqlite3_close0 (self->priv->db);
}


GType history_get_type (void) {
	static volatile gsize history_type_id__volatile = 0;
	if (g_once_init_enter (&history_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType history_type_id;
		history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&history_type_id__volatile, history_type_id);
	}
	return history_type_id__volatile;
}


gpointer history_ref (gpointer instance) {
	History* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void history_unref (gpointer instance) {
	History* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



