/* ChannelList.c generated by valac 0.11.3, the Vala compiler
 * generated from ChannelList.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dbus/dbus.h>


#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;

#define DVB_TYPE_CHANNEL_INFO (dvb_channel_info_get_type ())
typedef struct _DVBChannelInfo DVBChannelInfo;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
typedef struct _DVBChannelListPrivate DVBChannelListPrivate;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_IO_TYPE_CHANNEL_LIST_READER (dvb_io_channel_list_reader_get_type ())
#define DVB_IO_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReader))
#define DVB_IO_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))
#define DVB_IO_IS_CHANNEL_LIST_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_IS_CHANNEL_LIST_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_READER))
#define DVB_IO_CHANNEL_LIST_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_READER, DVBioChannelListReaderClass))

typedef struct _DVBioChannelListReader DVBioChannelListReader;
typedef struct _DVBioChannelListReaderClass DVBioChannelListReaderClass;
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DVBChannelInfo {
	guint id;
	gchar* name;
	gboolean is_radio;
};

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id, gchar** channel_name, GError** error);
	gboolean (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id, gchar** network, GError** error);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id, gboolean* radio, GError** error);
	gboolean (*GetChannelURL) (DVBIDBusChannelList* self, guint channel_id, gchar** url, GError** error);
	DVBChannelInfo* (*GetChannelInfos) (DVBIDBusChannelList* self, int* result_length1, GError** error);
	gboolean (*GetChannelsOfGroup) (DVBIDBusChannelList* self, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
	gboolean (*AddChannelToGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
	gboolean (*RemoveChannelFromGroup) (DVBIDBusChannelList* self, guint channel_id, gint channel_group_id, GError** error);
};

struct _DVBChannelList {
	GObject parent_instance;
	DVBChannelListPrivate * priv;
	GeeHashMap* channels;
};

struct _DVBChannelListClass {
	GObjectClass parent_class;
};

struct _DVBChannelListPrivate {
	GFile* _channels_file;
	guint _GroupId;
	GStaticRecMutex __lock_channels;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_group) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint* group_id, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};


static gpointer dvb_channel_list_parent_class = NULL;
static GeeIterableIface* dvb_channel_list_gee_iterable_parent_iface = NULL;
static DVBIDBusChannelListIface* dvb_channel_list_dvb_id_bus_channel_list_parent_iface = NULL;

DVBIDBusChannelList* dvb_id_bus_channel_list_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType dvb_channel_info_get_type (void) G_GNUC_CONST;
DVBChannelInfo* dvb_channel_info_dup (const DVBChannelInfo* self);
void dvb_channel_info_free (DVBChannelInfo* self);
void dvb_channel_info_copy (const DVBChannelInfo* self, DVBChannelInfo* dest);
void dvb_channel_info_destroy (DVBChannelInfo* self);
GType dvb_id_bus_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
#define DVB_CHANNEL_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_LIST, DVBChannelListPrivate))
enum  {
	DVB_CHANNEL_LIST_DUMMY_PROPERTY,
	DVB_CHANNEL_LIST_CHANNELS_FILE,
	DVB_CHANNEL_LIST_GROUP_ID,
	DVB_CHANNEL_LIST_SIZE,
	DVB_CHANNEL_LIST_ELEMENT_TYPE
};
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void dvb_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _dvb_channel_list_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult dvb_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_dvb_channel_list_introspect (DVBChannelList* self, DBusConnection* connection, DBusMessage* message);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel);
guint dvb_channel_get_Sid (DVBChannel* self);
void dvb_channel_list_remove (DVBChannelList* self, guint sid);
gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid);
void dvb_channel_list_clear (DVBChannelList* self);
static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error);
DVBioChannelListReader* dvb_io_channel_list_reader_new (DVBChannelList* channels, DVBAdapterType type);
DVBioChannelListReader* dvb_io_channel_list_reader_construct (GType object_type, DVBChannelList* channels, DVBAdapterType type);
GType dvb_io_channel_list_reader_get_type (void) G_GNUC_CONST;
void dvb_io_channel_list_reader_read_into (DVBioChannelListReader* self, GError** error);
static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
gint dvb_channel_list_get_size (DVBChannelList* self);
static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
guint dvb_channel_get_VideoPID (DVBChannel* self);
static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1, GError** error);
gboolean dvb_channel_is_radio (DVBChannel* self);
static gboolean dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id, gchar** channel_name, GError** error);
const gchar* dvb_channel_get_Name (DVBChannel* self);
static gboolean dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id, gchar** network, GError** error);
const gchar* dvb_channel_get_Network (DVBChannel* self);
static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id, gboolean* radio, GError** error);
static gboolean dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id, gchar** url, GError** error);
gchar* dvb_channel_get_URL (DVBChannel* self);
static DVBChannelInfo* dvb_channel_list_real_GetChannelInfos (DVBIDBusChannelList* base, int* result_length1, GError** error);
static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length);
static gboolean dvb_channel_list_real_GetChannelsOfGroup (DVBIDBusChannelList* base, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error);
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (void);
GeeList* dvb_database_config_store_get_channels_of_group (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
guint dvb_channel_list_get_GroupId (DVBChannelList* self);
static gboolean dvb_channel_list_real_AddChannelToGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_add_channel_to_group (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
static gboolean dvb_channel_list_real_RemoveChannelFromGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_remove_channel_from_group (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
GFile* dvb_channel_list_get_channels_file (DVBChannelList* self);
static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value);
void dvb_channel_list_set_GroupId (DVBChannelList* self, guint value);
static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_channel_list_finalize (GObject* obj);
static void _vala_dvb_channel_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_channel_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const DBusObjectPathVTable _dvb_channel_list_dbus_path_vtable = {_dvb_channel_list_dbus_unregister, dvb_channel_list_dbus_message};
static const _DBusObjectVTable _dvb_channel_list_dbus_vtable = {dvb_channel_list_dbus_register_object};

static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _dvb_channel_list_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_dvb_channel_list_introspect (DVBChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.ChannelList\">\n  <method name=\"GetChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRadioChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTVChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_name\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelNetwork\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"network\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRadioChannel\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"radio\" type=\"b\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelURL\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"url\" type=\"s\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelInfos\">\n    <arg name=\"result\" type=\"a(usb)\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelsOfGroup\">\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"channel_ids\" type=\"au\" direction=\"out\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"AddChannelToGroup\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"RemoveChannelFromGroup\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"channel_group_id\" type=\"i\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"channel_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult dvb_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_dvb_channel_list_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (dvb_id_bus_channel_list_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void dvb_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_channel_list_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	dvb_id_bus_channel_list_dbus_register_object (connection, path, object);
}


DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels) {
	DVBChannelList * self = NULL;
	self = (DVBChannelList*) g_object_new (object_type, "channels-file", channels, NULL);
	return self;
}


DVBChannelList* dvb_channel_list_new (GFile* channels) {
	return dvb_channel_list_construct (DVB_TYPE_CHANNEL_LIST, channels);
}


DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid) {
	DVBChannel* result = NULL;
	DVBChannel* val;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	val = NULL;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (sid));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBChannel* _tmp2_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (sid));
			_tmp2_ = (DVBChannel*) _tmp1_;
			_g_object_unref0 (val);
			val = _tmp2_;
		}
		__finally33:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (val);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = val;
	return result;
}


void dvb_channel_list_add (DVBChannelList* self, DVBChannel* channel) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	{
		guint _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		_tmp0_ = dvb_channel_get_Sid (channel);
		gee_abstract_map_set ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (_tmp0_), channel);
		__finally34:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_channel_list_remove (DVBChannelList* self, guint sid) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		gee_abstract_map_unset ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (sid), NULL);
		__finally35:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


gboolean dvb_channel_list_contains (DVBChannelList* self, guint sid) {
	gboolean result = FALSE;
	gboolean val = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (sid));
		val = _tmp0_;
		__finally36:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = val;
	return result;
}


void dvb_channel_list_clear (DVBChannelList* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		gee_abstract_map_clear ((GeeAbstractMap*) self->channels);
		__finally37:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GeeIterator* dvb_channel_list_real_iterator (GeeIterable* base) {
	DVBChannelList * self;
	GeeIterator* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* _tmp3_;
	self = (DVBChannelList*) base;
	_tmp0_ = gee_map_get_values ((GeeMap*) self->channels);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
	result = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
	return result;
}


void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error) {
	DVBioChannelListReader* _tmp0_ = NULL;
	DVBioChannelListReader* reader;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = dvb_io_channel_list_reader_new (self, type);
	reader = _tmp0_;
	dvb_io_channel_list_reader_read_into (reader, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (reader);
		return;
	}
	_g_object_unref0 (reader);
}


/**
         * @returns: List of channel IDs aka SIDs
         */
static guint* dvb_channel_list_real_GetChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	gint _tmp0_;
	guint* _tmp1_ = NULL;
	gint ids_length1;
	gint _ids_size_;
	guint* _tmp2_;
	guint* ids;
	gint i;
	guint* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_channel_list_get_size (self);
	_tmp1_ = g_new0 (guint, _tmp0_);
	_tmp2_ = _tmp1_;
	ids_length1 = _tmp0_;
	_ids_size_ = ids_length1;
	ids = _tmp2_;
	i = 0;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeSet* _tmp3_ = NULL;
			GeeSet* _tmp4_;
			GeeIterator* _tmp5_ = NULL;
			GeeIterator* _tmp6_;
			GeeIterator* _id_it;
			_tmp3_ = gee_map_get_keys ((GeeMap*) self->channels);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_id_it = (_tmp6_ = _tmp5_, _g_object_unref0 (_tmp4_), _tmp6_);
			while (TRUE) {
				gboolean _tmp7_;
				gpointer _tmp8_ = NULL;
				guint id;
				_tmp7_ = gee_iterator_next (_id_it);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = gee_iterator_get (_id_it);
				id = GPOINTER_TO_UINT (_tmp8_);
				ids[i] = id;
				i++;
			}
			_g_object_unref0 (_id_it);
		}
		__finally38:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				ids = (g_free (ids), NULL);
				return NULL;
			} else {
				ids = (g_free (ids), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp9_ = ids;
	*result_length1 = ids_length1;
	result = _tmp9_;
	return result;
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
static guint* dvb_channel_list_real_GetRadioChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	GSList* radio_channels;
	guint _tmp8_;
	guint* _tmp9_ = NULL;
	gint ids_length1;
	gint _ids_size_;
	guint* _tmp10_;
	guint* ids;
	guint* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	radio_channels = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _id_it;
			_tmp0_ = gee_map_get_keys ((GeeMap*) self->channels);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_id_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				guint id;
				gpointer _tmp6_ = NULL;
				DVBChannel* chan;
				guint _tmp7_;
				_tmp4_ = gee_iterator_next (_id_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_id_it);
				id = GPOINTER_TO_UINT (_tmp5_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (id));
				chan = (DVBChannel*) _tmp6_;
				_tmp7_ = dvb_channel_get_VideoPID (chan);
				if (_tmp7_ == 0) {
					radio_channels = g_slist_prepend (radio_channels, GUINT_TO_POINTER (id));
				}
				_g_object_unref0 (chan);
			}
			_g_object_unref0 (_id_it);
		}
		__finally39:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_slist_free0 (radio_channels);
				return NULL;
			} else {
				_g_slist_free0 (radio_channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	radio_channels = g_slist_reverse (radio_channels);
	_tmp8_ = g_slist_length (radio_channels);
	_tmp9_ = g_new0 (guint, _tmp8_);
	_tmp10_ = _tmp9_;
	ids_length1 = _tmp8_;
	_ids_size_ = ids_length1;
	ids = _tmp10_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				guint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				if (!_tmp11_) {
					i++;
				}
				_tmp11_ = FALSE;
				_tmp12_ = g_slist_length (radio_channels);
				if (!(i < _tmp12_)) {
					break;
				}
				_tmp13_ = g_slist_nth_data (radio_channels, (guint) i);
				ids[i] = GPOINTER_TO_UINT (_tmp13_);
			}
		}
	}
	_tmp14_ = ids;
	*result_length1 = ids_length1;
	result = _tmp14_;
	_g_slist_free0 (radio_channels);
	return result;
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
static guint* dvb_channel_list_real_GetTVChannels (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	guint* result = NULL;
	GSList* video_channels;
	guint _tmp8_;
	guint* _tmp9_ = NULL;
	gint ids_length1;
	gint _ids_size_;
	guint* _tmp10_;
	guint* ids;
	guint* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	video_channels = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _id_it;
			_tmp0_ = gee_map_get_keys ((GeeMap*) self->channels);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_id_it = (_tmp3_ = _tmp2_, _g_object_unref0 (_tmp1_), _tmp3_);
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				guint id;
				gpointer _tmp6_ = NULL;
				DVBChannel* chan;
				gboolean _tmp7_;
				_tmp4_ = gee_iterator_next (_id_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_id_it);
				id = GPOINTER_TO_UINT (_tmp5_);
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (id));
				chan = (DVBChannel*) _tmp6_;
				_tmp7_ = dvb_channel_is_radio (chan);
				if (!_tmp7_) {
					video_channels = g_slist_prepend (video_channels, GUINT_TO_POINTER (id));
				}
				_g_object_unref0 (chan);
			}
			_g_object_unref0 (_id_it);
		}
		__finally40:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_slist_free0 (video_channels);
				return NULL;
			} else {
				_g_slist_free0 (video_channels);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	video_channels = g_slist_reverse (video_channels);
	_tmp8_ = g_slist_length (video_channels);
	_tmp9_ = g_new0 (guint, _tmp8_);
	_tmp10_ = _tmp9_;
	ids_length1 = _tmp8_;
	_ids_size_ = ids_length1;
	ids = _tmp10_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				guint _tmp12_;
				gconstpointer _tmp13_ = NULL;
				if (!_tmp11_) {
					i++;
				}
				_tmp11_ = FALSE;
				_tmp12_ = g_slist_length (video_channels);
				if (!(i < _tmp12_)) {
					break;
				}
				_tmp13_ = g_slist_nth_data (video_channels, (guint) i);
				ids[i] = GPOINTER_TO_UINT (_tmp13_);
			}
		}
	}
	_tmp14_ = ids;
	*result_length1 = ids_length1;
	result = _tmp14_;
	_g_slist_free0 (video_channels);
	return result;
}


/**
         * @channel_id: ID of channel
         * @channel_name: Name of channel if channel with id exists
         * otherwise an empty string
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelName (DVBIDBusChannelList* base, guint channel_id, gchar** channel_name, GError** error) {
	DVBChannelList * self;
	gchar* _channel_name = NULL;
	gboolean result = FALSE;
	gboolean ret;
	gchar* _tmp0_;
	gchar* val;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	ret = FALSE;
	_tmp0_ = g_strdup ("");
	val = _tmp0_;
	{
		gboolean _tmp1_;
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
		if (_tmp1_) {
			gpointer _tmp2_ = NULL;
			DVBChannel* _tmp3_;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* name;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
			_tmp3_ = (DVBChannel*) _tmp2_;
			_tmp4_ = dvb_channel_get_Name (_tmp3_);
			_tmp5_ = g_strdup (_tmp4_);
			name = (_tmp6_ = _tmp5_, _g_object_unref0 (_tmp3_), _tmp6_);
			_tmp7_ = NULL;
			if (name == NULL) {
				_tmp7_ = "";
			} else {
				_tmp7_ = name;
			}
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (val);
			val = _tmp9_;
			ret = TRUE;
			_g_free0 (name);
		}
		__finally41:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				return FALSE;
			} else {
				_g_free0 (val);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp10_ = g_strdup (val);
	_tmp11_ = _tmp10_;
	_g_free0 (_channel_name);
	_channel_name = _tmp11_;
	result = ret;
	_g_free0 (val);
	if (channel_name) {
		*channel_name = _channel_name;
	} else {
		_g_free0 (_channel_name);
	}
	return result;
}


/**
         * @channel_id: ID of channel
         * @network: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelNetwork (DVBIDBusChannelList* base, guint channel_id, gchar** network, GError** error) {
	DVBChannelList * self;
	gchar* _network = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* val;
	gboolean ret;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = g_strdup ("");
	val = _tmp0_;
	ret = FALSE;
	{
		gboolean _tmp1_;
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
		if (_tmp1_) {
			gpointer _tmp2_ = NULL;
			DVBChannel* _tmp3_;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* tmp;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
			_tmp3_ = (DVBChannel*) _tmp2_;
			_tmp4_ = dvb_channel_get_Network (_tmp3_);
			_tmp5_ = g_strdup (_tmp4_);
			tmp = (_tmp6_ = _tmp5_, _g_object_unref0 (_tmp3_), _tmp6_);
			_tmp7_ = NULL;
			if (tmp == NULL) {
				_tmp7_ = "";
			} else {
				_tmp7_ = tmp;
			}
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (val);
			val = _tmp9_;
			ret = TRUE;
			_g_free0 (tmp);
		}
		__finally42:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (val);
				return FALSE;
			} else {
				_g_free0 (val);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp10_ = g_strdup (val);
	_tmp11_ = _tmp10_;
	_g_free0 (_network);
	_network = _tmp11_;
	result = ret;
	_g_free0 (val);
	if (network) {
		*network = _network;
	} else {
		_g_free0 (_network);
	}
	return result;
}


/**
         * @channel_id: ID of channel
         * @radio: Whether the channel is a radio channel or not
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_IsRadioChannel (DVBIDBusChannelList* base, guint channel_id, gboolean* radio, GError** error) {
	DVBChannelList * self;
	gboolean _radio = FALSE;
	gboolean result = FALSE;
	gboolean val;
	gboolean ret;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	val = FALSE;
	ret = FALSE;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBChannel* _tmp2_;
			gboolean _tmp3_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
			_tmp2_ = (DVBChannel*) _tmp1_;
			_tmp3_ = dvb_channel_is_radio (_tmp2_);
			val = _tmp3_;
			_g_object_unref0 (_tmp2_);
			ret = TRUE;
		}
		__finally43:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_radio = val;
	result = ret;
	if (radio) {
		*radio = _radio;
	}
	return result;
}


/**
         * @channel_id: ID of channel
         * @url: URL to watch the channel
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelURL (DVBIDBusChannelList* base, guint channel_id, gchar** url, GError** error) {
	DVBChannelList * self;
	gchar* _url = NULL;
	gboolean result = FALSE;
	DVBChannel* channel;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	channel = NULL;
	{
		gboolean _tmp0_;
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
		if (_tmp0_) {
			gpointer _tmp1_ = NULL;
			DVBChannel* _tmp2_;
			_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (channel_id));
			_tmp2_ = (DVBChannel*) _tmp1_;
			_g_object_unref0 (channel);
			channel = _tmp2_;
		}
		__finally44:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (channel);
				return FALSE;
			} else {
				_g_object_unref0 (channel);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	if (channel == NULL) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_strdup ("");
		_tmp4_ = _tmp3_;
		_g_free0 (_url);
		_url = _tmp4_;
		result = FALSE;
		_g_object_unref0 (channel);
		if (url) {
			*url = _url;
		} else {
			_g_free0 (_url);
		}
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = dvb_channel_get_URL (channel);
		_tmp6_ = _tmp5_;
		_g_free0 (_url);
		_url = _tmp6_;
		result = TRUE;
		_g_object_unref0 (channel);
		if (url) {
			*url = _url;
		} else {
			_g_free0 (_url);
		}
		return result;
	}
	_g_object_unref0 (channel);
	if (url) {
		*url = _url;
	} else {
		_g_free0 (_url);
	}
}


static void _vala_DVBChannelInfo_array_free (DVBChannelInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBChannelInfo* dvb_channel_list_real_GetChannelInfos (DVBIDBusChannelList* base, int* result_length1, GError** error) {
	DVBChannelList * self;
	DVBChannelInfo* result = NULL;
	gint _tmp0_;
	DVBChannelInfo* _tmp1_ = NULL;
	gint channels_length1;
	gint _channels_size_;
	DVBChannelInfo* _tmp2_;
	DVBChannelInfo* channels;
	gint i;
	DVBChannelInfo* _tmp17_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = gee_map_get_size ((GeeMap*) self->channels);
	_tmp1_ = g_new0 (DVBChannelInfo, _tmp0_);
	_tmp2_ = _tmp1_;
	channels_length1 = _tmp0_;
	_channels_size_ = channels_length1;
	channels = _tmp2_;
	i = 0;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channels);
		{
			GeeSet* _tmp3_ = NULL;
			GeeSet* _tmp4_;
			GeeIterator* _tmp5_ = NULL;
			GeeIterator* _tmp6_;
			GeeIterator* _id_it;
			_tmp3_ = gee_map_get_keys ((GeeMap*) self->channels);
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_id_it = (_tmp6_ = _tmp5_, _g_object_unref0 (_tmp4_), _tmp6_);
			while (TRUE) {
				gboolean _tmp7_;
				gpointer _tmp8_ = NULL;
				guint id;
				gpointer _tmp9_ = NULL;
				DVBChannel* channel;
				DVBChannelInfo chan_info = {0};
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gboolean _tmp13_;
				DVBChannelInfo _tmp14_;
				DVBChannelInfo _tmp15_ = {0};
				DVBChannelInfo _tmp16_;
				_tmp7_ = gee_iterator_next (_id_it);
				if (!_tmp7_) {
					break;
				}
				_tmp8_ = gee_iterator_get (_id_it);
				id = GPOINTER_TO_UINT (_tmp8_);
				_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) self->channels, GUINT_TO_POINTER (id));
				channel = (DVBChannel*) _tmp9_;
				memset (&chan_info, 0, sizeof (DVBChannelInfo));
				chan_info.id = id;
				_tmp10_ = dvb_channel_get_Name (channel);
				_tmp11_ = g_strdup (_tmp10_);
				_tmp12_ = _tmp11_;
				_g_free0 (chan_info.name);
				chan_info.name = _tmp12_;
				_tmp13_ = dvb_channel_is_radio (channel);
				chan_info.is_radio = _tmp13_;
				_tmp14_ = (dvb_channel_info_copy (&chan_info, &_tmp15_), _tmp15_);
				_tmp16_ = _tmp14_;
				dvb_channel_info_destroy (&channels[i]);
				channels[i] = _tmp16_;
				i++;
				dvb_channel_info_destroy (&chan_info);
				_g_object_unref0 (channel);
			}
			_g_object_unref0 (_id_it);
		}
		__finally45:
		g_static_rec_mutex_unlock (&self->priv->__lock_channels);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				channels = (_vala_DVBChannelInfo_array_free (channels, channels_length1), NULL);
				return NULL;
			} else {
				channels = (_vala_DVBChannelInfo_array_free (channels, channels_length1), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp17_ = channels;
	*result_length1 = channels_length1;
	result = _tmp17_;
	return result;
}


/**
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_GetChannelsOfGroup (DVBIDBusChannelList* base, gint channel_group_id, guint** channel_ids, int* channel_ids_length1, GError** error) {
	DVBChannelList * self;
	guint* _channel_ids = NULL;
	int _channel_ids_length1 = 0;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config;
	GeeList* channels;
	GeeList* _tmp1_ = NULL;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	guint* _tmp5_ = NULL;
	guint* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_factory_get_config_store ();
	config = _tmp0_;
	channels = NULL;
	_tmp1_ = dvb_database_config_store_get_channels_of_group (config, self->priv->_GroupId, channel_group_id, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch46_dvb_database_sql_error;
		}
		_g_object_unref0 (channels);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp3_ = _tmp2_;
	_g_object_unref0 (channels);
	channels = _tmp3_;
	goto __finally46;
	__catch46_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("ChannelList.vala:275: %s", e->message);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (channels);
		_g_object_unref0 (config);
		if (channel_ids) {
			*channel_ids = _channel_ids;
		} else {
			_channel_ids = (g_free (_channel_ids), NULL);
		}
		if (channel_ids_length1) {
			*channel_ids_length1 = _channel_ids_length1;
		}
		return result;
	}
	__finally46:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (channels);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (channels);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp4_ = gee_collection_get_size ((GeeCollection*) channels);
	_tmp5_ = g_new0 (guint, _tmp4_);
	_tmp6_ = _tmp5_;
	_channel_ids = (g_free (_channel_ids), NULL);
	_channel_ids_length1 = _tmp4_;
	_channel_ids = _tmp6_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gpointer _tmp8_ = NULL;
				if (!_tmp7_) {
					i++;
				}
				_tmp7_ = FALSE;
				if (!(i < _channel_ids_length1)) {
					break;
				}
				_tmp8_ = gee_list_get (channels, i);
				_channel_ids[i] = GPOINTER_TO_UINT (_tmp8_);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (channels);
	_g_object_unref0 (config);
	if (channel_ids) {
		*channel_ids = _channel_ids;
	} else {
		_channel_ids = (g_free (_channel_ids), NULL);
	}
	if (channel_ids_length1) {
		*channel_ids_length1 = _channel_ids_length1;
	}
	return result;
}


/**
         * @channel_id: ID of channel
     * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_AddChannelToGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config;
	DVBChannel* _tmp1_ = NULL;
	DVBChannel* chan;
	gboolean ret = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_factory_get_config_store ();
	config = _tmp0_;
	_tmp1_ = dvb_channel_list_get_channel (self, channel_id);
	chan = _tmp1_;
	if (chan == NULL) {
		result = FALSE;
		_g_object_unref0 (chan);
		_g_object_unref0 (config);
		return result;
	}
	_tmp2_ = dvb_database_config_store_add_channel_to_group (config, chan, channel_group_id, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch47_dvb_database_sql_error;
		}
		_g_object_unref0 (chan);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = _tmp3_;
	goto __finally47;
	__catch47_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("ChannelList.vala:304: %s", e->message);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally47:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (chan);
	_g_object_unref0 (config);
	return result;
}


/**
 * @channel_id: ID of channel
     * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_channel_list_real_RemoveChannelFromGroup (DVBIDBusChannelList* base, guint channel_id, gint channel_group_id, GError** error) {
	DVBChannelList * self;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* _tmp0_ = NULL;
	DVBdatabaseConfigStore* config;
	DVBChannel* _tmp1_ = NULL;
	DVBChannel* chan;
	gboolean ret = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	self = (DVBChannelList*) base;
	_tmp0_ = dvb_factory_get_config_store ();
	config = _tmp0_;
	_tmp1_ = dvb_channel_list_get_channel (self, channel_id);
	chan = _tmp1_;
	if (chan == NULL) {
		result = FALSE;
		_g_object_unref0 (chan);
		_g_object_unref0 (config);
		return result;
	}
	_tmp2_ = dvb_database_config_store_remove_channel_from_group (config, chan, channel_group_id, &_inner_error_);
	_tmp3_ = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			goto __catch48_dvb_database_sql_error;
		}
		_g_object_unref0 (chan);
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	ret = _tmp3_;
	goto __finally48;
	__catch48_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("ChannelList.vala:327: %s", e->message);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally48:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (chan);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (chan);
	_g_object_unref0 (config);
	return result;
}


GFile* dvb_channel_list_get_channels_file (DVBChannelList* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_channels_file;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_channel_list_set_channels_file (DVBChannelList* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_channels_file);
	self->priv->_channels_file = _tmp1_;
	g_object_notify ((GObject *) self, "channels-file");
}


guint dvb_channel_list_get_GroupId (DVBChannelList* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_GroupId;
	return result;
}


void dvb_channel_list_set_GroupId (DVBChannelList* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_GroupId = value;
	g_object_notify ((GObject *) self, "GroupId");
}


gint dvb_channel_list_get_size (DVBChannelList* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gee_map_get_size ((GeeMap*) self->channels);
	result = _tmp0_;
	return result;
}


static GType dvb_channel_list_real_get_element_type (GeeIterable* base) {
	GType result;
	DVBChannelList* self;
	self = (DVBChannelList*) base;
	result = DVB_TYPE_CHANNEL;
	return result;
}


static GObject * dvb_channel_list_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBChannelList * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_;
	parent_class = G_OBJECT_CLASS (dvb_channel_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_CHANNEL_LIST (obj);
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_CHANNEL, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->channels);
	self->channels = _tmp1_;
	return obj;
}


static void dvb_channel_list_class_init (DVBChannelListClass * klass) {
	dvb_channel_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelListPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_channel_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_channel_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_channel_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_CHANNELS_FILE, g_param_spec_object ("channels-file", "channels-file", "channels-file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_GROUP_ID, g_param_spec_uint ("GroupId", "GroupId", "GroupId", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_ELEMENT_TYPE, "element-type");
	g_type_set_qdata (DVB_TYPE_CHANNEL_LIST, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_channel_list_dbus_vtable));
}


static void dvb_channel_list_gee_iterable_interface_init (GeeIterableIface * iface) {
	dvb_channel_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*)(GeeIterable*)) dvb_channel_list_real_iterator;
	iface->get_element_type = dvb_channel_list_real_get_element_type;
}


static void dvb_channel_list_dvb_id_bus_channel_list_interface_init (DVBIDBusChannelListIface * iface) {
	dvb_channel_list_dvb_id_bus_channel_list_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetChannels = (guint* (*)(DVBIDBusChannelList* ,int* ,GError**)) dvb_channel_list_real_GetChannels;
	iface->GetRadioChannels = (guint* (*)(DVBIDBusChannelList* ,int* ,GError**)) dvb_channel_list_real_GetRadioChannels;
	iface->GetTVChannels = (guint* (*)(DVBIDBusChannelList* ,int* ,GError**)) dvb_channel_list_real_GetTVChannels;
	iface->GetChannelName = (gboolean (*)(DVBIDBusChannelList* ,guint ,gchar** ,GError**)) dvb_channel_list_real_GetChannelName;
	iface->GetChannelNetwork = (gboolean (*)(DVBIDBusChannelList* ,guint ,gchar** ,GError**)) dvb_channel_list_real_GetChannelNetwork;
	iface->IsRadioChannel = (gboolean (*)(DVBIDBusChannelList* ,guint ,gboolean* ,GError**)) dvb_channel_list_real_IsRadioChannel;
	iface->GetChannelURL = (gboolean (*)(DVBIDBusChannelList* ,guint ,gchar** ,GError**)) dvb_channel_list_real_GetChannelURL;
	iface->GetChannelInfos = (DVBChannelInfo* (*)(DVBIDBusChannelList* ,int* ,GError**)) dvb_channel_list_real_GetChannelInfos;
	iface->GetChannelsOfGroup = (gboolean (*)(DVBIDBusChannelList* ,gint ,guint** ,int* ,GError**)) dvb_channel_list_real_GetChannelsOfGroup;
	iface->AddChannelToGroup = (gboolean (*)(DVBIDBusChannelList* ,guint ,gint ,GError**)) dvb_channel_list_real_AddChannelToGroup;
	iface->RemoveChannelFromGroup = (gboolean (*)(DVBIDBusChannelList* ,guint ,gint ,GError**)) dvb_channel_list_real_RemoveChannelFromGroup;
}


static void dvb_channel_list_instance_init (DVBChannelList * self) {
	self->priv = DVB_CHANNEL_LIST_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_channels);
}


static void dvb_channel_list_finalize (GObject* obj) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (obj);
	_g_object_unref0 (self->priv->_channels_file);
	g_static_rec_mutex_free (&self->priv->__lock_channels);
	_g_object_unref0 (self->channels);
	G_OBJECT_CLASS (dvb_channel_list_parent_class)->finalize (obj);
}


GType dvb_channel_list_get_type (void) {
	static volatile gsize dvb_channel_list_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_channel_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelList), 0, (GInstanceInitFunc) dvb_channel_list_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) dvb_channel_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dvb_id_bus_channel_list_info = { (GInterfaceInitFunc) dvb_channel_list_dvb_id_bus_channel_list_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_channel_list_type_id;
		dvb_channel_list_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelList", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_channel_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (dvb_channel_list_type_id, DVB_TYPE_ID_BUS_CHANNEL_LIST, &dvb_id_bus_channel_list_info);
		g_once_init_leave (&dvb_channel_list_type_id__volatile, dvb_channel_list_type_id);
	}
	return dvb_channel_list_type_id__volatile;
}


static void _vala_dvb_channel_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		g_value_set_object (value, dvb_channel_list_get_channels_file (self));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		g_value_set_uint (value, dvb_channel_list_get_GroupId (self));
		break;
		case DVB_CHANNEL_LIST_SIZE:
		g_value_set_int (value, dvb_channel_list_get_size (self));
		break;
		case DVB_CHANNEL_LIST_ELEMENT_TYPE:
		g_value_set_gtype (value, gee_iterable_get_element_type ((GeeIterable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_channel_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelList * self;
	self = DVB_CHANNEL_LIST (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_CHANNELS_FILE:
		dvb_channel_list_set_channels_file (self, g_value_get_object (value));
		break;
		case DVB_CHANNEL_LIST_GROUP_ID:
		dvb_channel_list_set_GroupId (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



