/* EPGScanner.c generated by valac, the Vala compiler
 * generated from EPGScanner.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cstuff.h>


#define DVB_TYPE_EPG_SCANNER (dvb_epg_scanner_get_type ())
#define DVB_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScanner))
#define DVB_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))
#define DVB_IS_EPG_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EPG_SCANNER))
#define DVB_IS_EPG_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EPG_SCANNER))
#define DVB_EPG_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EPG_SCANNER, DVBEPGScannerClass))

typedef struct _DVBEPGScanner DVBEPGScanner;
typedef struct _DVBEPGScannerClass DVBEPGScannerClass;
typedef struct _DVBEPGScannerPrivate DVBEPGScannerPrivate;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DVB_TYPE_SETTINGS (dvb_settings_get_type ())
#define DVB_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SETTINGS, DVBSettings))
#define DVB_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SETTINGS, DVBSettingsClass))
#define DVB_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SETTINGS))
#define DVB_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SETTINGS))
#define DVB_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SETTINGS, DVBSettingsClass))

typedef struct _DVBSettings DVBSettings;
typedef struct _DVBSettingsClass DVBSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_SCHEDULE (dvb_schedule_get_type ())
#define DVB_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCHEDULE, DVBSchedule))
#define DVB_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCHEDULE, DVBScheduleClass))
#define DVB_IS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCHEDULE))
#define DVB_IS_SCHEDULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCHEDULE))
#define DVB_SCHEDULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCHEDULE, DVBScheduleClass))

typedef struct _DVBSchedule DVBSchedule;
typedef struct _DVBScheduleClass DVBScheduleClass;
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))

struct _DVBEPGScanner {
	GObject parent_instance;
	DVBEPGScannerPrivate * priv;
};

struct _DVBEPGScannerClass {
	GObjectClass parent_class;
};

struct _DVBEPGScannerPrivate {
	DVBDeviceGroup* DeviceGroup;
	GstElement* pipeline;
	GStaticRecMutex __lock_pipeline;
	GQueue* channels;
	GSource* scan_source;
	GSource* queue_source;
	gint stop_counter;
	GMainContext* context;
	GMainLoop* loop;
	GThread* worker_thread;
	guint bus_watch_id;
	GeeHashMap* channel_events;
	GStaticRecMutex __lock_channel_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	char* name;
	char* description;
	char* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gint dvb_epg_scanner_CHECK_EIT_INTERVAL;
static gint dvb_epg_scanner_CHECK_EIT_INTERVAL = 0;
static gpointer dvb_epg_scanner_parent_class = NULL;

GType dvb_epg_scanner_get_type (void);
GType dvb_device_group_get_type (void);
GType dvb_channel_get_type (void);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void);
#define DVB_EPG_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EPG_SCANNER, DVBEPGScannerPrivate))
enum  {
	DVB_EPG_SCANNER_DUMMY_PROPERTY
};
#define DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION 10
#define DVB_EPG_SCANNER_PIPELINE_TEMPLATE "dvbsrc name=dvbsrc adapter=%u frontend=%u pids=0:16:17:18 stats-report" \
"ing-interval=0 ! mpegtsparse ! fakesink silent=true"
GType dvb_settings_get_type (void);
DVBSettings* dvb_factory_get_settings (void);
gint dvb_settings_get_integer (DVBSettings* self, const char* group_name, const char* key, GError** error);
#define DVB_SETTINGS_EPG_SECTION "epg"
#define DVB_SETTINGS_SCAN_INTERVAL "scan_interval"
DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device);
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self);
static void dvb_epg_scanner_reset (DVBEPGScanner* self);
void dvb_epg_scanner_stop (DVBEPGScanner* self);
static void* dvb_epg_scanner_worker (DVBEPGScanner* self);
static void* _dvb_epg_scanner_worker_gthread_func (gpointer self);
GType dvb_channel_list_get_type (void);
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
GType dvb_device_get_type (void);
DVBDevice* dvb_device_group_get_next_free_device (DVBDeviceGroup* self);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message);
static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self);
static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self);
gboolean dvb_epg_scanner_start (DVBEPGScanner* self);
DVBChannel* dvb_channel_list_get_channel (DVBChannelList* self, guint sid);
const char* dvb_channel_get_Name (DVBChannel* self);
GType dvb_schedule_get_type (void);
DVBSchedule* dvb_channel_get_Schedule (DVBChannel* self);
void dvb_schedule_add_all (DVBSchedule* self, GeeCollection* new_events);
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self);
void dvb_schedule_remove_expired_events (DVBSchedule* self);
void dvb_channel_setup_dvb_source (DVBChannel* self, GstElement* source);
void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const char* name);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void);
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void);
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void);
gboolean dvb_event_has_expired (DVBEvent* self);
guint dvb_event_hash (DVBEvent* event);
static guint _dvb_event_hash_ghash_func (void* key);
gboolean dvb_event_equal (DVBEvent* event1, DVBEvent* event2);
static gboolean _dvb_event_equal_gequal_func (void* a, void* b);
static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void dvb_epg_scanner_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device) {
	GError * _inner_error_;
	DVBEPGScanner * self;
	g_return_val_if_fail (device != NULL, NULL);
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	self->priv->DeviceGroup = device;
	if (dvb_epg_scanner_CHECK_EIT_INTERVAL == (-1)) {
		DVBSettings* settings;
		settings = dvb_factory_get_settings ();
		{
			gint _tmp0_;
			_tmp0_ = dvb_settings_get_integer (settings, DVB_SETTINGS_EPG_SECTION, DVB_SETTINGS_SCAN_INTERVAL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch60_g_key_file_error;
				}
				_g_object_unref0 (settings);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			dvb_epg_scanner_CHECK_EIT_INTERVAL = _tmp0_ * 60;
		}
		goto __finally60;
		__catch60_g_key_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("EPGScanner.vala:68: %s", e->message);
				dvb_epg_scanner_CHECK_EIT_INTERVAL = 15 * 60;
				_g_error_free0 (e);
			}
		}
		__finally60:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (settings);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (settings);
	}
	return self;
}


DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device) {
	return dvb_epg_scanner_construct (DVB_TYPE_EPG_SCANNER, device);
}


void dvb_epg_scanner_stop (DVBEPGScanner* self) {
	g_return_if_fail (self != NULL);
	g_debug ("EPGScanner.vala:78: Stopping EPG scan for group %u (%d)", dvb_device_group_get_Id (self->priv->DeviceGroup), self->priv->stop_counter);
	if (self->priv->stop_counter == 0) {
		dvb_epg_scanner_remove_timeouts (self);
		dvb_epg_scanner_reset (self);
	}
	self->priv->stop_counter = self->priv->stop_counter + 1;
}


static void dvb_epg_scanner_remove_timeouts (DVBEPGScanner* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->scan_source != NULL) {
		GSource* _tmp0_;
		g_source_destroy (self->priv->scan_source);
		self->priv->scan_source = (_tmp0_ = NULL, _g_source_unref0 (self->priv->scan_source), _tmp0_);
	}
	if (self->priv->queue_source != NULL) {
		GSource* _tmp1_;
		g_source_destroy (self->priv->queue_source);
		self->priv->queue_source = (_tmp1_ = NULL, _g_source_unref0 (self->priv->queue_source), _tmp1_);
	}
	if (self->priv->loop != NULL) {
		GMainLoop* _tmp2_;
		g_main_loop_quit (self->priv->loop);
		self->priv->loop = (_tmp2_ = NULL, _g_main_loop_unref0 (self->priv->loop), _tmp2_);
		g_thread_join (self->priv->worker_thread);
		self->priv->worker_thread = NULL;
	}
}


static void* dvb_epg_scanner_worker (DVBEPGScanner* self) {
	void* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_main_loop_run (self->priv->loop);
	result = NULL;
	return result;
}


static gpointer _g_source_ref0 (gpointer self) {
	return self ? g_source_ref (self) : NULL;
}


static void dvb_epg_scanner_reset (DVBEPGScanner* self) {
	GError * _inner_error_;
	DVBChannel* c;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			if (self->priv->pipeline != NULL) {
				GSource* bus_watch_source;
				GstElement* _tmp0_;
				bus_watch_source = _g_source_ref0 (g_main_context_find_source_by_id (self->priv->context, self->priv->bus_watch_id));
				if (bus_watch_source != NULL) {
					g_source_destroy (bus_watch_source);
					self->priv->bus_watch_id = (guint) 0;
				}
				gst_element_set_state (self->priv->pipeline, GST_STATE_NULL);
				gst_element_get_state (self->priv->pipeline, NULL, NULL, (GstClockTime) (-1));
				self->priv->pipeline = (_tmp0_ = NULL, _gst_object_unref0 (self->priv->pipeline), _tmp0_);
				_g_source_unref0 (bus_watch_source);
			}
		}
		__finally61:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	c = NULL;
	while (TRUE) {
		DVBChannel* _tmp1_;
		if (!((c = (_tmp1_ = (DVBChannel*) g_queue_pop_head (self->priv->channels), _g_object_unref0 (c), _tmp1_)) != NULL)) {
			break;
		}
	}
	g_queue_clear (self->priv->channels);
	gee_abstract_map_clear ((GeeAbstractMap*) self->priv->channel_events);
	_g_object_unref0 (c);
}


static void* _dvb_epg_scanner_worker_gthread_func (gpointer self) {
	return dvb_epg_scanner_worker (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _dvb_epg_scanner_bus_watch_func_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	return dvb_epg_scanner_bus_watch_func (self, bus, message);
}


static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self) {
	return dvb_epg_scanner_scan_new_frequency (self);
}


gboolean dvb_epg_scanner_start (DVBEPGScanner* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	GMainLoop* _tmp0_;
	DVBDevice* device;
	GSource* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	g_debug ("EPGScanner.vala:140: Starting EPG scan for group %u (%d)", dvb_device_group_get_Id (self->priv->DeviceGroup), self->priv->stop_counter);
	self->priv->loop = (_tmp0_ = g_main_loop_new (self->priv->context, FALSE), _g_main_loop_unref0 (self->priv->loop), _tmp0_);
	{
		GThread* _tmp1_;
		_tmp1_ = g_thread_create (_dvb_epg_scanner_worker_gthread_func, self, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch62_g_error;
		}
		self->priv->worker_thread = _tmp1_;
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("EPGScanner.vala:146: Could not create thread: %s", e->message);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally62:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	self->priv->stop_counter = self->priv->stop_counter - 1;
	if (self->priv->stop_counter > 0) {
		result = FALSE;
		return result;
	}
	self->priv->stop_counter = 0;
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) dvb_device_group_get_Channels (self->priv->DeviceGroup));
		while (TRUE) {
			DVBChannel* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (DVBChannel*) gee_iterator_get (_c_it);
			g_queue_push_tail (self->priv->channels, _g_object_ref0 (c));
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_it);
	}
	device = dvb_device_group_get_next_free_device (self->priv->DeviceGroup);
	if (device == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	{
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstBus* bus;
			{
				char* _tmp2_;
				GstElement* _tmp3_;
				GstElement* _tmp4_;
				GstElement* _tmp5_;
				_tmp4_ = (_tmp3_ = gst_parse_launch (_tmp2_ = g_strdup_printf (DVB_EPG_SCANNER_PIPELINE_TEMPLATE, dvb_device_get_Adapter (device), dvb_device_get_Frontend (device)), &_inner_error_), _g_free0 (_tmp2_), _tmp3_);
				if (_inner_error_ != NULL) {
					goto __catch64_g_error;
				}
				self->priv->pipeline = (_tmp5_ = _tmp4_, _gst_object_unref0 (self->priv->pipeline), _tmp5_);
			}
			goto __finally64;
			__catch64_g_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					g_error ("EPGScanner.vala:166: Could not create pipeline: %s", e->message);
					result = FALSE;
					_g_error_free0 (e);
					{
						g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
					}
					_g_object_unref0 (device);
					return result;
				}
			}
			__finally64:
			if (_inner_error_ != NULL) {
				{
					g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
				}
				_g_object_unref0 (device);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			bus = gst_element_get_bus (self->priv->pipeline);
			self->priv->bus_watch_id = gst_bus_add_watch_context (bus, _dvb_epg_scanner_bus_watch_func_gst_bus_func, self, self->priv->context);
			_gst_object_unref0 (bus);
		}
		__finally63:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	self->priv->scan_source = (_tmp6_ = g_timeout_source_new_seconds ((guint) DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION), _g_source_unref0 (self->priv->scan_source), _tmp6_);
	g_source_set_callback (self->priv->scan_source, _dvb_epg_scanner_scan_new_frequency_gsource_func, g_object_ref (self), g_object_unref);
	g_source_attach (self->priv->scan_source, self->priv->context);
	result = FALSE;
	_g_object_unref0 (device);
	return result;
}


static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self) {
	return dvb_epg_scanner_start (self);
}


static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	DVBChannel* channel;
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			{
				GeeSet* _tmp0_;
				GeeIterator* _tmp1_;
				GeeIterator* _sid_it;
				_sid_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = gee_map_get_keys ((GeeMap*) self->priv->channel_events))), _g_object_unref0 (_tmp0_), _tmp1_);
				while (TRUE) {
					guint sid;
					DVBChannel* channel;
					GeeHashSet* list;
					if (!gee_iterator_next (_sid_it)) {
						break;
					}
					sid = GPOINTER_TO_UINT (gee_iterator_get (_sid_it));
					channel = dvb_channel_list_get_channel (dvb_device_group_get_Channels (self->priv->DeviceGroup), sid);
					if (channel == NULL) {
						g_warning ("EPGScanner.vala:190: Could not find channel %u for this device", sid);
						_g_object_unref0 (channel);
						continue;
					}
					list = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->channel_events, GUINT_TO_POINTER (sid));
					g_debug ("EPGScanner.vala:195: Adding %d events of channel %s (%u)", gee_collection_get_size ((GeeCollection*) list), dvb_channel_get_Name (channel), sid);
					dvb_schedule_add_all (dvb_channel_get_Schedule (channel), (GeeCollection*) list);
					_g_object_unref0 (channel);
					_g_object_unref0 (list);
				}
				_g_object_unref0 (_sid_it);
			}
			gee_abstract_map_clear ((GeeAbstractMap*) self->priv->channel_events);
		}
		__finally65:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (g_queue_is_empty (self->priv->channels)) {
		GSource* _tmp2_;
		g_debug ("EPGScanner.vala:203: Finished EPG scan for group %u", dvb_device_group_get_Id (self->priv->DeviceGroup));
		dvb_epg_scanner_reset (self);
		self->priv->queue_source = (_tmp2_ = g_timeout_source_new_seconds ((guint) dvb_epg_scanner_CHECK_EIT_INTERVAL), _g_source_unref0 (self->priv->queue_source), _tmp2_);
		g_source_set_callback (self->priv->queue_source, _dvb_epg_scanner_start_gsource_func, g_object_ref (self), g_object_unref);
		g_source_attach (self->priv->queue_source, self->priv->context);
		result = FALSE;
		return result;
	}
	channel = (DVBChannel*) g_queue_pop_head (self->priv->channels);
	dvb_schedule_remove_expired_events (dvb_channel_get_Schedule (channel));
	{
		g_static_rec_mutex_lock (&self->priv->__lock_pipeline);
		{
			GstElement* dvbsrc;
			gst_element_set_state (self->priv->pipeline, GST_STATE_READY);
			dvbsrc = gst_bin_get_by_name (GST_BIN (self->priv->pipeline), "dvbsrc");
			dvb_channel_setup_dvb_source (channel, dvbsrc);
			gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
			_gst_object_unref0 (dvbsrc);
		}
		__finally66:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_pipeline);
		}
		if (_inner_error_ != NULL) {
			_g_object_unref0 (channel);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_object_unref0 (channel);
	return result;
}


static gboolean dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_ELEMENT:
		{
			if (_vala_strcmp0 (gst_structure_get_name (message->structure), "dvb-read-failure") == 0) {
				g_critical ("EPGScanner.vala:234: Could not read from DVB device");
				dvb_epg_scanner_stop (self);
			} else {
				if (_vala_strcmp0 (gst_structure_get_name (message->structure), "eit") == 0) {
					dvb_epg_scanner_on_eit_structure (self, message->structure);
				}
			}
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			GError* gerror;
			char* debug;
			char* _tmp3_;
			char* _tmp2_ = NULL;
			GError* _tmp1_;
			GError* _tmp0_ = NULL;
			gerror = NULL;
			debug = NULL;
			(gst_message_parse_error (message, &_tmp0_, &_tmp2_), gerror = (_tmp1_ = _tmp0_, _g_error_free0 (gerror), _tmp1_));
			debug = (_tmp3_ = _tmp2_, _g_free0 (debug), _tmp3_);
			g_critical ("EPGScanner.vala:245: %s %s", gerror->message, debug);
			dvb_epg_scanner_stop (self);
			result = FALSE;
			_g_error_free0 (gerror);
			_g_free0 (debug);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}


static guint _dvb_event_hash_ghash_func (void* key) {
	return dvb_event_hash (key);
}


static gboolean _dvb_event_equal_gequal_func (void* a, void* b) {
	return dvb_event_equal (a, b);
}


void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure) {
	GError * _inner_error_;
	GValue events;
	guint size;
	GValue val = {0};
	const GstStructure* event;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_inner_error_ = NULL;
	events = *gst_structure_get_value (structure, "events");
	if (!G_VALUE_HOLDS (&events, gst_value_list_get_type ())) {
		return;
	}
	size = gst_value_list_get_size (&events);
	event = NULL;
	{
		g_static_rec_mutex_lock (&self->priv->__lock_channel_events);
		{
			{
				guint i;
				i = (guint) 0;
				{
					gboolean _tmp0_;
					_tmp0_ = TRUE;
					while (TRUE) {
						DVBEvent* event_class;
						char* name;
						gboolean _tmp1_ = FALSE;
						char* desc;
						gboolean _tmp3_ = FALSE;
						char* ext_desc;
						gboolean _tmp5_ = FALSE;
						gboolean free_ca = FALSE;
						guint sid;
						GeeHashSet* list;
						if (!_tmp0_) {
							i++;
						}
						_tmp0_ = FALSE;
						if (!(i < size)) {
							break;
						}
						val = *gst_value_list_get_value (&events, i);
						event = gst_value_get_structure (&val);
						event_class = dvb_event_new ();
						event_class->id = dvb_epg_scanner_get_uint_val (event, "event-id");
						event_class->year = dvb_epg_scanner_get_uint_val (event, "year");
						event_class->month = dvb_epg_scanner_get_uint_val (event, "month");
						event_class->day = dvb_epg_scanner_get_uint_val (event, "day");
						event_class->hour = dvb_epg_scanner_get_uint_val (event, "hour");
						event_class->minute = dvb_epg_scanner_get_uint_val (event, "minute");
						event_class->second = dvb_epg_scanner_get_uint_val (event, "second");
						event_class->duration = dvb_epg_scanner_get_uint_val (event, "duration");
						if (dvb_event_has_expired (event_class)) {
							_dvb_event_unref0 (event_class);
							continue;
						}
						event_class->running_status = dvb_epg_scanner_get_uint_val (event, "running-status");
						name = g_strdup (gst_structure_get_string (event, "name"));
						if (name != NULL) {
							_tmp1_ = g_utf8_validate (name, -1, NULL);
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							char* _tmp2_;
							event_class->name = (_tmp2_ = g_strdup (name), _g_free0 (event_class->name), _tmp2_);
						}
						desc = g_strdup (gst_structure_get_string (event, "description"));
						if (desc != NULL) {
							_tmp3_ = g_utf8_validate (desc, -1, NULL);
						} else {
							_tmp3_ = FALSE;
						}
						if (_tmp3_) {
							char* _tmp4_;
							event_class->description = (_tmp4_ = g_strdup (desc), _g_free0 (event_class->description), _tmp4_);
						}
						ext_desc = g_strdup (gst_structure_get_string (event, "extended-text"));
						if (ext_desc != NULL) {
							_tmp5_ = g_utf8_validate (ext_desc, -1, NULL);
						} else {
							_tmp5_ = FALSE;
						}
						if (_tmp5_) {
							char* _tmp6_;
							event_class->extended_description = (_tmp6_ = g_strdup (ext_desc), _g_free0 (event_class->extended_description), _tmp6_);
						}
						gst_structure_get_boolean (event, "free-ca-mode", &free_ca);
						event_class->free_ca_mode = free_ca;
						sid = dvb_epg_scanner_get_uint_val (structure, "service-id");
						if (!gee_map_contains ((GeeMap*) self->priv->channel_events, GUINT_TO_POINTER (sid))) {
							GeeHashSet* _tmp7_;
							gee_abstract_map_set ((GeeAbstractMap*) self->priv->channel_events, GUINT_TO_POINTER (sid), _tmp7_ = gee_hash_set_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, _dvb_event_hash_ghash_func, _dvb_event_equal_gequal_func));
							_g_object_unref0 (_tmp7_);
						}
						list = (GeeHashSet*) gee_abstract_map_get ((GeeAbstractMap*) self->priv->channel_events, GUINT_TO_POINTER (sid));
						gee_abstract_collection_add ((GeeAbstractCollection*) list, event_class);
						_dvb_event_unref0 (event_class);
						_g_free0 (name);
						_g_free0 (desc);
						_g_free0 (ext_desc);
						_g_object_unref0 (list);
					}
				}
			}
		}
		__finally67:
		{
			g_static_rec_mutex_unlock (&self->priv->__lock_channel_events);
		}
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const char* name) {
	guint result = 0U;
	guint val = 0U;
	g_return_val_if_fail (structure != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	gst_structure_get_uint (structure, name, &val);
	result = val;
	return result;
}


static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBEPGScanner * self;
	parent_class = G_OBJECT_CLASS (dvb_epg_scanner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_EPG_SCANNER (obj);
	{
		GQueue* _tmp0_;
		GMainContext* _tmp1_;
		GeeHashMap* _tmp2_;
		self->priv->channels = (_tmp0_ = g_queue_new (), _g_queue_free0 (self->priv->channels), _tmp0_);
		self->priv->stop_counter = 0;
		self->priv->context = (_tmp1_ = g_main_context_new (), _g_main_context_unref0 (self->priv->context), _tmp1_);
		self->priv->channel_events = (_tmp2_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL), _g_object_unref0 (self->priv->channel_events), _tmp2_);
	}
	return obj;
}


static void dvb_epg_scanner_class_init (DVBEPGScannerClass * klass) {
	dvb_epg_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEPGScannerPrivate));
	G_OBJECT_CLASS (klass)->constructor = dvb_epg_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_epg_scanner_finalize;
	dvb_epg_scanner_CHECK_EIT_INTERVAL = -1;
}


static void dvb_epg_scanner_instance_init (DVBEPGScanner * self) {
	self->priv = DVB_EPG_SCANNER_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock_pipeline);
	g_static_rec_mutex_init (&self->priv->__lock_channel_events);
}


static void dvb_epg_scanner_finalize (GObject* obj) {
	DVBEPGScanner * self;
	self = DVB_EPG_SCANNER (obj);
	g_static_rec_mutex_free (&self->priv->__lock_pipeline);
	_gst_object_unref0 (self->priv->pipeline);
	_g_queue_free0 (self->priv->channels);
	_g_source_unref0 (self->priv->scan_source);
	_g_source_unref0 (self->priv->queue_source);
	_g_main_context_unref0 (self->priv->context);
	_g_main_loop_unref0 (self->priv->loop);
	g_static_rec_mutex_free (&self->priv->__lock_channel_events);
	_g_object_unref0 (self->priv->channel_events);
	G_OBJECT_CLASS (dvb_epg_scanner_parent_class)->finalize (obj);
}


GType dvb_epg_scanner_get_type (void) {
	static volatile gsize dvb_epg_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_epg_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_epg_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEPGScanner), 0, (GInstanceInitFunc) dvb_epg_scanner_instance_init, NULL };
		GType dvb_epg_scanner_type_id;
		dvb_epg_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEPGScanner", &g_define_type_info, 0);
		g_once_init_leave (&dvb_epg_scanner_type_id__volatile, dvb_epg_scanner_type_id);
	}
	return dvb_epg_scanner_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




