/* Device.c generated by valac, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
typedef struct _DVBDevicePrivate DVBDevicePrivate;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

struct _DVBDevice {
	GObject parent_instance;
	DVBDevicePrivate * priv;
};

struct _DVBDeviceClass {
	GObjectClass parent_class;
};

struct _DVBDevicePrivate {
	guint _Adapter;
	guint _Frontend;
	DVBChannelList* _Channels;
	GFile* _RecordingsDirectory;
	char* adapter_name;
	DVBAdapterType adapter_type;
};


static gpointer dvb_device_parent_class = NULL;

GQuark dvb_device_error_quark (void);
GType dvb_adapter_type_get_type (void);
GType dvb_device_get_type (void);
GType dvb_channel_list_get_type (void);
#define DVB_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE, DVBDevicePrivate))
enum  {
	DVB_DEVICE_DUMMY_PROPERTY,
	DVB_DEVICE_ADAPTER,
	DVB_DEVICE_FRONTEND,
	DVB_DEVICE_TYPE,
	DVB_DEVICE_NAME,
	DVB_DEVICE_CHANNELS,
	DVB_DEVICE_RECORDINGS_DIRECTORY
};
#define DVB_DEVICE_PRIME 31
DVBDevice* dvb_device_new (guint adapter, guint frontend);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend);
static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
DVBAdapterType dvb_device_get_Type (DVBDevice* self);
void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value);
DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, guint group_id, GError** error);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
guint dvb_device_hash_without_device (guint adapter, guint frontend);
guint dvb_device_hash (DVBDevice* device);
gboolean dvb_device_is_busy (DVBDevice* self);
static void dvb_device_set_Adapter (DVBDevice* self, guint value);
static void dvb_device_set_Frontend (DVBDevice* self, guint value);
const char* dvb_device_get_Name (DVBDevice* self);
DVBChannelList* dvb_device_get_Channels (DVBDevice* self);
GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self);
static void dvb_device_finalize (GObject* obj);
static void dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark dvb_device_error_quark (void) {
	return g_quark_from_static_string ("dvb_device_error-quark");
}


GType dvb_adapter_type_get_type (void) {
	static volatile gsize dvb_adapter_type_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_adapter_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_ADAPTER_TYPE_UNKNOWN, "DVB_ADAPTER_TYPE_UNKNOWN", "unknown"}, {DVB_ADAPTER_TYPE_DVB_T, "DVB_ADAPTER_TYPE_DVB_T", "dvb-t"}, {DVB_ADAPTER_TYPE_DVB_S, "DVB_ADAPTER_TYPE_DVB_S", "dvb-s"}, {DVB_ADAPTER_TYPE_DVB_C, "DVB_ADAPTER_TYPE_DVB_C", "dvb-c"}, {0, NULL, NULL}};
		GType dvb_adapter_type_type_id;
		dvb_adapter_type_type_id = g_enum_register_static ("DVBAdapterType", values);
		g_once_init_leave (&dvb_adapter_type_type_id__volatile, dvb_adapter_type_type_id);
	}
	return dvb_adapter_type_type_id__volatile;
}


DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend) {
	DVBDevice * self;
	self = (DVBDevice*) g_object_new (object_type, "Adapter", adapter, "Frontend", frontend, NULL);
	return self;
}


DVBDevice* dvb_device_new (guint adapter, guint frontend) {
	return dvb_device_construct (DVB_TYPE_DEVICE, adapter, frontend);
}


DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend) {
	DVBDevice* result = NULL;
	DVBDevice* device;
	device = dvb_device_new (adapter, frontend);
	dvb_device_setAdapterTypeAndName (device, adapter, frontend);
	result = device;
	return result;
}


DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, guint group_id, GError** error) {
	DVBDevice* result = NULL;
	GError * _inner_error_;
	DVBDevice* device;
	DVBChannelList* _tmp0_;
	g_return_val_if_fail (channels_conf != NULL, NULL);
	g_return_val_if_fail (recordings_dir != NULL, NULL);
	_inner_error_ = NULL;
	device = dvb_device_new_with_type (adapter, frontend);
	if (dvb_device_get_Type (device) == DVB_ADAPTER_TYPE_UNKNOWN) {
		_inner_error_ = g_error_new (DVB_DEVICE_ERROR, DVB_DEVICE_ERROR_UNKNOWN_TYPE, "device %u,%u has unknown type", adapter, frontend);
		{
			if (_inner_error_->domain == DVB_DEVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (device);
				return NULL;
			} else {
				_g_object_unref0 (device);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	dvb_device_set_RecordingsDirectory (device, recordings_dir);
	dvb_device_set_Channels (device, _tmp0_ = dvb_channel_list_new (channels_conf));
	_g_object_unref0 (_tmp0_);
	result = device;
	return result;
}


gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (dev1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = dev2 == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (dev1->priv->_Adapter == dev2->priv->_Adapter) {
		_tmp1_ = dev2->priv->_Frontend == dev2->priv->_Frontend;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}


guint dvb_device_hash (DVBDevice* device) {
	guint result = 0U;
	if (device == NULL) {
		result = (guint) 0;
		return result;
	}
	result = dvb_device_hash_without_device (device->priv->_Adapter, device->priv->_Frontend);
	return result;
}


guint dvb_device_hash_without_device (guint adapter, guint frontend) {
	guint result = 0U;
	result = ((2 * DVB_DEVICE_PRIME) + (DVB_DEVICE_PRIME * adapter)) + frontend;
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


gboolean dvb_device_is_busy (DVBDevice* self) {
	gboolean result = FALSE;
	GstElement* dvbsrc;
	GstElement* pipeline;
	GstBus* bus;
	gboolean busy_val;
	g_return_val_if_fail (self != NULL, FALSE);
	dvbsrc = gst_element_factory_make ("dvbsrc", "text_dvbsrc");
	if (dvbsrc == NULL) {
		g_critical ("Device.vala:106: Could not create dvbsrc element");
		result = TRUE;
		_gst_object_unref0 (dvbsrc);
		return result;
	}
	g_object_set ((GObject*) dvbsrc, "adapter", self->priv->_Adapter, NULL);
	g_object_set ((GObject*) dvbsrc, "frontend", self->priv->_Frontend, NULL);
	pipeline = (GstElement*) ((GstPipeline*) gst_pipeline_new (""));
	gst_bin_add (GST_BIN (pipeline), _gst_object_ref0 (dvbsrc));
	gst_element_set_state (pipeline, GST_STATE_READY);
	bus = gst_element_get_bus (pipeline);
	busy_val = FALSE;
	while (TRUE) {
		GstMessage* msg;
		gboolean _tmp0_ = FALSE;
		if (!gst_bus_have_pending (bus)) {
			break;
		}
		msg = gst_bus_pop (bus);
		if (msg->type == GST_MESSAGE_ERROR) {
			_tmp0_ = msg->src == GST_OBJECT (dvbsrc);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GError* gerror;
			char* debug_text;
			char* _tmp4_;
			char* _tmp3_ = NULL;
			GError* _tmp2_;
			GError* _tmp1_ = NULL;
			gerror = NULL;
			debug_text = NULL;
			(gst_message_parse_error (msg, &_tmp1_, &_tmp3_), gerror = (_tmp2_ = _tmp1_, _g_error_free0 (gerror), _tmp2_));
			debug_text = (_tmp4_ = _tmp3_, _g_free0 (debug_text), _tmp4_);
			g_debug ("Device.vala:128: Error tuning: %s; %s", gerror->message, debug_text);
			busy_val = TRUE;
			_g_error_free0 (gerror);
			_g_free0 (debug_text);
		}
		_gst_message_unref0 (msg);
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	result = busy_val;
	_gst_object_unref0 (dvbsrc);
	_gst_object_unref0 (pipeline);
	_gst_object_unref0 (bus);
	return result;
}


static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend) {
	gboolean result = FALSE;
	GstElement* dvbsrc;
	GstElement* pipeline;
	GstBus* bus;
	gboolean success;
	char* adapter_type;
	g_return_val_if_fail (self != NULL, FALSE);
	dvbsrc = gst_element_factory_make ("dvbsrc", "test_dvbsrc");
	if (dvbsrc == NULL) {
		g_critical ("Device.vala:142: Could not create dvbsrc element");
		result = FALSE;
		_gst_object_unref0 (dvbsrc);
		return result;
	}
	g_object_set ((GObject*) dvbsrc, "adapter", adapter, NULL);
	g_object_set ((GObject*) dvbsrc, "frontend", frontend, NULL);
	pipeline = (GstElement*) ((GstPipeline*) gst_pipeline_new ("type_name"));
	gst_bin_add (GST_BIN (pipeline), _gst_object_ref0 (dvbsrc));
	gst_element_set_state (pipeline, GST_STATE_READY);
	bus = gst_element_get_bus (pipeline);
	success = FALSE;
	adapter_type = NULL;
	while (TRUE) {
		GstMessage* msg;
		gboolean _tmp0_ = FALSE;
		if (!gst_bus_have_pending (bus)) {
			break;
		}
		msg = gst_bus_pop (bus);
		if (msg->type == GST_MESSAGE_ELEMENT) {
			_tmp0_ = msg->src == GST_OBJECT (dvbsrc);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			const GstStructure* structure;
			structure = msg->structure;
			if (_vala_strcmp0 (gst_structure_get_name (structure), "dvb-adapter") == 0) {
				char* _tmp1_;
				char* _tmp2_;
				adapter_type = (_tmp1_ = g_strdup_printf ("%s", gst_structure_get_string (structure, "type")), _g_free0 (adapter_type), _tmp1_);
				self->priv->adapter_name = (_tmp2_ = g_strdup_printf ("%s", gst_structure_get_string (structure, "name")), _g_free0 (self->priv->adapter_name), _tmp2_);
				success = TRUE;
				_gst_message_unref0 (msg);
				break;
			}
		} else {
			if (msg->type == GST_MESSAGE_ERROR) {
				GError* gerror;
				char* debug;
				char* _tmp6_;
				char* _tmp5_ = NULL;
				GError* _tmp4_;
				GError* _tmp3_ = NULL;
				gerror = NULL;
				debug = NULL;
				(gst_message_parse_error (msg, &_tmp3_, &_tmp5_), gerror = (_tmp4_ = _tmp3_, _g_error_free0 (gerror), _tmp4_));
				debug = (_tmp6_ = _tmp5_, _g_free0 (debug), _tmp6_);
				g_critical ("Device.vala:173: %s %s", gerror->message, debug);
				_g_error_free0 (gerror);
				_g_free0 (debug);
			}
		}
		_gst_message_unref0 (msg);
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	if (_vala_strcmp0 (adapter_type, "DVB-T") == 0) {
		self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_T;
	} else {
		if (_vala_strcmp0 (adapter_type, "DVB-S") == 0) {
			self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_S;
		} else {
			if (_vala_strcmp0 (adapter_type, "DVB-C") == 0) {
				self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_C;
			} else {
				self->priv->adapter_type = DVB_ADAPTER_TYPE_UNKNOWN;
			}
		}
	}
	result = success;
	_gst_object_unref0 (dvbsrc);
	_gst_object_unref0 (pipeline);
	_gst_object_unref0 (bus);
	_g_free0 (adapter_type);
	return result;
}


guint dvb_device_get_Adapter (DVBDevice* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Adapter;
	return result;
}


static void dvb_device_set_Adapter (DVBDevice* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Adapter = value;
	g_object_notify ((GObject *) self, "Adapter");
}


guint dvb_device_get_Frontend (DVBDevice* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Frontend;
	return result;
}


static void dvb_device_set_Frontend (DVBDevice* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frontend = value;
	g_object_notify ((GObject *) self, "Frontend");
}


DVBAdapterType dvb_device_get_Type (DVBDevice* self) {
	DVBAdapterType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->adapter_type;
	return result;
}


const char* dvb_device_get_Name (DVBDevice* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->adapter_name;
	return result;
}


DVBChannelList* dvb_device_get_Channels (DVBDevice* self) {
	DVBChannelList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Channels;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value) {
	DVBChannelList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_Channels = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_Channels), _tmp0_);
	g_object_notify ((GObject *) self, "Channels");
}


GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_RecordingsDirectory;
	return result;
}


void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_RecordingsDirectory = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_RecordingsDirectory), _tmp0_);
	g_object_notify ((GObject *) self, "RecordingsDirectory");
}


static void dvb_device_class_init (DVBDeviceClass * klass) {
	dvb_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_ADAPTER, g_param_spec_uint ("Adapter", "Adapter", "Adapter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_FRONTEND, g_param_spec_uint ("Frontend", "Frontend", "Frontend", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_RECORDINGS_DIRECTORY, g_param_spec_object ("RecordingsDirectory", "RecordingsDirectory", "RecordingsDirectory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_device_instance_init (DVBDevice * self) {
	self->priv = DVB_DEVICE_GET_PRIVATE (self);
}


static void dvb_device_finalize (GObject* obj) {
	DVBDevice * self;
	self = DVB_DEVICE (obj);
	_g_object_unref0 (self->priv->_Channels);
	_g_object_unref0 (self->priv->_RecordingsDirectory);
	_g_free0 (self->priv->adapter_name);
	G_OBJECT_CLASS (dvb_device_parent_class)->finalize (obj);
}


GType dvb_device_get_type (void) {
	static volatile gsize dvb_device_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDevice), 0, (GInstanceInitFunc) dvb_device_instance_init, NULL };
		GType dvb_device_type_id;
		dvb_device_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDevice", &g_define_type_info, 0);
		g_once_init_leave (&dvb_device_type_id__volatile, dvb_device_type_id);
	}
	return dvb_device_type_id__volatile;
}


static void dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		g_value_set_uint (value, dvb_device_get_Adapter (self));
		break;
		case DVB_DEVICE_FRONTEND:
		g_value_set_uint (value, dvb_device_get_Frontend (self));
		break;
		case DVB_DEVICE_TYPE:
		g_value_set_enum (value, dvb_device_get_Type (self));
		break;
		case DVB_DEVICE_NAME:
		g_value_set_string (value, dvb_device_get_Name (self));
		break;
		case DVB_DEVICE_CHANNELS:
		g_value_set_object (value, dvb_device_get_Channels (self));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		g_value_set_object (value, dvb_device_get_RecordingsDirectory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		dvb_device_set_Adapter (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_FRONTEND:
		dvb_device_set_Frontend (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_CHANNELS:
		dvb_device_set_Channels (self, g_value_get_object (value));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		dvb_device_set_RecordingsDirectory (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




