/**
 * vim: sw=4 ts=4:
 *
 * Appetite pixbuf loader
 *
 * 	(C) 2003-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#include <gtk/gtkicontheme.h>

#include "gaptpixbuf.h"

#include "pixmaps/section.xpm"
#include "pixmaps/package.xpm"
#include "pixmaps/depends.xpm"
#include "pixmaps/recommends.xpm"
#include "pixmaps/suggests.xpm"
#include "pixmaps/replaces.xpm"
#include "pixmaps/conflicts.xpm"

#define ICON_SIZE_HINT 16

static const gchar** pixmaps[GAPT_PIXBUF_UNKNOWN] = {
	[GAPT_PIXBUF_SECTION] = (const gchar**) (section_xpm),
	[GAPT_PIXBUF_PACKAGE] = (const gchar**) (package_xpm),
	[GAPT_PIXBUF_DEPENDS] = (const gchar**) (depends_xpm),
	[GAPT_PIXBUF_RECOMMENDS] = (const gchar**) (recommends_xpm),
	[GAPT_PIXBUF_SUGGESTS] = (const gchar**) (suggests_xpm),
	[GAPT_PIXBUF_REPLACES] = (const gchar**) (replaces_xpm),
	[GAPT_PIXBUF_CONFLICTS] = (const gchar**) (conflicts_xpm)
};

static const gchar* icons[GAPT_PIXBUF_UNKNOWN] = {
	[GAPT_PIXBUF_SECTION] = "gnome-fs-directory",
	[GAPT_PIXBUF_PACKAGE] = "gnome-mime-application-x-deb"
};

static void gapt_pixbuf_class_init (GAptPixbufClass*);
static void gapt_pixbuf_init (GAptPixbuf*);
static GdkPixbuf* gapt_pixbuf_lookup_icon (const gchar*);

#ifndef ga_debug
#define ga_debug(format, args...)
#endif

GType
gapt_pixbuf_get_type (void) {
	static GType gpb_type;

	if (!gpb_type) {
		static const GTypeInfo gpb_info = {
			sizeof (GAptPixbufClass), NULL, NULL,
			(GClassInitFunc) gapt_pixbuf_class_init,
			NULL, NULL, sizeof (GAptPixbuf), 0,
			(GInstanceInitFunc) gapt_pixbuf_init
		};

		gpb_type = g_type_register_static (GDK_TYPE_PIXBUF, "GAptPixbuf", &gpb_info, (GTypeFlags) 0);
	}
	return gpb_type;
}

static void
gapt_pixbuf_class_init (GAptPixbufClass* klass) {
	/* Nothing to do */
}

static void
gapt_pixbuf_init (GAptPixbuf* gpb) {
	/* Nothing to do */
}

GdkPixbuf*
gapt_pixbuf_new (GAptPixbufType pbt) {
	if (pbt >= GAPT_PIXBUF_UNKNOWN) {
		g_warning ("Unknown GAptPixbufType in %s", __FUNCTION__);
		return NULL;
	}

	GdkPixbuf* icon = NULL;

	icon = gapt_pixbuf_lookup_icon (icons[pbt]);

	/* fallback */
/* FIXME: use png icons */
	if (!icon) {
		ga_debug ("failed to load theme icon for %s, falling back", icons[pbt]);
		icon = gdk_pixbuf_new_from_xpm_data (pixmaps[pbt]);
	}

	if (!icon) g_warning ("Pixbuf creation failed, %s", __FUNCTION__);
	return icon;
}

static GdkPixbuf*
gapt_pixbuf_lookup_icon (const gchar* name) {
	GdkPixbuf* pixbuf;
	static GtkIconTheme* theme;

	if (!name) {
		return NULL;
	}

	if (!theme) {
		theme = gtk_icon_theme_get_default();
	}

	ga_debug ("looking up icon for %s", name);
	pixbuf = gtk_icon_theme_load_icon (theme, name, ICON_SIZE_HINT, GTK_ICON_LOOKUP_USE_BUILTIN, NULL);
	ga_debug ("loaded pixbuf");

	if (pixbuf) {
		GdkPixbuf* tmp = gdk_pixbuf_scale_simple (pixbuf, ICON_SIZE_HINT, ICON_SIZE_HINT, GDK_INTERP_HYPER);
		g_object_unref (pixbuf);
		pixbuf = tmp;
	}

	return pixbuf;
}
