#!/usr/bin/env perl

## If the following is set to true, the menus will look like
##    Ada -> Strings -> Fixed
## Otherwise, they are   Ada -> Ada.Strings.Fixed

$expand_hierarchies = 1;

$output ="../share/plug-ins/runtime.xml";
$impunit="../gnatlib/gnat_src/impunit.adb";

open (OUT, '>' . $output);
open (IMPUNIT, $impunit);

print OUT "<?xml version=\"1.0\" ?>\n<GPS>\n";
print OUT <<EOF
<!--  GNAT runtime browsing support.

      This package provides a new menu /Help/GNAT Runtime, which you
      can use to quickly browse the list of standard Ada runtime
      units, as well as the GNAT specific runtime.
      Whenever you select an entry in this menu, the corresponding
      spec file is displayed.
      This file is automatically generated.
-->
EOF
;

$units{"System"} = "system";
$units{"Interfaces"} = "interfac";
$mode="";

foreach $line (<IMPUNIT>) {
   chomp ($line);
   if ($line =~ /Non_Imp_File_Names_05/) {
       $mode = "Ada 2005/";
   } elsif ($line =~ /"([^"]+)",\s*-- (.*)/) {
       $filename=$1;
       $unit=$2;
       $units{$unit} = $filename;
       $mode{$unit} = $mode;
   }
}

print OUT "<submenu before=\"About\">
   <title>/Help/GNAT Runtime</title>
</submenu>\n";

foreach $unit (sort keys %units) {
  $filename = $units{$unit};
  $filename =~ s/\s*$//g;

  if (! $expand_hierarchies) {
    $double_unit = $unit;
    $double_unit =~ s/_/__/g;
    ($hierarchy) = ($double_unit =~ /^([^.]+)\./);
    $hierarchy = $double_unit if ($hierarchy eq "");
    $menu = "/Help/GNAT Runtime/$mode{$unit}$hierarchy/$double_unit";
  } else {
    ## Hierarchy parents must have two menu entries, or every time a
    ## submenu is open, the file is also open

    $hierarchy = $unit; 
    $hierarchy =~ s/_/__/g;
    $hierarchy =~ s/\./\//g;
    ($base_unit) = ($hierarchy =~ /\/([^\/]+)$/);

    foreach $child (keys %units) {
       if ($child =~ /^$unit\./ && ($mode{$unit} eq $mode{$child})) {
         $hierarchy .= "/&lt;$base_unit&gt;";
         last;
       }
    }

    $menu = "/Help/GNAT Runtime/$mode{$unit}$hierarchy";
  }
       
  print OUT "<documentation_file>
   <shell>Editor.edit \"$filename.ads\"</shell>
   <descr>$unit</descr>
   <menu>$menu</menu>
   <category>GNAT Runtime</category>
</documentation_file>\n";
}

print OUT "</GPS>";

close (IMPUNIT);
close (OUT);
