-------------------------------------------------------------------------------
--                                                                           --
--             GNat Ada Database Environment - GNADE                         --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gsql.adb,v $
--  Description     : Small query client based upon odbc
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/06/09 09:05:06 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;             use Ada.Strings.Unbounded;
with Ada.Text_IO;                       use Ada.Text_IO;
with Ada.Command_Line;                  use Ada.Command_Line;
with Ada.Exceptions;                    use Ada.Exceptions;

-- GUI components
with GUI_Window;                        use GUI_Window;
with GUI_Menu;                          use GUI_Menu;

-- Application handlers
with Query_Handler;                     use Query_Handler;
with Table_Handler;                     use Table_Handler;
with Procedure_Handler;                 use Procedure_Handler;
with Datasource_Handler;                use Datasource_Handler;

-- other components
with Project_File;                      use Project_File;
with Environment;                       use Environment;

----------
-- GSQL --
----------
procedure GSQL is

   Version : constant String := "$Id: gsql.adb,v 1.15 2002/06/09 09:05:06 merdmann Exp $";

   Arg     : Integer := 1;

   procedure Help is
   begin
      Put_Line("");
      Put_Line("usage: gsql [-p projectfile] [-h]");
      Put_Line("");
      Put_Line(" -p projectfile   - use a project file for execution. If not ");
      Put_Line("                    given, the file default.prj is used.     ");
      Put_Line(" -h               - This message");
      Put_Line("");
   end Help;

begin
   Put_Line("");
   Put_Line("GNADE SQL (GSQL) Grafical User Interface, Version " &
                    GUI_Window.Version);
   Put_Line("Copyright (C) 2001-2002 Michael Erdmann");
   Put_Line("");

   -------------------------
   -- Handle command line --
   -------------------------
   Project_File.File_Name := To_Unbounded_String("default.prj");

   while Arg <= Argument_Count loop
      if Argument(Arg) = "-p" then
         Arg := Arg + 1;
         Project_File.File_Name := To_Unbounded_String( Argument(Arg) );
      elsif Argument(Arg) = "-h" then
         Help;
         Set_Exit_Status( 1 );
         return;
      elsif Argument(Arg)(1) = '-' then
         Put_Line("*** Error unknown switch " & Argument(Arg));
         Help;
         Set_Exit_Status( 1 );
         return;
      end if;

      Arg := Arg + 1;
   end loop;

   -----------------------
   -- Start Application --
   -----------------------
   Project_File.Open( Quiet => True );
   Environment.Initialize;

   GUI_Menu.Initialize;
   GUI_Window.Initialize;

   Query_Handler.Initialize;
   Table_Handler.Initialize;
   Procedure_Handler.Initialize;
   Datasource_Handler.Initialize;

   -------------------------
   -- Execute Application --
   -------------------------
   GUI_Window.Main;

   ----------------------
   -- Stop Application --
   ----------------------
   Query_Handler.Finalize;
   Table_Handler.Finalize;
   Procedure_Handler.Finalize;
   Datasource_Handler.Finalize;

   GUI_Menu.Finalize;
   GUI_Window.Finalize;

   Environment.Finalize;
   ----------------------
   -- Save Environment --
   ----------------------
   if not GUI_Menu.Dont_Save then
      Project_File.Save;
   else
      Put_Line("Project not saved!");
   end if;

   Set_Exit_Status( 0 );

   -----------------------
   -- Handle Exceptions --
   -----------------------
exception
   when The_Error : Others =>
      Put_Line("Exception " & Exception_Name( The_Error ) & " occured " );
      Put_Line("          " & Exception_Message( The_Error ) );

      Set_Exit_Status( 1 );
end GSQL;
