#include <glib-object.h>

#include <string.h>
#include <stdio.h>

#include <gmyth/gmyth_uri.h>
#include <gmyth/gmyth_backendinfo.h>
#include <gmyth/gmyth_socket.h>
#include <gmyth/gmyth_query.h>

#include "common.h"

static          gboolean
test_backend_connection1(GMythBackendInfo * backend_info)
{
    GMythSocket    *socket = gmyth_socket_new();
    if (gmyth_socket_connect_with_timeout(socket,
                                          gmyth_backend_info_get_hostname
                                          (backend_info),
                                          gmyth_backend_info_get_port
                                          (backend_info), 4) == TRUE) {
        g_object_unref(socket);
        g_debug("Socket connection success");
        return TRUE;
    } else {
        g_debug("Connection failed");
        return FALSE;
    }
}

static          gboolean
test_backend_connection2(GMythBackendInfo * backend_info)
{
    GMythSocket    *socket = gmyth_socket_new();
    if (gmyth_socket_connect_to_backend(socket,
                                        gmyth_backend_info_get_hostname
                                        (backend_info),
                                        gmyth_backend_info_get_port
                                        (backend_info), TRUE) == TRUE) {


        g_object_unref(socket);

        g_debug("Backend socket connection success");
        return TRUE;
    } else {
        g_debug("Connection failed");
        return FALSE;
    }
}

static          gboolean
test_mysql_connection1(GMythBackendInfo * backend_info)
{
    GMythQuery     *query = gmyth_query_new();

    if (gmyth_query_connect_with_timeout(query, backend_info, 3) == TRUE) {
        g_object_unref(query);
        g_debug("Mysql connection success");
        return TRUE;
    } else {
        g_debug("Mysql connection failed");
        return FALSE;
    }

}


int
main(int args, const char **argv)
{
    GMythBackendInfo *backend_info;
    g_type_init();
    g_thread_init(NULL);

    backend_info = gmyth_backend_info_new_with_uri(argv[1]);

    test_backend_connection1(backend_info);
    test_backend_connection2(backend_info);
    test_mysql_connection1(backend_info);

    fprintf(stdout, SYNC_STRING);
    fflush(NULL);
    getchar();

    if (backend_info != NULL)
        g_object_unref(backend_info);

    return (0);

}
