/**
 * GMyth Library
 *
 * @file gmyth/gmyth_file_local_local.h
 * 
 * @brief <p> GMythFileLocal is the parent GMythFile that deals with the file streaming 
 * media local transfering from the MythTV backend.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia.
 * @author Rosfran Lins Borges <rosfran.borges@indt.org.br>
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __GMYTH_FILE_LOCAL_H__
#define __GMYTH_FILE_LOCAL_H__

#include <glib-object.h>
#include <glib.h>

#include "gmyth_file.h"
#include "gmyth_uri.h"
#include "gmyth_backendinfo.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

G_BEGIN_DECLS
#define GMYTH_FILE_LOCAL_TYPE               (gmyth_file_local_get_type ())
#define GMYTH_FILE_LOCAL(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GMYTH_FILE_LOCAL_TYPE, GMythFileLocal))
#define GMYTH_FILE_LOCAL_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_FILE_LOCAL_TYPE, GMythFileLocalClass))
#define IS_GMYTH_FILE_LOCAL(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GMYTH_FILE_LOCAL_TYPE))
#define IS_GMYTH_FILE_LOCAL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GMYTH_FILE_LOCAL_TYPE))
#define GMYTH_FILE_LOCAL_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GMYTH_FILE_LOCAL_TYPE, GMythFileLocalClass))
typedef struct _GMythFileLocal GMythFileLocal;
typedef struct _GMythFileLocalClass GMythFileLocalClass;
typedef struct _GMythFileLocalPrivate GMythFileLocalPrivate;

struct _GMythFileLocal {
    GMythFile       parent;
};

struct _GMythFileLocalClass {
    GMythFileClass  parent_class;
};


GType           gmyth_file_local_get_type(void);
GMythFileLocal *gmyth_file_local_new(GMythBackendInfo * backend_info);
GMythFileLocal *gmyth_file_local_new_with_uri(const gchar * uri);
gchar          *gmyth_file_local_get_file_name(GMythFileLocal *
                                               file_local);
void            gmyth_file_local_set_file_name(GMythFileLocal * file_local,
                                               const gchar * filename);
gboolean        gmyth_file_local_open(GMythFileLocal * file_local);
void            gmyth_file_local_close(GMythFileLocal * file_local);
gboolean        gmyth_file_local_is_open(GMythFileLocal * file_local);

GMythFileReadResult
gmyth_file_local_read(GMythFileLocal * file_local,
                      GByteArray * data, gint size,
                      gboolean read_unlimited);

gint64          gmyth_file_local_seek(GMythFileLocal * file_local,
                                      gint64 pos, GSeekType whence);

guint64         gmyth_file_local_get_filesize(GMythFileLocal * file_local);
void            gmyth_file_local_set_filesize(GMythFileLocal * file,
                                              guint64 filesize);

gint64          gmyth_file_local_get_offset(GMythFileLocal * file_local);
void            gmyth_file_local_set_offset(GMythFileLocal * file_local,
                                            gint64 offset);

G_END_DECLS
#endif                          /* __GMYTH_FILE_LOCAL_H__ */
