/* mmkeys.c generated by valac, the Vala compiler
 * generated from mmkeys.vala, do not modify */

/* Gnome Music Player Client Multimedia Keys plugin (gmpc-mmkeys)
 * Copyright (C) 2009 Qball Cow <qball@sarine.nl>
 * Project homepage: http://gmpc.wikia.com/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gmpc-extras.h>
#include <plugin.h>
#include <config1.h>
#include <dbus/dbus.h>


#define TYPE_MEDIA_KEYS (media_keys_get_type ())
#define MEDIA_KEYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_KEYS, MediaKeys))
#define IS_MEDIA_KEYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_KEYS))
#define MEDIA_KEYS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MEDIA_KEYS, MediaKeysIface))

typedef struct _MediaKeys MediaKeys;
typedef struct _MediaKeysIface MediaKeysIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaKeysDBusProxy MediaKeysDBusProxy;
typedef DBusGProxyClass MediaKeysDBusProxyClass;

#define TYPE_MM_KEYS (mm_keys_get_type ())
#define MM_KEYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MM_KEYS, MMKeys))
#define MM_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MM_KEYS, MMKeysClass))
#define IS_MM_KEYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MM_KEYS))
#define IS_MM_KEYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MM_KEYS))
#define MM_KEYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MM_KEYS, MMKeysClass))

typedef struct _MMKeys MMKeys;
typedef struct _MMKeysClass MMKeysClass;
typedef struct _MMKeysPrivate MMKeysPrivate;
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _MediaKeysIface {
	GTypeInterface parent_iface;
	void (*GrabMediaPlayerKeys) (MediaKeys* self, const char* application, guint32 time, GError** error);
	void (*ReleaseMediaPlayerKeys) (MediaKeys* self, const char* application, GError** error);
};

struct _MediaKeysDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _MMKeys {
	GmpcPluginBase parent_instance;
	MMKeysPrivate * priv;
};

struct _MMKeysClass {
	GmpcPluginBaseClass parent_class;
};

struct _MMKeysPrivate {
	DBusGConnection* conn;
	MediaKeys* keys;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer mm_keys_parent_class = NULL;

GType media_keys_get_type (void);
void media_keys_GrabMediaPlayerKeys (MediaKeys* self, const char* application, guint32 time, GError** error);
void media_keys_ReleaseMediaPlayerKeys (MediaKeys* self, const char* application, GError** error);
void media_keys_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _media_keys_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult media_keys_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_media_keys_introspect (MediaKeys* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_keys_property_get_all (MediaKeys* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_keys_GrabMediaPlayerKeys (MediaKeys* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_media_keys_ReleaseMediaPlayerKeys (MediaKeys* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_media_keys_media_player_key_pressed (GObject* _sender, const char* application, const char* keys, DBusConnection* _connection);
GType media_keys_dbus_proxy_get_type (void);
MediaKeys* media_keys_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_media_keys_media_player_key_pressed (MediaKeys* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult media_keys_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MEDIA_KEYS_DBUS_PROXY_DUMMY_PROPERTY
};
static void media_keys_dbus_proxy_GrabMediaPlayerKeys (MediaKeys* self, const char* application, guint32 time, GError** error);
static void media_keys_dbus_proxy_ReleaseMediaPlayerKeys (MediaKeys* self, const char* application, GError** error);
static void media_keys_dbus_proxy_media_keys__interface_init (MediaKeysIface* iface);
static void media_keys_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void media_keys_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType mm_keys_get_type (void);
#define MM_KEYS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MM_KEYS, MMKeysPrivate))
enum  {
	MM_KEYS_DUMMY_PROPERTY
};
static void mm_keys_real_set_enabled (GmpcPluginBase* base, gboolean enabled);
static const char* mm_keys_real_get_name (GmpcPluginBase* base);
static gint* mm_keys_real_get_version (GmpcPluginBase* base, int* result_length1);
static void mm_keys_callback (MMKeys* self, MediaKeys* mkeys, const char* application, const char* keys);
MMKeys* mm_keys_new (void);
MMKeys* mm_keys_construct (GType object_type);
static void _mm_keys_callback_media_keys_media_player_key_pressed (MediaKeys* _sender, const char* application, const char* keys, gpointer self);
static GObject * mm_keys_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void mm_keys_finalize (GObject* obj);
GType plugin_get_type (void);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _media_keys_dbus_path_vtable = {_media_keys_dbus_unregister, media_keys_dbus_message};
static const _DBusObjectVTable _media_keys_dbus_vtable = {media_keys_dbus_register_object};
static const gint MM_KEYS_pversion[] = {0, 0, 0};

static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void media_keys_GrabMediaPlayerKeys (MediaKeys* self, const char* application, guint32 time, GError** error) {
	MEDIA_KEYS_GET_INTERFACE (self)->GrabMediaPlayerKeys (self, application, time, error);
}


void media_keys_ReleaseMediaPlayerKeys (MediaKeys* self, const char* application, GError** error) {
	MEDIA_KEYS_GET_INTERFACE (self)->ReleaseMediaPlayerKeys (self, application, error);
}


void _media_keys_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_media_keys_introspect (MediaKeys* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.SettingsDaemon.MediaKeys\">\n  <method name=\"GrabMediaPlayerKeys\">\n    <arg name=\"application\" type=\"s\" direction=\"in\"/>\n    <arg name=\"time\" type=\"u\" direction=\"in\"/>\n  </method>\n  <method name=\"ReleaseMediaPlayerKeys\">\n    <arg name=\"application\" type=\"s\" direction=\"in\"/>\n  </method>\n  <signal name=\"MediaPlayerKeyPressed\">\n    <arg name=\"application\" type=\"s\"/>\n    <arg name=\"keys\" type=\"s\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_keys_property_get_all (MediaKeys* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.gnome.SettingsDaemon.MediaKeys") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_keys_GrabMediaPlayerKeys (MediaKeys* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* application = NULL;
	const char* _tmp1_;
	guint32 time = 0U;
	dbus_uint32_t _tmp2_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "su")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	application = g_strdup (_tmp1_);
	dbus_message_iter_get_basic (&iter, &_tmp2_);
	dbus_message_iter_next (&iter);
	time = _tmp2_;
	media_keys_GrabMediaPlayerKeys (self, application, time, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (application);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_media_keys_ReleaseMediaPlayerKeys (MediaKeys* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* application = NULL;
	const char* _tmp3_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp3_);
	dbus_message_iter_next (&iter);
	application = g_strdup (_tmp3_);
	media_keys_ReleaseMediaPlayerKeys (self, application, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (application);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult media_keys_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_media_keys_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_media_keys_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.SettingsDaemon.MediaKeys", "GrabMediaPlayerKeys")) {
		result = _dbus_media_keys_GrabMediaPlayerKeys (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.SettingsDaemon.MediaKeys", "ReleaseMediaPlayerKeys")) {
		result = _dbus_media_keys_ReleaseMediaPlayerKeys (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_media_keys_media_player_key_pressed (GObject* _sender, const char* application, const char* keys, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp4_;
	const char* _tmp5_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.SettingsDaemon.MediaKeys", "MediaPlayerKeyPressed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp4_ = application;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp4_);
	_tmp5_ = keys;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp5_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void media_keys_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_media_keys_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "media-player-key-pressed", (GCallback) _dbus_media_keys_media_player_key_pressed, connection);
}


static void media_keys_base_init (MediaKeysIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("media_player_key_pressed", TYPE_MEDIA_KEYS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
		g_type_set_qdata (TYPE_MEDIA_KEYS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_media_keys_dbus_vtable));
	}
}


GType media_keys_get_type (void) {
	static volatile gsize media_keys_type_id__volatile = 0;
	if (g_once_init_enter (&media_keys_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaKeysIface), (GBaseInitFunc) media_keys_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType media_keys_type_id;
		media_keys_type_id = g_type_register_static (G_TYPE_INTERFACE, "MediaKeys", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (media_keys_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (media_keys_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &media_keys_dbus_proxy_get_type);
		g_once_init_leave (&media_keys_type_id__volatile, media_keys_type_id);
	}
	return media_keys_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MediaKeysDBusProxy, media_keys_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MEDIA_KEYS, media_keys_dbus_proxy_media_keys__interface_init) );
MediaKeys* media_keys_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	MediaKeys* self;
	self = g_object_new (media_keys_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.SettingsDaemon.MediaKeys", NULL);
	return self;
}


static GObject* media_keys_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (media_keys_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), media_keys_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_media_keys_media_player_key_pressed (MediaKeys* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	const char* application = NULL;
	const char* _tmp6_;
	const char* keys = NULL;
	const char* _tmp7_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	application = g_strdup (_tmp6_);
	dbus_message_iter_get_basic (&iter, &_tmp7_);
	dbus_message_iter_next (&iter);
	keys = g_strdup (_tmp7_);
	g_signal_emit_by_name (self, "media-player-key-pressed", application, keys);
}


DBusHandlerResult media_keys_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.SettingsDaemon.MediaKeys", "MediaPlayerKeyPressed")) {
			_dbus_handle_media_keys_media_player_key_pressed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void media_keys_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((MediaKeysDBusProxy*) self)->disposed) {
		return;
	}
	((MediaKeysDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), media_keys_dbus_proxy_filter, self);
	G_OBJECT_CLASS (media_keys_dbus_proxy_parent_class)->dispose (self);
}


static void media_keys_dbus_proxy_class_init (MediaKeysDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = media_keys_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = media_keys_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = media_keys_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = media_keys_dbus_proxy_set_property;
}


static void media_keys_dbus_proxy_init (MediaKeysDBusProxy* self) {
}


static void media_keys_dbus_proxy_GrabMediaPlayerKeys (MediaKeys* self, const char* application, guint32 time, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp8_;
	dbus_uint32_t _tmp9_;
	if (((MediaKeysDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.SettingsDaemon.MediaKeys", "GrabMediaPlayerKeys");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp8_ = application;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp8_);
	_tmp9_ = time;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp9_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp10_;
			_edomain = DBUS_GERROR;
			_tmp10_ = _dbus_error.name + 27;
			if (strcmp (_tmp10_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp10_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp10_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp10_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp10_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp10_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp10_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp10_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp10_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp10_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp10_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp10_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp10_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp10_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp10_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp10_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp10_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp10_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp10_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp10_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp10_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp10_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp10_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp10_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp10_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp10_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp10_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp10_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp10_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp10_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp10_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void media_keys_dbus_proxy_ReleaseMediaPlayerKeys (MediaKeys* self, const char* application, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp11_;
	if (((MediaKeysDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.SettingsDaemon.MediaKeys", "ReleaseMediaPlayerKeys");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp11_ = application;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp11_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp12_;
			_edomain = DBUS_GERROR;
			_tmp12_ = _dbus_error.name + 27;
			if (strcmp (_tmp12_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp12_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp12_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp12_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp12_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp12_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp12_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp12_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp12_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp12_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp12_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp12_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp12_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp12_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp12_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp12_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp12_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp12_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp12_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp12_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp12_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp12_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp12_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp12_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp12_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp12_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp12_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp12_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp12_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp12_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp12_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp12_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp12_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error_literal (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void media_keys_dbus_proxy_media_keys__interface_init (MediaKeysIface* iface) {
	iface->GrabMediaPlayerKeys = media_keys_dbus_proxy_GrabMediaPlayerKeys;
	iface->ReleaseMediaPlayerKeys = media_keys_dbus_proxy_ReleaseMediaPlayerKeys;
}


static void media_keys_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void media_keys_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void mm_keys_real_set_enabled (GmpcPluginBase* base, gboolean enabled) {
	MMKeys * self;
	GError * _inner_error_;
	gboolean old;
	gboolean _tmp0_ = FALSE;
	self = (MMKeys*) base;
	_inner_error_ = NULL;
	old = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (gmpc_plugin_base_get_name ((GmpcPluginBase*) self) != NULL) {
		cfg_set_single_value_as_int (config, gmpc_plugin_base_get_name ((GmpcPluginBase*) self), "enabled", (gint) enabled);
	}
	if (enabled == TRUE) {
		_tmp0_ = old == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			media_keys_GrabMediaPlayerKeys (self->priv->keys, "gmpc", (guint32) ((guint) 0), &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch0_dbus_gerror;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally0;
		__catch0_dbus_gerror:
		{
			GError * _error_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("mmkeys.vala:43: Failed to grab media keys: %s\n", _error_->message);
				_g_error_free0 (_error_);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		gboolean _tmp1_ = FALSE;
		if (enabled == FALSE) {
			_tmp1_ = old == TRUE;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			{
				media_keys_ReleaseMediaPlayerKeys (self->priv->keys, "gmpc", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch1_dbus_gerror;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			goto __finally1;
			__catch1_dbus_gerror:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("mmkeys.vala:49: Failed to release media keys: %s\n", _error_->message);
					_g_error_free0 (_error_);
				}
			}
			__finally1:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static const char* mm_keys_real_get_name (GmpcPluginBase* base) {
	MMKeys * self;
	const char* result;
	self = (MMKeys*) base;
	result = "Gnome multimedia keys plugin";
	return result;
}


static gint* mm_keys_real_get_version (GmpcPluginBase* base, int* result_length1) {
	MMKeys * self;
	gint* result;
	gint* _tmp0_;
	self = (MMKeys*) base;
	result = (_tmp0_ = MM_KEYS_pversion, *result_length1 = G_N_ELEMENTS (MM_KEYS_pversion), _tmp0_);
	return result;
}


static void mm_keys_callback (MMKeys* self, MediaKeys* mkeys, const char* application, const char* keys) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mkeys != NULL);
	g_return_if_fail (application != NULL);
	g_return_if_fail (keys != NULL);
	if (gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self) == FALSE) {
		return;
	}
	if (_vala_strcmp0 (application, "gmpc") != 0) {
		return;
	}
	if (_vala_strcmp0 (keys, "Play") == 0) {
		if (mpd_player_get_state (connection) == MPD_STATUS_STATE_PLAY) {
			mpd_player_pause (connection);
		} else {
			mpd_player_play (connection);
		}
	} else {
		if (_vala_strcmp0 (keys, "Pause") == 0) {
			mpd_player_pause (connection);
		} else {
			if (_vala_strcmp0 (keys, "Next") == 0) {
				mpd_player_next (connection);
			} else {
				if (_vala_strcmp0 (keys, "Previous") == 0) {
					mpd_player_prev (connection);
				} else {
					if (_vala_strcmp0 (keys, "Stop") == 0) {
						mpd_player_stop (connection);
					}
				}
			}
		}
	}
}


MMKeys* mm_keys_construct (GType object_type) {
	MMKeys * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


MMKeys* mm_keys_new (void) {
	return mm_keys_construct (TYPE_MM_KEYS);
}


static void _mm_keys_callback_media_keys_media_player_key_pressed (MediaKeys* _sender, const char* application, const char* keys, gpointer self) {
	mm_keys_callback (self, _sender, application, keys);
}


static GObject * mm_keys_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MMKeys * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (mm_keys_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MM_KEYS (obj);
	_inner_error_ = NULL;
	{
		DBusGConnection* _tmp13_;
		DBusGConnection* _tmp14_;
		MediaKeys* _tmp15_;
		((GmpcPluginBase*) self)->plugin_type = 4;
		_tmp13_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->priv->conn = (_tmp14_ = _tmp13_, _dbus_g_connection_unref0 (self->priv->conn), _tmp14_);
		self->priv->keys = (_tmp15_ = media_keys_dbus_proxy_new (self->priv->conn, "org.gnome.SettingsDaemon", "/org/gnome/SettingsDaemon/MediaKeys"), _g_object_unref0 (self->priv->keys), _tmp15_);
		if (gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self)) {
			{
				media_keys_GrabMediaPlayerKeys (self->priv->keys, "gmpc", (guint32) ((guint) 0), &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch2_dbus_gerror;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
				}
			}
			goto __finally2;
			__catch2_dbus_gerror:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("mmkeys.vala:86: Failed to grab media keys: %s\n", _error_->message);
					_g_error_free0 (_error_);
				}
			}
			__finally2:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
		}
		g_signal_connect_object (self->priv->keys, "media-player-key-pressed", (GCallback) _mm_keys_callback_media_keys_media_player_key_pressed, self, 0);
	}
	return obj;
}


static void mm_keys_class_init (MMKeysClass * klass) {
	mm_keys_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MMKeysPrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = mm_keys_real_set_enabled;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = mm_keys_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = mm_keys_real_get_version;
	G_OBJECT_CLASS (klass)->constructor = mm_keys_constructor;
	G_OBJECT_CLASS (klass)->finalize = mm_keys_finalize;
}


static void mm_keys_instance_init (MMKeys * self) {
	self->priv = MM_KEYS_GET_PRIVATE (self);
}


static void mm_keys_finalize (GObject* obj) {
	MMKeys * self;
	GError * _inner_error_;
	self = MM_KEYS (obj);
	_inner_error_ = NULL;
	{
		if (gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self)) {
			{
				media_keys_ReleaseMediaPlayerKeys (self->priv->keys, "gmpc", &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						goto __catch3_dbus_gerror;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
				}
			}
			goto __finally3;
			__catch3_dbus_gerror:
			{
				GError * _error_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				{
					g_warning ("mmkeys.vala:96: Failed to release media keys: %s\n", _error_->message);
					_g_error_free0 (_error_);
				}
			}
			__finally3:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
		}
	}
	_dbus_g_connection_unref0 (self->priv->conn);
	_g_object_unref0 (self->priv->keys);
	G_OBJECT_CLASS (mm_keys_parent_class)->finalize (obj);
}


GType mm_keys_get_type (void) {
	static volatile gsize mm_keys_type_id__volatile = 0;
	if (g_once_init_enter (&mm_keys_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MMKeysClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mm_keys_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MMKeys), 0, (GInstanceInitFunc) mm_keys_instance_init, NULL };
		GType mm_keys_type_id;
		mm_keys_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "MMKeys", &g_define_type_info, 0);
		g_once_init_leave (&mm_keys_type_id__volatile, mm_keys_type_id);
	}
	return mm_keys_type_id__volatile;
}


GType plugin_get_type (void) {
	GType result;
	result = TYPE_MM_KEYS;
	return result;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}



