/*
    Glurp - A GTK+ client for Music Player Daemon
    Copyright (C) 2004, 2005 Andrej Kacian

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    http://musicpd.org/glurp.shtml

*/

#include "libmpdclient.h"

enum {
    PL_FILENAME,
    PL_ARTIST,
    PL_TITLE,
    PL_ALBUM,
    PL_TRACK,
    PL_NAME,
    PL_POS,
    PL_ID,

    PL_BOLD,
    PL_BOLD_SET,

    NUM_PL
};

struct conf_t {
    gchar *server_host;
    gint  server_port;
    gchar *server_pass;
    gboolean autoconnect;
    gboolean playlist_vis_on_start;
    gboolean time_display_left;
    gboolean save_size;
    long refresh_rate;
    gint pos_x;
    gint pos_y;
    gint width;
    gint height;

    gboolean playlist_columns[PL_BOLD];
};

typedef struct conf_t GlurpConfig;

struct song_t {
    gchar *file;
    gchar *artist;
    gchar *title;
    gchar *album;
    gchar *track;
    gchar *name;
    gint time;
    gint pos;
    gint id;
    struct song_t *next;
};

typedef struct song_t GlurpSong;

struct pl_t {
    gchar *name;
    struct pl_t *next;
};

typedef struct pl_t GlurpPl;

struct stream_t {
    gchar *url;
    struct stream_t *next;
};

typedef struct stream_t GlurpStream;

struct glurp_t {
    GlurpConfig *config;
    mpd_Connection *conn;
    GlurpSong *playlist;
    GlurpSong *current_song;
    GtkListStore *gui_playlist;
    GtkListStore *gui_playlist_list;
    GtkListStore *gui_stream_list;
    GtkTreeStore *gui_addtree;
    gboolean progress_dragging;
    gint refresh_rate_status;
    long long playlist_version;
    GlurpPl *playlists;
    gint statusbar_status;
    gint conn_state;
    gint play_state;
    gint prev_song_num;
    gint scroll;
    gint num_add_dirs;
    gboolean updating_db;
    GlurpStream *stream_history;
};

typedef struct glurp_t GlurpState;
