#ifndef __GLUNARCLOCK_H__
#define __GLUNARCLOCK_H__ 1

/* glunarclock.h
 * A lunar clock applet for gnome.
 *
 * Copyright (C) 2000-2003 Josh Buhl <jbuhl@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file COPYING); if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA
 *
 */

#include <config.h>
#include <string.h>

#include <glib-object.h>
#include <gtk/gtk.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>
#include <gconf/gconf-client.h>
#include <libgnomeui/libgnomeui.h>
#include <libart_lgpl/libart.h>
#include <glade/glade-xml.h>

#include <egg-screen-help.h>

#define MOON_APPLET(o) (G_TYPE_CHECK_INSTANCE_CAST ((o), \
			moon_applet_get_type(),          \
			MoonApplet))
#define MOON_IS_APPLET(o) (G_TYPE_CHECK_INSTANCE_TYPE ((o), \
			   MOON_TYPE_APPLET))

#define N_MOON_PREFS 7

G_BEGIN_DECLS

typedef enum {ROTATE, MIRROR} RotationType;

typedef struct {
	PanelApplet        applet;

	GConfClient       *client;

	char              *image;
	int                n_frames;
	gboolean           flip;
	gboolean           is_north;
	gboolean           is_east;
	gfloat             latitude;
        gfloat             longitude;

	RotationType       rotation_type;

	PanelAppletOrient  orientation;

	GtkWidget         *frame;
	GtkWidget         *drawing_area;
	GdkRectangle       prev_allocation;
	GdkPixmap         *pixmap;
	guint              timeout;
	int                image_number;

	GdkPixbuf         *image_pb;
	GdkPixbuf         *hilit_image_pb;

	GtkWidget         *about_dialog;
	GtkWidget         *preferences_dialog;
	GtkWidget         *moondata_dialog;

	GtkWidget         *pixmap_entry;
	GtkWidget         *image_entry;
	GtkWidget         *frames_spin;
	GtkWidget         *latitude_spin;
	GtkWidget         *longitude_spin;
	GtkWidget         *rotate_toggle;
	GtkWidget         *flip_toggle;
	GtkWidget         *lat_radio;
	GtkWidget         *long_radio;

	guint              listeners [N_MOON_PREFS];
} MoonApplet;

typedef struct {
	PanelAppletClass klass;
} MoonAppletClass;

void show_help (MoonApplet *moon, const char *link_id);

G_END_DECLS

#endif				/* !__GLUNARCLOCK_H__ */
