/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __GTK_LOUPE_H__
#define __GTK_LOUPE_H__


G_BEGIN_DECLS



#define GTK_TYPE_LOUPE		    (gtk_loupe_get_type ())
#define GTK_LOUPE(obj)		    (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_LOUPE, GtkLoupe))
#define GTK_LOUPE_CLASS(klass)	    (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_LOUPE, GtkLoupeClass))
#define GTK_IS_LOUPE(obj)	    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_LOUPE))
#define GTK_IS_LOUPE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LOUPE))
#define GTK_LOUPE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_LOUPE, GtkLoupeClass))


typedef struct _GtkLoupe       GtkLoupe;
typedef struct _GtkLoupeClass  GtkLoupeClass;

struct _GtkLoupe
{
  GtkDrawingArea drawing_area;

  gint h_magnification;
  gint v_magnification;


  gint timeout_tag;
  gint interval;
};

struct _GtkLoupeClass
{
  GtkDrawingAreaClass parent_class;
};


GType      gtk_loupe_get_type          (void) G_GNUC_CONST;

GtkWidget* gtk_loupe_new               (void);
void       gtk_loupe_set_magnification (GtkLoupe *loupe,
					gint      h_magnification,
					gint      v_magnification);
void       gtk_loupe_start_auto_update (GtkLoupe *loupe);
void       gtk_loupe_stop_auto_update  (GtkLoupe *loupe);



G_END_DECLS


#endif /* __GTK_LOUPE_H__ */
