// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_ACTION_H
#define _GIOMM_ACTION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2011 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <glibmm/varianttype.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GActionInterface GActionInterface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GAction GAction;
typedef struct _GActionClass GActionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Action_Class; } // namespace Gio
namespace Glib
{

class VariantBase;

}

namespace Gio
{

/** Action - An action.
 * Action represents a single named action.
 *
 * The main interface to an action is that it can be activated with activate().
 * This results in the signal_activate() signal being emitted. An activation
 * has a Glib::VariantBase parameter (which may be <tt>0</tt>). The correct
 * type for the parameter is determined by a static parameter type (which is
 * given at construction time).
 *
 * An action may optionally have a state, in which case the state may be set
 * with change_state(). This call takes a Glib::VariantBase. The correct type
 * for the state is determined by a static state type (which is given at
 * construction time).
 *
 * The state may have a hint associated with it, specifying its valid range.
 *
 * Action is merely the interface to the concept of an action, as described
 * above. Various implementations of actions exist, including SimpleAction and
 * Gtk::Action.
 *
 * In all cases, the implementing class is responsible for storing the name of
 * the action, the parameter type, the enabled state, the optional state type
 * and the state and emitting the appropriate signals when these change. The
 * implementor responsible for filtering calls to activate() and change_state()
 * for type safety and for the state being enabled.
 *
 * Probably the only useful thing to do with a Action is to put it inside of a
 * SimpleActionGroup.
 *
 * @newin{2,32}
 */

class Action : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Action CppObjectType;
  typedef Action_Class CppClassType;
  typedef GAction BaseObjectType;
  typedef GActionInterface BaseClassType;

private:
  friend class Action_Class;
  static CppClassType action_class_;

  // noncopyable
  Action(const Action&);
  Action& operator=(const Action&);

protected:
  Action(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Action(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Action(GAction* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Action();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GAction*       gobj()       { return reinterpret_cast<GAction*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GAction* gobj() const { return reinterpret_cast<GAction*>(gobject_); }

private:


public:
  
  /** Queries the name of @a action.
   * 
   * @newin{2,28}
   * @return The name of the action.
   */
  Glib::ustring get_name() const;
  
  /** Queries the type of the parameter that must be given when activating
   *  @a action.
   * 
   * When activating the action using g_action_activate(), the Variant
   * given to that function must be of the type returned by this function.
   * 
   * In the case that this function returns <tt>0</tt>, you must not give any
   * Variant, but <tt>0</tt> instead.
   * 
   * @newin{2,28}
   * @return The parameter type.
   */
  Glib::VariantType get_parameter_type() const;
  
  /** Queries the type of the state of @a action.
   * 
   * If the action is stateful (e.g. created with
   * g_simple_action_new_stateful()) then this function returns the
   * VariantType of the state.  This is the type of the initial value
   * given as the state. All calls to g_action_change_state() must give a
   * Variant of this type and g_action_get_state() will return a
   * Variant of the same type.
   * 
   * If the action is not stateful (e.g. created with g_simple_action_new())
   * then this function will return <tt>0</tt>. In that case, g_action_get_state()
   * will return <tt>0</tt> and you must not call g_action_change_state().
   * 
   * @newin{2,28}
   * @return The state type, if the action is stateful.
   */
  Glib::VariantType get_state_type() const;
  
  /** Requests a hint about the valid range of values for the state of
   *  @a action.
   * 
   * If <tt>0</tt> is returned it either means that the action is not stateful
   * or that there is no hint about the valid range of values for the
   * state of the action.
   * 
   * If a Variant array is returned then each item in the array is a
   * possible value for the state.  If a Variant pair (ie: two-tuple) is
   * returned then the tuple specifies the inclusive lower and upper bound
   * of valid values for the state.
   * 
   * In any case, the information is merely a hint.  It may be possible to
   * have a state value outside of the hinted range and setting a value
   * within the range may fail.
   * 
   * The return value (if non-<tt>0</tt>) should be freed with
   * Glib::variant_unref() when it is no longer required.
   * 
   * @newin{2,28}
   * @return The state range hint.
   */
  void get_state_hint() const;
  
  /** Checks if @a action is currently enabled.
   * 
   * An action must be enabled in order to be activated or in order to
   * have its state changed from outside callers.
   * 
   * @newin{2,28}
   * @return Whether the action is enabled.
   */
  bool get_enabled() const;
  
  /** Queries the current state of @a action.
   * 
   * If the action is not stateful then <tt>0</tt> will be returned.  If the
   * action is stateful then the type of the return value is the type
   * given by g_action_get_state_type().
   * 
   * The return value (if non-<tt>0</tt>) should be freed with
   * Glib::variant_unref() when it is no longer required.
   * 
   * @newin{2,28}
   * @return The current state of the action.
   */
  void get_state() const;

  
  /** Request for the state of @a action to be changed to @a value.
   * 
   * The action must be stateful and @a value must be of the correct type.
   * See g_action_get_state_type().
   * 
   * This call merely requests a change.  The action may refuse to change
   * its state or may change its state to something other than @a value.
   * See g_action_get_state_hint().
   * 
   * If the @a value GVariant is floating, it is consumed.
   * 
   * @newin{2,30}
   * @param value The new state.
   */
  void change_state(const Glib::VariantBase& value);
  
  /** Activates the action.
   * 
   *  @parameter must be the correct type of parameter for the action (ie:
   * the parameter type given at construction time).  If the parameter
   * type was <tt>0</tt> then @parameter must also be <tt>0</tt>.
   * 
   * @newin{2,28}
   * @param parameter The parameter to the activation.
   */
  void activate(const Glib::VariantBase& parameter);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_enabled() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::VariantType > property_parameter_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::VariantBase > property_state() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::VariantType > property_state_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


    virtual Glib::ustring get_name_vfunc() const;


    virtual Glib::VariantType get_parameter_type_vfunc() const;

    virtual Glib::VariantType get_state_type_vfunc() const;


    virtual Glib::VariantBase get_state_hint_vfunc() const;


    virtual bool get_enabled_vfunc() const;


    virtual Glib::VariantBase get_state_vfunc() const;


    virtual void change_state_vfunc(const Glib::VariantBase& value);

    virtual void activate_vfunc(const Glib::VariantBase& parameter);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Action
   */
  Glib::RefPtr<Gio::Action> wrap(GAction* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_ACTION_H */

